package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotEmpty;

/**
 * 功能包查询请求DTO对象
 *
 * @author 代码生成器
 */
@ApiModel(value = "DtoQueryReqDto", description = "功能包DTO查询请求DTO对象")
public class DtoQueryReqDto extends RequestDto {

    /**
     * DTO编码
     */
    @ApiModelProperty(value = "DTO编码")
    private String code;

    /**
     * DTO名称
     */
    @ApiModelProperty(value = "DTO名称")
    private String name;


    /**
     * 领域编码
     */
    @ApiModelProperty(value = "领域编码，多个用英文逗号分隔")
    private String domain;

    /**
     * 功能包编码
     */
    @NotEmpty(message = "功能包编码不能为空")
    @ApiModelProperty(value = "功能包编码")
    private String bundleCode;

    /**
     * 功能包版本号
     */
    @ApiModelProperty(value = "功能包版本号")
    private String bundleVersion;


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getBundleCode() {
        return bundleCode;
    }

    public void setBundleCode(String bundleCode) {
        this.bundleCode = bundleCode;
    }

    public String getBundleVersion() {
        return bundleVersion;
    }

    public void setBundleVersion(String bundleVersion) {
        this.bundleVersion = bundleVersion;
    }
}