/**
 * @(#)OptionDepdSettingDto 1.0 2020/5/18
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 查询配置候选项引用的联动配置项请求Dto
 *
 * @author shuangqing  2020/5/18
 */
@ApiModel(value = "OptionDepdSettingDto", description = "查询配置候选项引用的联动配置项请求Dto")
public class OptionDepdSettingDto extends BaseVo {

    /**
     * 配置项编码
     */
    @NotNull
    @ApiModelProperty(value = "配置项编码")
    private String settingCode;

    /**
     * 配置候选项编码
     */
    @NotNull
    @ApiModelProperty(value = "配置候选项编码")
    private String optionCode;

    /**
     * 业务空间编码
     */
    @ApiModelProperty(value = "业务空间编码")
    private String bizSpaceCode;

    /**
     * 业务身份编码
     */
    @ApiModelProperty(value = "业务身份编码")
    private String bizIdCode;

    public String getSettingCode() {
        return settingCode;
    }

    public void setSettingCode(String settingCode) {
        this.settingCode = settingCode;
    }

    public String getOptionCode() {
        return optionCode;
    }

    public void setOptionCode(String optionCode) {
        this.optionCode = optionCode;
    }

    public String getBizSpaceCode() {
        return bizSpaceCode;
    }

    public void setBizSpaceCode(String bizSpaceCode) {
        this.bizSpaceCode = bizSpaceCode;
    }

    public String getBizIdCode() {
        return bizIdCode;
    }

    public void setBizIdCode(String bizIdCode) {
        this.bizIdCode = bizIdCode;
    }
}
