package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 领域事件发送开关变更时的事件DTO
 */
@ApiModel(value = "SendFlagChangedEventDto", description = "领域事件发送标志变更事件")
public class SendFlagChangedEventDto implements Serializable {

    /**
     * topic
     */
    @ApiModelProperty(value = "topic")
    private String topic;

    /**
     * tag
     */
    @ApiModelProperty(value = "tag")
    private String tag;

    /**
     * 发送开关，0关闭 1开启
     */
    @ApiModelProperty(value = "发送开关，0关闭 1开启")
    private String sendFlag;

    /**
     * 领域事件的DTO编码
     */
    @ApiModelProperty(value = "领域事件的DTO编码")
    private String dtoCode;

    public String getTopic() {
        return topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getSendFlag() {
        return sendFlag;
    }

    public void setSendFlag(String sendFlag) {
        this.sendFlag = sendFlag;
    }

    public String getDtoCode() {
        return dtoCode;
    }

    public void setDtoCode(String dtoCode) {
        this.dtoCode = dtoCode;
    }
}