/**
 * @(#)SettingCreateReqDto 1.0 2020/3/2
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.yundt.cube.center.data.dto.TabularDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.base.SettingBaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author shuangqing  2020/3/2
 */
@ApiModel(value = "SettingCreateReqDto", description = "新增配置项请求dto")
public class SettingCreateReqDto extends SettingBaseDto {

    /**
     * 能力编码
     */
    @NotNull(message = "能力编码不能为空")
    @ApiModelProperty(value = "能力编码")
    private String capabilityCode;

    /**
     * 值编辑类型 (1： 输入 ；2： 选择)
     */
    @NotNull(message = "值编辑类型不能为空")
    @ApiModelProperty(value = "值编辑类型 (1： 输入 ；2： 选择)")
    private Integer editType;

    /**
     * 值类型 ( 11: 整型; 12: 数值; 13: 日期;14:布尔; 15:字符串;20:枚举; 31: SPI扩展; 32 领域事件扩展)
     */
    @NotNull(message = "值类型不能为空")
    @ApiModelProperty(value = "值类型 ( 11: 整型; 12: 数值; 13: 日期;14:布尔; 15:字符串;16:时间段; 20:枚举; 31: SPI扩展; 32 领域事件扩展)")
    private Integer valueType;

    /**
     * 来源功能包编码
     */
    @NotNull(message = "来源功能包编码不能为空")
    @ApiModelProperty(value = "来源功能包编码")
    private String bundleCode;

    /**
     * 配置项选项列表，只有值编辑类型editType = 2 （选择），该options才有值
     */
    @ApiModelProperty(value = "配置项选项列表，只有值编辑类型editType = 2 （选择），该options才有值")
    private List<SettingOptionReqDto> options;

    @ApiModelProperty(value = "表格类型的配置项的值")
    private TabularDto tabularViewDto;

    public String getCapabilityCode() {
        return capabilityCode;
    }

    public void setCapabilityCode(String capabilityCode) {
        this.capabilityCode = capabilityCode;
    }

    public List<SettingOptionReqDto> getOptions() {
        return options;
    }

    public void setOptions(List<SettingOptionReqDto> options) {
        this.options = options;
    }

    @Override
    public Integer getEditType() {
        return editType;
    }

    @Override
    public void setEditType(Integer editType) {
        this.editType = editType;
    }

    @Override
    public Integer getValueType() {
        return valueType;
    }

    @Override
    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }

    @Override
    public String getBundleCode() {
        return bundleCode;
    }

    @Override
    public void setBundleCode(String bundleCode) {
        this.bundleCode = bundleCode;
    }

    public TabularDto getTabularViewDto() {
        return tabularViewDto;
    }

    public void setTabularViewDto(TabularDto tabularViewDto) {
        this.tabularViewDto = tabularViewDto;
    }
}
