/**
 * @(#)SettingQueryReqDto 1.0 2020/3/2
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.yundt.cube.center.func.api.dto.base.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 分页查询配置项请求参数
 *
 * @author shuangqing  2020/3/2
 */
@ApiModel(value = "SettingQueryReqDto", description = "分页查询配置项请求参数")
public class SettingQueryReqDto extends BaseReqDto {

    /**
     * 领域编码
     */
    @ApiModelProperty(value = "领域编码")
    private String domainCode;

    /**
     * 能力编码
     */
    @ApiModelProperty(value = "能力编码")
    private String capabilityCode;

    /**
     * 配置项编码
     */
    @ApiModelProperty(value = "配置项编码")
    private String code;

    /**
     * 配置项名称
     */
    @ApiModelProperty(value = "配置项名称")
    private String name;

    /**
     * 配置项的来源功能包
     */
    @ApiModelProperty(value = "配置项的来源功能包")
    private String bundleCode;

    /**
     * 配置项的值编辑方式
     */
    @ApiModelProperty(value = "配置项的值编辑方式(1： 输入 ；2： 选择)")
    private Integer editType;

    /**
     * 配置项的值类型
     */
    @ApiModelProperty(value = "配置项的值类型( 0: 整型; 1: 数值; 2: 日期;3:布尔; 4:枚举; 5: 扩展点)")
    private Integer valueType;

    public String getDomainCode() {
        return domainCode;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public String getCapabilityCode() {
        return capabilityCode;
    }

    public void setCapabilityCode(String capabilityCode) {
        this.capabilityCode = capabilityCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBundleCode() {
        return bundleCode;
    }

    public void setBundleCode(String bundleCode) {
        this.bundleCode = bundleCode;
    }

    public Integer getEditType() {
        return editType;
    }

    public void setEditType(Integer editType) {
        this.editType = editType;
    }

    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }
}
