/**
 * @(#)SettingValueReqDto 1.0 2020/3/21
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.yundt.cube.center.data.dto.TabularDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.base.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 设置配置值dto
 *
 * @author shuangqing  2020/3/21
 */
@ApiModel(value = "SettingValueDto", description = "设置配置值dto")
public class SettingValueDto extends BaseReqDto {


    /**
     * 关联的实体编码
     */
    @ApiModelProperty(value = "关联的实体编码")
    private String code;

    /**
     * 关联的实体类型：0 领域 1 能力 2 配置项 3 配置项候选项
     */
    @ApiModelProperty(value = "关联的实体类型：0 领域 1 能力 2 配置项 3 配置项候选项")
    private Integer type;

    /**
     * 配置项的值编辑方式
     */
    @ApiModelProperty(value = "配置项的值编辑方式")
    private Integer editType;

    /**
     * 配置项的值类型
     */
    @ApiModelProperty(value = "配置项的值类型")
    private Integer valueType;

    /**
     * 输入类型配置项的值
     */
    @ApiModelProperty(value = "输入类型配置项的值")
    private String settingValue;

    /**
     * 表示是否控制下级，如果为 1，则下级不允许修改；0 否 1 是；返回null表示当前级别不能修改该配置项
     */
    @ApiModelProperty(value = "表示是否控制下级，如果为 1，则下级不允许修改；0 否 1 是；返回null表示当前级别不能修改该配置项")
    private Integer isControlled;

    /**
     * 领域事件发送开关，0 关闭，1打开，关闭时则不会发送领域事件
     */
    @ApiModelProperty(value = "领域事件发送开关，0 关闭，1打开，关闭时则不会发送领域事件")
    private Integer sendFlag;

    /**
     * 已选择的候选项编码list
     */
    @ApiModelProperty(value = "已选择的候选项编码list")
    private List<String> optionCodes;

    /**
     * 视图页面的表格类型配置项提交
     */
    @ApiModelProperty(value = "视图页面的表格类型配置项提交")
    private TabularDto tabularViewDto;

    @ApiModelProperty(value = "可选择的选项列表")
    private List<SettingOptionDto> children;

    public Integer getEditType() {
        return editType;
    }

    public void setEditType(Integer editType) {
        this.editType = editType;
    }

    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getSettingValue() {
        return settingValue;
    }

    public void setSettingValue(String settingValue) {
        this.settingValue = settingValue;
    }

    public Integer getIsControlled() {
        return isControlled;
    }

    public void setIsControlled(Integer isControlled) {
        this.isControlled = isControlled;
    }

    public List<String> getOptionCodes() {
        return optionCodes;
    }

    public void setOptionCodes(List<String> optionCodes) {
        this.optionCodes = optionCodes;
    }

    public TabularDto getTabularViewDto() {
        return tabularViewDto;
    }

    public void setTabularViewDto(TabularDto tabularViewDto) {
        this.tabularViewDto = tabularViewDto;
    }

    public Integer getSendFlag() {
        return sendFlag;
    }

    public void setSendFlag(Integer sendFlag) {
        this.sendFlag = sendFlag;
    }

    public List<SettingOptionDto> getChildren() {
        return children;
    }

    public void setChildren(List<SettingOptionDto> children) {
        this.children = children;
    }

}
