/**
 * @(#)SysParamCreateReqDto 1.0 2019/11/12
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author shuangqing  2019/11/12
 */
@ApiModel(value = "SysParamCreateReqDto", description = "业务参数新增Dto")
public class SysParamCreateReqDto extends BaseReqDto {

    /**
     * 编码
     */
    @ApiModelProperty(value = "编码", required = true)
    private String code;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称", required = true)
    private String name;

    /**
     * 描述
     */
    @ApiModelProperty(value = "描述")
    private String description;

    /**
     * 级别(0:全局 1:租户 2:应用)
     */
    @ApiModelProperty(value = "级别(0:全局 1:租户 2:应用)", required = true)
    private Integer grade;

    /**
     * 选择类型(0:输入;1:单选;2:多选)
     */
    @ApiModelProperty(value = "选择类型(0:输入;1:单选;2:多选)", required = true)
    private Integer selectType;

    /**
     * 默认值
     */
    @ApiModelProperty(value = "默认值")
    private String defaultValue;

    /**
     * 值类型(0:文本;1:整数;2:布尔;3:日期;4:小数)
     */
    @ApiModelProperty(value = "值类型(0:文本;1:整数;2:布尔;3:日期;4:小数)", required = true)
    private Integer valueType;

    /**
     * 所属分组
     */
    @ApiModelProperty(value = "所属分组")
    private String groupCode;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 配置项参数来源
     */
    @ApiModelProperty(value = "配置项参数来源")
    private String source;

    /**
     * 版本
     */
    @ApiModelProperty(value = "版本")
    private String reversion;

    /**
     * 参数选项列表
     */
    @ApiModelProperty(value = "参数选项列表")
    private List<SysParamItemCreateReqDto> sysParamItemList = new ArrayList<>();

    /**
     * 业务参数可选值
     */
    @ApiModelProperty(value = "业务参数可选值")
    private Map<String, String> availableValues;

    /**
     * 能力编码
     */
    @ApiModelProperty(value = "能力编码")
    private String capabilityCode;

    /**
     * 能力编码
     */
    @Deprecated
    @ApiModelProperty(value = "能力编码,不要用这个，已废弃")
    private List<String> abilityCodes;

    public Map<String, String> getAvailableValues() {
        return availableValues;
    }

    public void setAvailableValues(Map<String, String> availableValues) {
        this.availableValues = availableValues;
    }

    public String getCapabilityCode() {
        return capabilityCode;
    }

    public void setCapabilityCode(String capabilityCode) {
        this.capabilityCode = capabilityCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getGrade() {
        return grade;
    }

    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    public List<String> getAbilityCodes() {
        return abilityCodes;
    }

    public void setAbilityCodes(List<String> abilityCodes) {
        this.abilityCodes = abilityCodes;
    }

    public Integer getSelectType() {
        return selectType;
    }

    public void setSelectType(Integer selectType) {
        this.selectType = selectType;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }

    public String getGroupCode() {
        return groupCode;
    }

    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getReversion() {
        return reversion;
    }

    public void setReversion(String reversion) {
        this.reversion = reversion;
    }

    public List<SysParamItemCreateReqDto> getSysParamItemList() {
        return sysParamItemList;
    }

    public void setSysParamItemList(List<SysParamItemCreateReqDto> sysParamItemList) {
        this.sysParamItemList = sysParamItemList;
    }
}
