package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * @Description: 参数选项范围请求Dto
 * @Author: 水镜
 * @Date: 2019/11/6 17:46
 * @Version: 0.1.0
 */
@ApiModel(value = "SysParamItemScopeReqDto", description = "参数选项范围请求Dto")
public class SysParamItemScopeReqDto extends BaseReqDto {

    private static final long serialVersionUID = 1L;

    /**
     * 业务身份
     */
    @ApiModelProperty(value = "业务身份")
    private String bizIdCode;
    /**
     * 所属参数编码
     */
    @ApiModelProperty(value = "所属参数编码")
    @NotNull(message = "所属参数编码不能为空")
    private String paramCode;
    /**
     * 选项编码
     */
    @ApiModelProperty(value = "选项编码")
    @NotNull(message = "选项编码不能为空")
    private String itemCode;

    public String getBizIdCode() {
        return bizIdCode;
    }

    public void setBizIdCode(String bizIdCode) {
        this.bizIdCode = bizIdCode;
    }

    public String getParamCode() {
        return paramCode;
    }

    public void setParamCode(String paramCode) {
        this.paramCode = paramCode;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }
}
