/**
 * @(#) SysParamEo.java 1.0 2019-10-26
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * 业务参数Eo
 *
 * @author 黑马
 * @since 1.0.0
 */
@ApiModel(value = "SysParamReqDto", description = "业务参数Dto")
public class SysParamQueryReqDto extends BaseVo {

    private static final long serialVersionUID = -8643823518477305028L;

    /**
     * 编码
     */
    @ApiModelProperty(value = "编码  模糊")
    private String code;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称 模糊")
    private String name;

    /**
     * 能力编码  精确
     */
    @ApiModelProperty(value = "能力编码  精确")
    private String abilityCodes;

    /**
     * 描述
     */
    @ApiModelProperty(value = "业务参数的描述")
    private String description;

    /**
     * 级别(0:租户;1:应用)
     */
    @ApiModelProperty(value = "级别(0:租户;1:应用)")
    private Integer grade;

    /**
     * 选择类型(0:输入;1:单选;2:多选)
     */
    @ApiModelProperty(value = "选择类型(0:输入;1:单选;2:多选)")
    private Integer selectType;

    /**
     * 默认值
     */
    @ApiModelProperty(value = "默认值")
    private String defaultValue;

    /**
     * 值类型(0:文本;1:数值;2:布尔;3:日期)
     */
    @ApiModelProperty(value = "值类型(0:文本;1:数值;2:布尔;3:日期)")
    private Integer valueType;

    /**
     * 所属分组
     */
    @ApiModelProperty(value = "所属分组")
    private String groupCode;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    public String getAbilityCodes() {
        return abilityCodes;
    }

    public void setAbilityCodes(String abilityCodes) {
        this.abilityCodes = abilityCodes;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getGrade() {
        return grade;
    }

    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    public Integer getSelectType() {
        return selectType;
    }

    public void setSelectType(Integer selectType) {
        this.selectType = selectType;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Integer getValueType() {
        return valueType;
    }

    public void setValueType(Integer valueType) {
        this.valueType = valueType;
    }

    public String getGroupCode() {
        return groupCode;
    }

    public void setGroupCode(String groupCode) {
        this.groupCode = groupCode;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
