/**
 * @(#) StdSysParamValueEo.java 1.0 2019-10-26
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;


/**
 * 业务参数值Eo
 *
 * @author 黑马
 * @since 1.0.0
 */
@ApiModel(value = "SysParamValueReqDto", description = "业务参数值Dto")
public class SysParamValueReqDto extends BaseReqDto {
    private static final long serialVersionUID = 1546471886979709532L;

    /**
     * 所属参数编码
     */
    @ApiModelProperty(value = "所属参数编码")
    @NotNull(message = "所属参数编码不能为空")
    private String paramCode;

    /**
     * 所属选项编码
     */
    @ApiModelProperty(value = "所属选项编码")
    private String itemCode;

    /**
     * 参数值
     */
    @ApiModelProperty(value = "参数值")
    private String paramValue;

    /**
     * 业务身份
     */
    @ApiModelProperty(value = "业务身份")
    private String bizIdCode;

    /**
     * 业务空间编码
     */
    @ApiModelProperty(value = "业务空间编码")
    private String bizSpaceCode;

    public String getParamCode() {
        return paramCode;
    }

    public void setParamCode(String paramCode) {
        this.paramCode = paramCode;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getParamValue() {
        return paramValue;
    }

    public void setParamValue(String paramValue) {
        this.paramValue = paramValue;
    }

    public String getBizIdCode() {
        return bizIdCode;
    }

    public void setBizIdCode(String bizIdCode) {
        this.bizIdCode = bizIdCode;
    }

    public String getBizSpaceCode() {
        return bizSpaceCode;
    }

    public void setBizSpaceCode(String bizSpaceCode) {
        this.bizSpaceCode = bizSpaceCode;
    }
}
