/**
 * @(#)ViewSettingReqDto 1.0 2020/3/21
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.yundt.cube.center.func.api.dto.base.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 查询配置视图结果树中指定节点的子节点
 *
 * @author shuangqing  2020/3/21
 */
@ApiModel(value = "ViewNodeQueryReqDto", description = "查询配置视图结果树中指定节点的子节点")
public class ViewNodeQueryReqDto extends BaseReqDto {

    /**
     * 视图Id
     */
    @ApiModelProperty(value = "视图Id")
    private Long viewId;

    /**
     * 关联的实体编码
     */
    @ApiModelProperty(value = "关联的实体编码")
    private String code;

    /**
     * 关联的实体类型：0 领域 1 能力 2 配置项 3 配置项候选项
     */
    @ApiModelProperty(value = "关联的实体类型：0 领域 1 能力 2 配置项 3 配置项候选项")
    private Integer type;

    public Long getViewId() {
        return viewId;
    }

    public void setViewId(Long viewId) {
        this.viewId = viewId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
}
