/**
 * @(#)ViewBindSettingDto 1.0 2020/3/21
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.yundt.cube.center.func.api.dto.base.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 配置视图绑定可设定能力、配置项的范围请求对象
 *
 * @author shuangqing  2020/3/21
 */
@ApiModel(value = "ViewSettingDto", description = "配置视图绑定可设定能力、配置项的范围请求对象")
public class ViewSettingDto extends BaseReqDto {

    @ApiModelProperty(value = "关联的实体编码")
    private String code;

    @ApiModelProperty(value = "父编码")
    private String parentCode;

    @ApiModelProperty(value = "关联的实体类型：0 领域 1 能力 2 配置项 3 配置项候选项")
    private Integer type;

    @ApiModelProperty(value = "排序号")
    private Integer sort;

    @ApiModelProperty(value = "子节点")
    private List<ViewSettingDto> children;

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public List<ViewSettingDto> getChildren() {
        return children;
    }

    public void setChildren(List<ViewSettingDto> children) {
        this.children = children;
    }
}
