/**
 * @(#)ViewSettingReqDto 1.0 2020/3/21
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.request;

import com.dtyunxi.yundt.cube.center.func.api.dto.base.BaseReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 查询视图可设定配置项的请求对象
 *
 * @author shuangqing  2020/3/21
 */
@ApiModel(value = "ViewSettingQueryReqDto", description = "配置视图请求对象")
public class ViewSettingQueryReqDto extends BaseReqDto {

    /**
     * 视图id
     */
    @ApiModelProperty(value = "视图id")
    private Long viewId;

    /**
     * 定位符合name的节点
     */
    @ApiModelProperty(value = "定位符合name的节点")
    private String name;

    /**
     * 是否返回所有子节点，无具体业务意义
     */
    @ApiModelProperty(value = "是否返回所有子节点, 无具体业务意义")
    private Integer withAllChildren;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getViewId() {
        return viewId;
    }

    public void setViewId(Long viewId) {
        this.viewId = viewId;
    }

    public Integer getWithAllChildren() {
        return withAllChildren;
    }

    public void setWithAllChildren(Integer withAllChildren) {
        this.withAllChildren = withAllChildren;
    }
}
