package com.dtyunxi.yundt.cube.center.func.api.dto.request.bizid;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AddGroup;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.ModifyGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * 业务身份Eo对象
 *
 * @author 代码生成器
 */
@ApiModel(value = "BizIdReqDto", description = "业务身份对象")
public class BizIdReqDto extends RequestDto {

    /**
     * 编码
     */
    @NotNull(message = "业务身份编码不能为null", groups = {AddGroup.class, ModifyGroup.class})
    @Pattern(regexp = "^\\w{1,200}$", message = "业务身份编码只能为字母，下划线，数字组合且长度不能超过200个字符", groups = {AddGroup.class, ModifyGroup.class})
    @ApiModelProperty(value = "编码", required = true)
    private String code;

    /**
     * 类型：0 动态  1静态
     */
    @ApiModelProperty(value = "类型：0动态  1静态")
    private Integer type;

    /**
     * 名称
     */
    @NotNull(message = "业务身份名称不能为null", groups = {AddGroup.class})
    @Pattern(regexp = "^[\\u4E00-\\u9FA5\\w]{1,50}$", message = "业务身份名称只能为字母，下划线，数字，中文组合且长度不能超过50个字符", groups = {AddGroup.class, ModifyGroup.class})
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 优先级
     */
//    @NotNull(message = "业务身份优先级不能为null", groups = {AddGroup.class})
    @ApiModelProperty(value = "优先级")
    private Integer priority;

    /**
     * 状态：0 禁用  1启用
     */
//    @NotNull(message = "业务身份状态不能为null", groups = {AddGroup.class})
//    @Min(value = 0, message = "业务身份状态只能为禁用或启用", groups = {AddGroup.class, ModifyGroup.class})
//    @Max(value = 1, message = "业务身份状态只能为禁用或启用", groups = {AddGroup.class, ModifyGroup.class})
    @ApiModelProperty(value = "状态：0 禁用  1启用")
    private Integer status;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;


    @Override
    public Long getTenantId() {
        return super.getTenantId();
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

}