package com.dtyunxi.yundt.cube.center.func.api.dto.request.bizobj;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.*;

/**
 * 业务对象属性Eo对象
 *
 * @author 代码生成器
 */
@ApiModel(value = "BizObjPropertyReqDto", description = "业务对象属性Eo对象")
public class BizObjPropertyReqDto extends RequestDto {

    /**
     * 业务对象编码
     */
    @NotNull(message = "业务对象编码不能为null")
    @Size(min = 1, max = 200, message = "业务对象编码长度不能超过200个字符")
    @Pattern(regexp = "([a-zA-Z][a-zA-Z\\d_]*\\.)*[a-zA-Z_][a-zA-Z\\d_]*", message = "业务对象编码只能字母开头，只支持字母，数字，下划线，点号组合字符")
    @ApiModelProperty(value = "业务对象编码")
    private String bizObjCode;

    /**
     * 编码
     */
    @NotNull(message = "业务对象属性编码不能为null")
    @Size(min = 1, max = 50, message = "业务对象编码长度不能超过50个字符")
    @Pattern(regexp = "[a-zA-Z][a-zA-Z\\d_]*", message = "业务对象属性编码只能字母开头，只支持字母，数字，下划线组合字符，编码长度不能超过50个字符")
    @ApiModelProperty(value = "业务对象属性编码")
    private String code;

    /**
     * 名称
     */
    @NotNull(message = "业务对象属性名称不能为null")
    @Pattern(regexp = "^[\\u4E00-\\u9FA5\\w]{1,50}$", message = "业务对象属性名称只能为字母，下划线，数字，中文组合且长度不能超过50个字符")
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 数据类型
     */
    @NotNull(message = "业务对象属性数据类型不能为null")
    @Min(value = 1, message = "业务对象属性数据类型:1布尔、2字符、3整数、4小数、5日期、6时间、7精准搜索")
    @Max(value = 7, message = "业务对象属性数据类型:1布尔、2字符、3整数、4小数、5日期、6时间、7精准搜索")
    @ApiModelProperty(value = "业务对象属性数据类型:1布尔、2字符、3整数、4小数、5日期、6时间、7精准搜索")
    private Integer dataType;

    /**
     * 数据长度
     */
    @NotNull(message = "业务对象属性数据类型不能为null")
    @ApiModelProperty(value = "业务对象属性数据长度")
    private Integer dataLength;

    /**
     * 编辑类型(0:输入;1:单选;2:多选)
     */
    @NotNull(message = "编业务对象属性辑类型不能为null")
    @Min(value = 0, message = "业务对象属性编辑类型:0输入,1单选,2多选")
    @Max(value = 4, message = "业务对象属性编辑类型:0输入,1单选,2多选")
    @ApiModelProperty(value = "业务对象属性编辑类型:0输入,1单选,2多选")
    private Integer editType;

    @ApiModelProperty(value = "json格式选项值")
    private String optionValue;

    public String getBizObjCode() {
        return this.bizObjCode;
    }

    public void setBizObjCode(String bizObjCode) {
        this.bizObjCode = bizObjCode;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getDataType() {
        return this.dataType;
    }

    public void setDataType(Integer dataType) {
        this.dataType = dataType;
    }

    public Integer getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(Integer dataLength) {
        this.dataLength = dataLength;
    }

    public Integer getEditType() {
        return this.editType;
    }

    public void setEditType(Integer editType) {
        this.editType = editType;
    }

    public String getOptionValue() {
        return optionValue;
    }

    public void setOptionValue(String optionValue) {
        this.optionValue = optionValue;
    }
}