package com.dtyunxi.yundt.cube.center.func.api.dto.request.permissions;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * API属性权限Eo对象
 *
 * @author 代码生成器
 */
@ApiModel(value = "ApiPropPermissionGrantReqDto", description = "API响应DTO权限对象")
public class ApiPropPermissionGrantReqDto extends RequestDto {

    /**
     * API响应DTO编码[DTO全限定名]
     */
    @ApiModelProperty(value = "API响应DTO编码[DTO全限定名]")
    private String dtoCode;

    @ApiModelProperty(value = "API响应DTO属性权限对象列表")
    private List<PropertyPermission> propertyPermissions;

    @ApiModel(value = "PropertyPermission", description = "API响应DTO属性权限对象")
    public static class PropertyPermission {
        /**
         * API响应DTO属性编码
         */
        @ApiModelProperty(value = "API响应DTO属性编码")
        private String propertyCode;

        /**
         * 创建操作权限
         */
        @ApiModelProperty(value = "创建操作权限[0:无 1:有]")
        private Integer createOp;

        /**
         * 读操作权限
         */
        @ApiModelProperty(value = "读操作权限[0:无 1:有]")
        private Integer readOp;

        /**
         * 更新操作权限
         */
        @ApiModelProperty(value = "更新操作权限[0:无 1:有]")
        private Integer updateOp;

        /**
         * 删除操作权限
         */
        @ApiModelProperty(value = "删除操作权限[0:无 1:有]")
        private Integer deleteOp;

        /**
         * 0 禁用  1启用
         */
        @ApiModelProperty(value = "状态 0 禁用  1启用")
        private Integer status;


        @ApiModelProperty(value = "子属性权限对象列表")
        private List<PropertyPermission> children;

        public String getPropertyCode() {
            return propertyCode;
        }

        public void setPropertyCode(String propertyCode) {
            this.propertyCode = propertyCode;
        }

        public Integer getCreateOp() {
            return createOp;
        }

        public void setCreateOp(Integer createOp) {
            this.createOp = createOp;
        }

        public Integer getReadOp() {
            return readOp;
        }

        public void setReadOp(Integer readOp) {
            this.readOp = readOp;
        }

        public Integer getUpdateOp() {
            return updateOp;
        }

        public void setUpdateOp(Integer updateOp) {
            this.updateOp = updateOp;
        }

        public Integer getDeleteOp() {
            return deleteOp;
        }

        public void setDeleteOp(Integer deleteOp) {
            this.deleteOp = deleteOp;
        }

        public Integer getStatus() {
            return status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public List<PropertyPermission> getChildren() {
            return children;
        }

        public void setChildren(List<PropertyPermission> children) {
            this.children = children;
        }
    }

    /**
     * 权限持有者类型[应用、业务空间、业务身份]
     */
    @ApiModelProperty(value = "权限持有者类型[0:业务空间、1:业务身份、2:应用（多个实例对应一个应用）]")
    private Integer holderType;

    /**
     * 权限持有者编码
     */
    @ApiModelProperty(value = "权限持有者编码")
    private String holderCode;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    public String getDtoCode() {
        return dtoCode;
    }

    public void setDtoCode(String dtoCode) {
        this.dtoCode = dtoCode;
    }

    public Integer getHolderType() {
        return holderType;
    }

    public void setHolderType(Integer holderType) {
        this.holderType = holderType;
    }

    public String getHolderCode() {
        return holderCode;
    }

    public void setHolderCode(String holderCode) {
        this.holderCode = holderCode;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<PropertyPermission> getPropertyPermissions() {
        return propertyPermissions;
    }

    public void setPropertyPermissions(List<PropertyPermission> propertyPermissions) {
        this.propertyPermissions = propertyPermissions;
    }
}