/**
 * @(#) BundleApiQueryRespDto.java 1.0 2020-04-17
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.func.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 应用授权API清单响应dto
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "AppInstanceApiQueryRespDto", description = "应用授权API清单响应dto")
public class AppInstanceApiQueryRespDto extends BaseRespDto {

    @ApiModelProperty(value = "api名称")
    private String apiName;

    @ApiModelProperty(value = "api描述、说明")
    private String apiDesc;

    @ApiModelProperty(value = "接口URL")
    private String path;

    @ApiModelProperty(value = "请求方式")
    private String method;

    @ApiModelProperty(value = "授权状态，0授权，1未授权")
    private Integer status;

    public String getApiName() {
        return apiName;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public String getApiDesc() {
        return apiDesc;
    }

    public void setApiDesc(String apiDesc) {
        this.apiDesc = apiDesc;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}
