package com.dtyunxi.yundt.cube.center.func.api.dto.response;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 扩展点返回Dto
 *
 * @author youyang
 * @date 2019/10/30
 * @since 2.6.21.0
 */
@ApiModel(value = "BizExtensionQueryRespDto", description = "扩展点返回Dto")
public class BizExtensionQueryRespDto extends BaseRespDto {

    private static final long serialVersionUID = 1L;

    /**
     * 扩展点代码
     */
    @ApiModelProperty(value = "扩展点代码")
    private String bextCode;
    /**
     * 扩展点简称
     */
    @ApiModelProperty(value = "扩展点简称")
    private String bextName;
    /**
     * 扩展点简介
     */
    @ApiModelProperty(value = "扩展点简介")
    private String bextDesc;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 扩展点类型
     * 1: 单实现生效  2:并行实现生效
     */
    @ApiModelProperty(value = "扩展点类型：1: 单实现生效  2:并行实现生效")
    private Integer bextType;

    /**
     * 级别(0:全局;1:租户;2:应用)
     */
    @ApiModelProperty(value = "级别(0:全局;1:租户;2:应用)")
    private Integer grade;


    /**
     * 影响的应用系统
     * 扩展点可能影响的系统,多个有英文半角逗号分隔
     */
    @ApiModelProperty(value = "影响的应用系统：扩展点可能影响的系统,多个有英文半角逗号分隔")
    private String effectApps;
    /**
     * 当前版本
     */
    @ApiModelProperty(value = "当前版本")
    private String curVer;
    /**
     * 当前版本注册时间
     */
    @ApiModelProperty(value = "当前版本注册时间")
    private Date curVerReleaseTime;

    /**
     * 扩展点实现列表
     */
    @ApiModelProperty(value = "扩展点实现列表")
    private List<BizExtImplRespDto> extImplList = new ArrayList<>();


    /**
     * 扩展点执行的具体实例列表
     */
    @ApiModelProperty(value = "扩展点执行的具体实例列表")
    private List<BizExtImplValueRespDto> extImplValueList = new ArrayList<>();


    @ApiModelProperty(value = "关联的能力信息")
    private List<AbilityRespDto> abilityRespDtos;

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getGrade() {
        return grade;
    }

    public void setGrade(Integer grade) {
        this.grade = grade;
    }

    public List<AbilityRespDto> getAbilityRespDtos() {
        return abilityRespDtos;
    }

    public void setAbilityRespDtos(List<AbilityRespDto> abilityRespDtos) {
        this.abilityRespDtos = abilityRespDtos;
    }


    public String getBextCode() {
        return bextCode;
    }

    public void setBextCode(String bextCode) {
        this.bextCode = bextCode;
    }

    public String getBextName() {
        return bextName;
    }

    public void setBextName(String bextName) {
        this.bextName = bextName;
    }

    public String getBextDesc() {
        return bextDesc;
    }

    public void setBextDesc(String bextDesc) {
        this.bextDesc = bextDesc;
    }

    public Integer getBextType() {
        return bextType;
    }

    public void setBextType(Integer bextType) {
        this.bextType = bextType;
    }

    public String getEffectApps() {
        return effectApps;
    }

    public void setEffectApps(String effectApps) {
        this.effectApps = effectApps;
    }

    public String getCurVer() {
        return curVer;
    }

    public void setCurVer(String curVer) {
        this.curVer = curVer;
    }

    public Date getCurVerReleaseTime() {
        return curVerReleaseTime;
    }

    public void setCurVerReleaseTime(Date curVerReleaseTime) {
        this.curVerReleaseTime = curVerReleaseTime;
    }

    public List<BizExtImplRespDto> getExtImplList() {
        return extImplList;
    }

    public void setExtImplList(List<BizExtImplRespDto> extImplList) {
        this.extImplList = extImplList;
    }

    public List<BizExtImplValueRespDto> getExtImplValueList() {
        return extImplValueList;
    }

    public void setExtImplValueList(List<BizExtImplValueRespDto> extImplValueList) {
        this.extImplValueList = extImplValueList;
    }
}
