/**
 * @(#)BizSpaceCreateReqDto 1.0 2019/11/21
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.response;

import com.dtyunxi.yundt.cube.center.func.api.dto.request.BizRuleBasicReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @author : 萧玄
 * @Date: 15:38 2019/12/4
 */
@ApiModel(value = "BizRuleRespDto", description = "业务规则查询返回")
public class BizRuleRespDto extends BizRuleBasicReqDto {
    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "规则所属的业务身份和业务空间id组合")
    private List<BizIdentity2Space> owners;


    @ApiModel(value = "BizIdentity2Space", description = "业务身份和空间")
    public static class BizIdentity2Space {

        @ApiModelProperty(value = "业务身份Code")
        private String bizIdentityCode;

        @ApiModelProperty(value = "业务空间Code")
        private String bizSpaceCode;

        @ApiModelProperty(value = "业务规则id", hidden = true)
        private Long bizRuleId;

        public String getBizIdentityCode() {
            return bizIdentityCode;
        }

        public void setBizIdentityCode(String bizIdentityCode) {
            this.bizIdentityCode = bizIdentityCode;
        }

        public String getBizSpaceCode() {
            return bizSpaceCode;
        }

        public void setBizSpaceCode(String bizSpaceCode) {
            this.bizSpaceCode = bizSpaceCode;
        }

        public Long getBizRuleId() {
            return bizRuleId;
        }

        public void setBizRuleId(Long bizRuleId) {
            this.bizRuleId = bizRuleId;
        }
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<BizIdentity2Space> getOwners() {
        return owners;
    }

    public void setOwners(List<BizIdentity2Space> owners) {
        this.owners = owners;
    }
}
