/**
 * @(#)BizSpaceCreateReqDto 1.0 2019/11/21
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author shuangqing  2019/11/21
 */
@ApiModel(value = "BizSpaceRespDto", description = "业务空间查询返回")
public class BizSpaceRespDto extends BaseRespDto {

    /**
     * 编码
     */
    @ApiModelProperty(value = "编码")
    private String code;

    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * 状态：0 禁用  1启用
     */
    @ApiModelProperty(value = "状态：0 禁用  1启用")
    private Integer status;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /**
     * 业务空间模板编码
     */
    @ApiModelProperty(value = "业务空间模板编码")
    private String bizSpaceTempCode;

    /**
     * 关联的场景数目
     */
    @ApiModelProperty(value = "关联的场景数目")
    private Integer sceneNum;

    /**
     * 关联的应用数目  返回全部的应用数目，如需只展示启用状态的应用，需调用户中心接口
     */
    @ApiModelProperty(value = "关联的应用数目，返回全部的应用数目，如需只展示启用状态的应用，需调用户中心接口")
    private Integer appInstanceNum;

    /**
     * 已配置参数项数量
     */
    @ApiModelProperty(value = "已配置参数项数量")
    private Integer configNum;

    /**
     * 规则数
     */
    @ApiModelProperty(value = "规则数")
    private Integer bizRuleNum;

    @ApiModelProperty(value = "类型：0动态  1静态")
    private Integer bizIdType;

    public Integer getConfigNum() {
        return configNum;
    }

    public void setConfigNum(Integer configNum) {
        this.configNum = configNum;
    }

    public Integer getBizRuleNum() {
        return bizRuleNum;
    }

    public void setBizRuleNum(Integer bizRuleNum) {
        this.bizRuleNum = bizRuleNum;
    }

    public Integer getSceneNum() {
        return sceneNum;
    }

    public void setSceneNum(Integer sceneNum) {
        this.sceneNum = sceneNum;
    }

    public Integer getAppInstanceNum() {
        return appInstanceNum;
    }

    public void setAppInstanceNum(Integer appInstanceNum) {
        this.appInstanceNum = appInstanceNum;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getBizSpaceTempCode() {
        return this.bizSpaceTempCode;
    }

    public void setBizSpaceTempCode(String bizSpaceTempCode) {
        this.bizSpaceTempCode = bizSpaceTempCode;
    }

    public Integer getBizIdType() {
        return bizIdType;
    }

    public void setBizIdType(Integer bizIdType) {
        this.bizIdType = bizIdType;
    }
}
