/**
 * @(#)AbilityConfigTreeDto 1.0 2019/11/25
 * <p>
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.response;

import com.dtyunxi.yundt.cube.center.func.api.dto.TreeDtoBase;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;

/**
 * @author shuangqing  2019/11/25
 */
@ApiModel(value = "BizSpaceTreeDto", description = "能力配置项树dto")
public class BizSpaceTreeDto extends TreeDtoBase {

    /**
     * 前端要求统一用selectType,  去掉扩展点的bext_type
     * 只有业务参数、扩展点，这个字段才有值
     */
    @ApiModelProperty(value = "业务参数的选择类型(0:输入;1:单选;2:多选) ; 扩展点类型:  1: 单实现生效  2:并行实现生效；" +
            "只有业务参数、扩展点，这个字段才有值")
    private Integer selectType;

    @ApiModelProperty(value = "业务参数选项值")
    private String paramValue;

    @ApiModelProperty(value = "子分组")
    private List<BizSpaceTreeDto> children = new ArrayList<>();

    public Integer getSelectType() {
        return selectType;
    }

    public void setSelectType(Integer selectType) {
        this.selectType = selectType;
    }

    public List<BizSpaceTreeDto> getChildren() {
        return children;
    }

    public void setChildren(List<BizSpaceTreeDto> children) {
        this.children = children;
    }

    public String getParamValue() {
        return paramValue;
    }

    public void setParamValue(String paramValue) {
        this.paramValue = paramValue;
    }
}
