/**
 * @(#) BundleApiQueryRespDto.java 1.0 2020-04-17
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.func.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 功能包API清单响应dto
 *
 * @author 仪琳
 * @since 1.0.0
 */
@ApiModel(value = "BundleApiQueryRespDto", description = "功能包API清单响应dto")
public class BundleApiQueryRespDto extends BaseRespDto {

    @ApiModelProperty(value = "api名称")
    private String apiName;

    @ApiModelProperty(value = "api描述、说明")
    private String apiDesc;

    @ApiModelProperty(value = "接口URL")
    private String path;

    @ApiModelProperty(value = "请求方式")
    private String method;

    @ApiModelProperty(value = "所属领域编码")
    private String moduleCode;

    @ApiModelProperty(value = "所属领域名称")
    private String domainName;

    @ApiModelProperty(value = "所属一级能力编码")
    private String firstCapabilityCode;

    @ApiModelProperty(value = "所属一级能力名称")
    private String firstCapabilityName;

    /**
     * 二级能力编码
     */
    @ApiModelProperty(value = "所属二级能力编码")
    private String capabilityCode;

    @ApiModelProperty(value = "功能包版本")
    private String bundleVersion;

    @ApiModelProperty(value = "是否作废：0=否、1=是")
    private Integer deprecate;

    public String getApiName() {
        return apiName;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public String getApiDesc() {
        return apiDesc;
    }

    public void setApiDesc(String apiDesc) {
        this.apiDesc = apiDesc;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getModuleCode() {
        return moduleCode;
    }

    public void setModuleCode(String moduleCode) {
        this.moduleCode = moduleCode;
    }

    public String getFirstCapabilityCode() {
        return firstCapabilityCode;
    }

    public void setFirstCapabilityCode(String firstCapabilityCode) {
        this.firstCapabilityCode = firstCapabilityCode;
    }

    public String getCapabilityCode() {
        return capabilityCode;
    }

    public void setCapabilityCode(String capabilityCode) {
        this.capabilityCode = capabilityCode;
    }

    public String getDomainName() {
        return domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getFirstCapabilityName() {
        return firstCapabilityName;
    }

    public void setFirstCapabilityName(String firstCapabilityName) {
        this.firstCapabilityName = firstCapabilityName;
    }

    public String getBundleVersion() {
        return bundleVersion;
    }

    public void setBundleVersion(String bundleVersion) {
        this.bundleVersion = bundleVersion;
    }

    public Integer getDeprecate() {
        return deprecate;
    }

    public void setDeprecate(Integer deprecate) {
        this.deprecate = deprecate;
    }
}
