/**
 * @(#)CapabilitySettingsRespDto 1.0 2020/2/28
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.response;


import com.dtyunxi.yundt.cube.center.func.api.constants.Constants;
import com.dtyunxi.yundt.cube.center.func.api.dto.base.CapabilityBaseDto;
import com.dtyunxi.cube.utils.tree.ITreeNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 根据条件查询能力关联的配置项信息返回参数
 *
 * @author shuangqing  2020/2/28
 */
@ApiModel(value = "CapabilitySettingsRespDto", description = "根据条件查询能力关联的配置项信息返回参数")
public class CapabilitySettingsRespDto extends CapabilityBaseDto implements ITreeNode<CapabilitySettingsRespDto> {

    /**
     * 当前能力下的配置项列表
     */
    @ApiModelProperty(value = "当前能力下的配置项列表")
    private List<SettingRespDto> settings;

    /**
     * 子能力列表，其中包括子能力的配置项列表
     */
    @ApiModelProperty(value = "子能力列表，其中包括子能力的配置项列表")
    private List<CapabilitySettingsRespDto> children;


    @Override
    public List<CapabilitySettingsRespDto> getChildren() {
        return children;
    }

    @Override
    public void setChildren(List<CapabilitySettingsRespDto> children) {
        this.children = children;
    }

    @Override
    public String getKey() {
        return this.getCode();
    }

    @Override
    public String getParentKey() {
        return this.getParentCode();
    }

    @Override
    public Boolean isRootNode() {
        return Constants.ROOT_NODE_PARENT_CODE.equals(this.getParentCode());
    }

    @Override
    public void addChild(CapabilitySettingsRespDto iTreeNode) {
        children.add(iTreeNode);
    }


    public List<SettingRespDto> getSettings() {
        return settings;
    }

    public void setSettings(List<SettingRespDto> settings) {
        this.settings = settings;
    }
}
