/**
 * @(#)SettingDetailRespDto 1.0 2020/3/2
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.response;

import com.dtyunxi.yundt.cube.center.data.dto.TabularDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.base.SettingBaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 查询配置项详情返回参数
 *
 * @author shuangqing  2020/3/2
 */
@ApiModel(value = "SettingDetailRespDto", description = "查询配置项详情返回参数")
public class SettingDetailRespDto extends SettingBaseDto {

    /**
     * 能力编码
     */
    @ApiModelProperty(value = "能力编码")
    private String capabilityCode;

    /**
     * 能力名称
     */
    @ApiModelProperty(value = "能力名称")
    private String capabilityName;

    /**
     * 配置项参数，例如领域事件的topic、tag、dto编码等
     */
    @ApiModelProperty(value = "配置项参数，例如领域事件的topic、tag、dto编码等")
    private String parameter;

    /**
     * 来源功能包名称
     */
    @ApiModelProperty(value = "来源功能包名称")
    private String bundleName;

    /**
     * 来源功能包父编码
     */
    @ApiModelProperty(value = "来源功能包父编码，为了与前端交互方便")
    private String bundleParentCode;

    /**
     * 配置项选项列表，只有值编辑类型editType = 2 （选择），该options才有值
     */
    @ApiModelProperty(value = "配置项选项列表，只有值编辑类型editType = 2 （选择），该options才有值")
    private List<SettingOptionRespDto> options;

    @ApiModelProperty(value = "表格类型配置项")
    private TabularDto tabularViewDto;

    public String getCapabilityCode() {
        return capabilityCode;
    }

    public void setCapabilityCode(String capabilityCode) {
        this.capabilityCode = capabilityCode;
    }

    public String getCapabilityName() {
        return capabilityName;
    }

    public void setCapabilityName(String capabilityName) {
        this.capabilityName = capabilityName;
    }

    public String getBundleName() {
        return bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public List<SettingOptionRespDto> getOptions() {
        return options;
    }

    public void setOptions(List<SettingOptionRespDto> options) {
        this.options = options;
    }

    public String getBundleParentCode() {
        return bundleParentCode;
    }

    public void setBundleParentCode(String bundleParentCode) {
        this.bundleParentCode = bundleParentCode;
    }

    public TabularDto getTabularViewDto() {
        return tabularViewDto;
    }

    public void setTabularViewDto(TabularDto tabularViewDto) {
        this.tabularViewDto = tabularViewDto;
    }

    public String getParameter() {
        return parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }
}
