/**
 * @(#) StdSysParamItemEo.java 1.0 2019-10-26
 * Copyright (c) 2019, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;


/**
 * 业务参数选项Dto
 *
 * @author 黑马
 * @since 1.0.0
 */
@ApiModel(value = "SysParamItemRespDto", description = "业务参数选项Dto")
public class SysParamItemRespDto extends BaseRespDto {
    private static final long serialVersionUID = 7532768636176100059L;

    /**
     * 所属参数编码
     */
    @ApiModelProperty(value = "所属参数编码")
    @NotNull(message = "所属参数编码不能为空")
    private String paramCode;

    /**
     * 选项编码
     */
    @ApiModelProperty(value = "选项编码")
    private String itemCode;

    /**
     * 排序号
     */
    @ApiModelProperty(value = "排序号")
    private Integer sortNo;

    /**
     * 参数值描述
     */
    @ApiModelProperty(value = "参数值描述")
    private String valueDesc;

    /**
     * 参数值
     */
    @ApiModelProperty(value = "参数值")
    private String paramValue;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    public String getParamCode() {
        return paramCode;
    }

    public void setParamCode(String paramCode) {
        this.paramCode = paramCode;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public Integer getSortNo() {
        return sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public String getValueDesc() {
        return valueDesc;
    }

    public void setValueDesc(String valueDesc) {
        this.valueDesc = valueDesc;
    }

    public String getParamValue() {
        return paramValue;
    }

    public void setParamValue(String paramValue) {
        this.paramValue = paramValue;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

}
