package com.dtyunxi.yundt.cube.center.func.api.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

@ApiModel(value = "ViewDescRespDto", description = "配置视图中的所有能力、配置项的备注信息dto")
public class ViewDescRespDto extends BaseVo {

    @ApiModelProperty(value = "能力描述列表")
    private List<ViewCapabilityItemDto> capabilityDescList;
    @ApiModelProperty(value = "配置项+选项描述列表")
    private List<ViewSettingItemDto> settingDescList;


    public static class ViewCapabilityItemDto extends ViewBaseItemDto {
    }

    public static class ViewSettingItemDto extends ViewBaseItemDto {

        private List<ViewOptionItemDto> optionDescList;

        public List<ViewOptionItemDto> getOptionDescList() {
            return optionDescList;
        }

        public void setOptionDescList(List<ViewOptionItemDto> optionDescList) {
            this.optionDescList = optionDescList;
        }
    }

    public static class ViewOptionItemDto extends ViewBaseItemDto {

    }

    public static class ViewBaseItemDto extends BaseVo {
        private String code;
        private String name;
        private String remark;
        private Integer sort;

        public Integer getSort() {
            return sort;
        }

        public void setSort(Integer sort) {
            this.sort = sort;
        }

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getRemark() {
            return remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

    }

    public List<ViewCapabilityItemDto> getCapabilityDescList() {
        return capabilityDescList;
    }

    public void setCapabilityDescList(List<ViewCapabilityItemDto> capabilityDescList) {
        this.capabilityDescList = capabilityDescList;
    }

    public List<ViewSettingItemDto> getSettingDescList() {
        return settingDescList;
    }

    public void setSettingDescList(List<ViewSettingItemDto> settingDescList) {
        this.settingDescList = settingDescList;
    }
}
