/*
 * @(#)CenterDataExceptionCode.java 1.0 2018/8/17
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.func.api.exception;

import com.dtyunxi.cube.enhance.generator.annotation.ExceptionEnum;

/**
 * @author 古奇
 * @since 1.0.0
 */
@ExceptionEnum
public enum CenterDataExceptionCode {
    //基础中心异常 4000<= code < 5000
    DICT_QUERY_EXCEPTION("4000", "查询字典数据时发生异常"),
    DICT_NOT_EXISTS("4001", "根据groupCode和code找不到对应的字典"),
    DICT_UNIQUE_EXCEPTION("4002", "该分组下的code已存在,不能重复添加"),
    DICT_GROUPCODE_EMPTY("4003", "分组不能为空"),
    DICT_CODE_EMPTY("4004", "code不能为空"),
    DICT_TENANTID_EMPTY("4005", "tenantId不能为空"),
    //============================================
    AREA_CODE_NOT_EXISTS("4010", "根据code找不到对应的区域"),
    AREA_PARENTCODE_NOT_EXISTS("4011", "根据parentCode找不到对应的区域"),
    AREA_ADD_DEFULT("4012", "添加区域信息失败"),
    AREA_UPDATE_DEFULT("4013", "更新区域信息失败"),
    AREA_NOT_EXISTS("4014", "查询的相关区域信息不存在"),
    AREA_DELETE_DEFULT("4015", "删除区域信息失败"),
    AREACOMPARISION_NOT_EXISTS("4016", "查询的相关区域对照信息不存在"),
    AREACOMPARISION_ADD_DEFULT("4017", "添加区域对照信息失败"),
    AREACOMPARISION_DELETE_DEFULT("4018", "删除区域对照信息失败"),
    DATA_DUPLICATE_ERROR("4020", "数据重复"),
    BATCH_MORE_THAN_TWO_HUNDRED_ERROR("4021", "批量查询条件个数大于200"),
    AREA_GREOUP_NOT_EXISTS("4022", "区域分组不存在"),
    AREA_GREOUP_CODE_IS_EXISTS("4023", "区域分组编码已存在"),
    PARAM_INVALID("4024", "参数异常"),
    CODE_IS_REPEATED_PARENT_CODE("4025", "编码和父级编码不能一样"),

    PARAM_NOT_EXISTS("4030", "找不到对应的参数"),
    PARAM_VALUE_NON_NULL("4031", "参数值不能为空"),
    PARAM_VALUE_NOT_FOUND("4032", "参数设定的值无效"),
    RECORD_NOT_EXISTS("4033", "数据不存在"),
    RELATION_EXISTS("4034", "存在关联关系"),

    BIZ_ID_CODE_IS_NULL("4501", "缺少业务身份识别条件"),
    EXTENSION_NOT_EXISTS("4502", "找不到对应的扩展点信息"),
    CONFIG_IMPORT_ALL_FAIL("4503", "提交失败，全部参数已存在或数据不符合要求"),
    CONFIG_IMPORT_PART_FAIL("4504", "提交失败，部分参数已存在或数据不符合要求"),
    AREA_SYNCING("4505", "区域信息正在更新中")
    //
    ;


    private final String code;

    private final String msg;

    CenterDataExceptionCode(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;

    }
}
