/*
 * @(#)CenterDataExceptionCode.java 1.0 2018/8/17
 *
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.func.api.exception;


import com.dtyunxi.yundt.cube.center.func.api.constants.DocConstants;

public enum DocApiExceptionCode {


    //文档提示（>50000）
    NAME_NOT_EXISTS("50001", DocConstants.NULL_VALUE + "名称不能为空，请填写"),
    CODE_DELETE("50002", "所属" + DocConstants.NULL_VALUE + "被禁用/删除，请重新选择"),
    OFF_SHElF_TO_ON("50003", "当前" + DocConstants.NULL_VALUE + "文档上架后将替换该" + DocConstants.NULL_VALUE + "原有已上架文档，是否确定上架？"),
    ON_SHELF_TO_OFF("50004", "当前" + DocConstants.NULL_VALUE + "文档下架后，该" + DocConstants.NULL_VALUE + "将不在能力地图展示，是否确定下架？"),
    API_OFF_SHELF("50005", "当前API已经被应用场景关联，下架后将自动取消关联场景，是否确定下架？");


    private final String code;

    private final String msg;

    DocApiExceptionCode(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;

    }
}
