package com.dtyunxi.yundt.cube.center.func.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.*;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.AbilityGroupRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.AbilityGroupTreeDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.SceneDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;

import javax.validation.Valid;
import java.util.List;

/**
 * 能力分类信息，包含领域信息、场景信息服务接口
 *
 * @author shuanqging
 * @see com.dtyunxi.yundt.cube.center.func.api.query.ICapabilityQueryApi
 */
@Api(tags = {"基础数据中心：功能包能力地图：能力分类信息，包含领域信息、场景信息服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-data-api-query-IAbilityGroupQueryApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v1/ability-group", url = "${yundt.cube.center.data.api:}")
@Deprecated
public interface IAbilityGroupQueryApi {

    /**
     * 根据code 查询能力分类信息，包含领域信息、场景信息
     *
     * @param abilityGroupQueryReqDto 能力分类信息，包含领域信息、场景信息code
     * @return 能力分类信息，包含领域信息、场景信息数据
     */
    @GetMapping("/code")
    @ApiOperation(value = "根据code 查询能力分类信息，包含领域信息、场景信息", notes = "根据id查询能力分类信息，包含领域信息、场景信息")
    @Capability(capabilityCode = "basicdata.ability-group.query-by-code")
    RestResponse<AbilityGroupRespDto> queryByCode(@Valid @SpringQueryMap AbilityGroupQueryReqDto abilityGroupQueryReqDto);


    /**
     * 查询领域场景树
     *
     * @param abilityGroupTreeReqDto 能力分类信息，包含领域信息、场景信息code
     * @return 领域场景树
     */
    @GetMapping("/tree")
    @ApiOperation(value = "查询领域场景树", notes = "查询领域场景树")
    @Capability(capabilityCode = "basicdata.ability-group.query-by-tree")
    RestResponse<AbilityGroupTreeDto> queryByTree(@Valid @SpringQueryMap AbilityGroupTreeReqDto abilityGroupTreeReqDto);

    /**
     * 查询领域场景列表
     *
     * @param abilityGroupQueryDto 能力分类信息，包含领域信息、场景信息code
     * @return 领域场景树
     */
    @GetMapping("")
    @ApiOperation(value = "查询领域场景列表", notes = "查询领域场景列表 name 模糊查询")
    @Capability(capabilityCode = "basicdata.ability-group.query-by-list")
    RestResponse<List<AbilityGroupRespDto>> queryByList(@Valid @SpringQueryMap AbilityGroupQueryDto abilityGroupQueryDto);

    /**
     * 查询业务空间场景列表
     *
     * @param bizSpaceAbilityGroupReqDto 业务空间场景请求Dto
     * @return 业务空间场景列表
     */
    @GetMapping("/biz-space")
    @ApiOperation(value = "查询业务空间场景列表", notes = "查询业务空间场景列表")
    @Capability(capabilityCode = "basicdata.ability-group.query-by-biz-space-code")
    RestResponse<List<AbilityGroupRespDto>> queryByBizSpaceCode(@Valid @SpringQueryMap BizSpaceAbilityGroupReqDto bizSpaceAbilityGroupReqDto);


    /**
     * 根据领域code查询场景列表（基本信息+简介）
     *
     * @param abilityGroupDocDto
     * @return
     */
    @GetMapping("/scene/doc")
    @ApiOperation(value = "根据领域code查询场景列表（基本信息+简介）", notes = "根据领域code查询场景列表（基本信息+简介）")
    @Capability(capabilityCode = "basicdata.ability-group.query-scene-doc-list")
    RestResponse<List<SceneDto>> querySceneDocList(@Valid @SpringQueryMap AbilityGroupDocDto abilityGroupDocDto);
}
