package com.dtyunxi.yundt.cube.center.func.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AppInstanceApiQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.AppInstanceDtoQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.AppInstanceApiQueryRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.AppInstanceDtoQueryRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 应用实例-API关系服务接口
 *
 * @author 代码生成器
 */
@Api(tags = {"基础数据中心：功能包能力地图：应用实例-API关系服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-func-api-query-IAppInstanceApiQueryApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v1/app-instance-api", url = "${yundt.cube.center.data.api:}")
public interface IAppInstanceApiQueryApi {

    /**
     * 查询领域或一级能力下的API清单分页数据，同时返回对应应用下API的授权状态
     *
     * @param queryReqDto 查询条件
     * @param pageNum     当前页
     * @param pageSize    页大小
     * @return 应用授权API清单分页数据
     */
    @GetMapping("")
    @ApiOperation(value = "查询领域或一级能力下的API清单分页数据，同时返回对应应用下API的授权状态", notes = "查询领域或一级能力下的API清单分页数据，同时返回对应应用下API的授权状态")
    @Capability(capabilityCode = "basicdata.app-instance-api.query-by-page")
    RestResponse<PageInfo<AppInstanceApiQueryRespDto>> queryByPage(@SpringQueryMap AppInstanceApiQueryReqDto queryReqDto,
                                                                   @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                   @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 查询API对应的DTO响应属性信息，同时返回对应应用下DTO属性的授权状态
     *
     * @param queryReqDto 查询条件
     * @return 应用授权DTO清单数据
     */
    @GetMapping("/dto")
    @ApiOperation(value = "查询API对应的DTO响应属性信息，同时返回对应应用下DTO属性的授权状态", notes = "查询API对应的DTO响应属性信息，同时返回对应应用下DTO属性的授权状态")
    @Capability(capabilityCode = "basicdata.app-instance-api.query-dto-info")
    RestResponse<AppInstanceDtoQueryRespDto> queryDtoInfo(@SpringQueryMap AppInstanceDtoQueryReqDto queryReqDto);

}
