/**
 * @(#)ICapabilityQueryApi 1.0 2020/2/28
 * <p>
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.func.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.base.CapabilityBaseDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.CapabilityDomainQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.CapabilitySettingQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.CapabilityTreeQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.CapabilityRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.CapabilitySettingsRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.CapabilitySimpleRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.CapabilityTreeRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author shuangqing  2020/2/28
 */
@Api(tags = {"基础数据中心：功能包能力地图：能力信息服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-func-api-query-ICapabilityQueryApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", path = "/v1/capability", url = "${yundt.cube.center.data.api:}")
public interface ICapabilityQueryApi {

    /**
     * 根据编码查询能力，返回能力的基本信息，不包含子能力+配置项信息
     * <p>
     * 使用@PathVariable，如果其value值包括 . 号，会截取掉入参的部分字段，所以使用{code:.+}
     *
     * @param code 能力信息code
     * @return 能力信息数据
     */
    @GetMapping("/{code:.+}")
    @ApiOperation(value = "根据编码查询能力基本信息", notes = "根据编码查询能力，返回能力的基本信息，不包含子能力+配置项信息")
    @Capability(capabilityCode = "basicdata.capability.query-by-code")
    RestResponse<CapabilitySimpleRespDto> queryByCode(@PathVariable("code") String code);

    /**
     * 获取能力信息树，返回信息包括领域+能力，返回结构为树
     *
     * @param capabilityTreeQueryReqDto 获取能力信息树的请求参数
     * @return 返回信息包括领域+能力，返回结构为树
     */
    @GetMapping("/tree")
    @ApiOperation(value = "获取能力信息树，返回信息包括领域+能力，返回结构为树", notes = "获取能力信息树，返回信息包括领域+能力，返回结构为树；" +
            "如果请求参数domainCode不传，则查询出全部领域信息及其领域下的能力列表")
    @Capability(capabilityCode = "basicdata.capability.query-capability-tree")
    RestResponse<CapabilityTreeRespDto> queryCapabilityTree(@SpringQueryMap CapabilityTreeQueryReqDto capabilityTreeQueryReqDto);

    /**
     * 根据条件查询能力关联的配置项信息
     *
     * @param capabilitySettingQueryReqDto 根据条件查询能力下配置项的请求参数
     * @return 返回信息包括能力编码、能力名称、能力的来源功能包、能力的父编码、配置项列表
     */
    @GetMapping("/settings")
    @ApiOperation(value = "根据条件查询能力关联的配置项信息", notes = "根据条件查询能力关联的配置项信息；" +
            "只支持条件查询当前能力下的配置项，不支持条件查询能力，比如请求参数中只有能力编码，不支持根据能力名称查询；"
            + "查询条件中，能力编码不能为空；返回信息包括能力编码、能力名称、能力的来源功能包、能力的父编码、配置项列表")
    @Capability(capabilityCode = "basicdata.capability.query-capability-settings")
    RestResponse<CapabilitySettingsRespDto> queryCapabilitySettings(@SpringQueryMap CapabilitySettingQueryReqDto capabilitySettingQueryReqDto);


    /**
     * 根据领域编码查询能力的分页列表，不构建树
     *
     * @param capabilityDomainQueryReqDto 根据领域编码查询能力的分页列表请求参数
     * @param pageNum                     页码数
     * @param pageSize                    页大小
     * @return 返回能力及其子能力列表
     */
    @GetMapping("/by-domain")
    @ApiOperation(value = "根据领域编码查询能力的分页列表", notes = "根据领域编码查询能力的分页列表，不构建树")
    @Capability(capabilityCode = "basicdata.capability.query-capability-by-domain")
    RestResponse<PageInfo<CapabilityRespDto>> queryCapabilityByDomain(@SpringQueryMap CapabilityDomainQueryReqDto capabilityDomainQueryReqDto,
                                                                      @RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                      @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 查询一级能力的分页列表
     *
     * @param pageNum  页码数
     * @param pageSize 页大小
     * @return 能力列表
     */
    @GetMapping("/root")
    @ApiOperation(value = "查询一级能力的分页列表", notes = "查询一级能力的分页列表")
    @Capability(capabilityCode = "basicdata.capability.query-root-node")
    RestResponse<PageInfo<CapabilityBaseDto>> queryRootNode(@RequestParam(value = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                            @RequestParam(value = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
