package com.dtyunxi.yundt.cube.center.func.api.query;

import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.DocBindApiReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.request.DocQueryReqDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.ApiRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.DocDetailRespDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.DocOverviewDto;
import com.dtyunxi.yundt.cube.center.func.api.dto.response.DocRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


@Api(tags = {"基础数据中心：功能包能力地图：领域场景文档服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-data-api-query-IDocQueryApi",
        name = "${yundt.cube.center.data.api.name:yundt-cube-center-data}", url = "${yundt.cube.center.data.api:}")
public interface IDocQueryApi {

    /**
     * 分页查询文档
     *
     * @param docQueryReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping({"/v1/doc/page", "/v3/doc"})
    @ApiOperation(value = "分页查询文档", notes = "分页查询文档")
    @Capability(capabilityCode = "basicdata.doc.query-by-page")
    RestResponse<PageInfo<DocRespDto>> queryByPage(@SpringQueryMap DocQueryReqDto docQueryReqDto,
                                                   @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                   @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 查询文档详情
     *
     * @param docId
     * @return
     */
    @GetMapping({"/v1/doc/{docId}", "/v3/doc/{docId}"})
    @ApiOperation(value = "查询文档详情", notes = "查询文档详情")
    @Capability(capabilityCode = "basicdata.doc.query-by-id")
    RestResponse<DocDetailRespDto> queryById(@PathVariable("docId") Long docId);

    /**
     * 文档关联API
     * @param bindApiReqDto
     * @return
     */
    @GetMapping({"/v1/doc/bind", "/v3/doc/bind"})
    @ApiOperation(value = "查询文档关联的API", notes = "文档关联API")
    @Capability(capabilityCode = "basicdata.doc.query-bind-api")
    RestResponse<List<ApiRespDto>> queryBindApi(@SpringQueryMap DocBindApiReqDto bindApiReqDto);

    /**
     * 文档管理-查询领域、场景、API文档total 的接口
     *
     * @return
     */
    @GetMapping({"/v1/doc/overview", "/v3/doc/overview"})
    @ApiOperation(value = "文档管理-查询领域、场景、API文档total 的接口", notes = "文档管理-查询领域、场景、API文档total 的接口")
    @Capability(capabilityCode = "basicdata.doc.query-doc-overview")
    RestResponse<List<DocOverviewDto>> queryDocOverview();
}
