/**
 * @(#) SettlementExceptionCode.java 1.0 2021/12/13/013
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.transform.api.exception;

import com.dtyunxi.cube.commons.exceptions.BizException;

/**
 * 描述
 *
 * @author zimu
 * @date 2021/12/13/013
 * @since 1.0.0
 */
public enum PlatformExceptionCode {

    //转单相关异常 50000<= code < 60000
    NORMAL_EXCEPTION("50000", "%s"),
    CHECK_PARAM_ID_NULL("50001", "平台订单id不能为空"),
    CHECK_STATUS_STATUS_NOT_ALLOW("50002", "平台订单当前状态：%s，不允许当前操作"),
    CHECK_PARAM_SALE_ORDER_NO_NOT_ALLOW("50003", "销售订单号不允许为空"),
    CHECK_INSERT_PLATFORM_ORDER_REPEAT("50004", "平台订单号%s重复插入"),
    CHECK_INSERT_PLATFORM_ORDER_EXIST("50005", "平台订单号%s已存在"),
    CHECK_PARAM_PNO_NULL("50006", "平台订单号不能为空"),
    LOCK_OPT("50007", "操作频繁，稍后再试"),
    CHECK_PARAM_SHOP_CODE_NULL("50008", "入参店铺编号不能为空"),
    QUERY_SHOP_INFO_FAIL("50009", "获取%s店铺渠道信息失败"),
    QUERY_SHOP_INFO_IS_NULL("50010", "获取%s店铺渠道信息为空，请正确配置"),
    QUERY_SHOP_INFO_NUM_WRONG("50011", "获取%s店铺渠道信息数量为%s，请正确配置"),
    CHECK_ORDER_INFO_ADDRESS_FAIL("50012", "入参订单收货地址“%s”数据缺失"),
    CHECK_ORDER_INFO_ITEM_LIST_NULL("50013", "入参订单商品数据缺失"),
    CHECK_ORDER_INFO_ITEM_LIST_CODE_NULL("50014", "入参订单商品sku编号数据缺失"),
    CHECK_ORDER_INFO_ITEM_LIST_NUM_NULL("50015", "入参订单商品%s数量数据有误"),
    QUERY_ITEM_INFO_IS_NULL("50016", "获取不到订单商品信息"),
    CHECK_ORDER_INFO_ITEM_LIST_NUM_REPEAT("50017", "相同类型订单商品不允许重复：%s"),
    CHECK_ORDER_INFO_ITEM_LIST_GIFT_TYPE_WRONG("50018", "订单商品赠品类型数据有误：%s"),
    CHECK_ORDER_INFO_ITEM_LIST_INFO_FAIL("50019", "订单商品数据获取失败"),
    CHECK_ORDER_INFO_ITEM_LIST_INFO_HAD_NULL("50020", "订单商品数据匹配失败：%s"),
    CHECK_ORDER_INFO_ITEM_LIST_INFO_STATUS_0("50021", "订单商品状态失效：%s"),
    CHECK_ORDER_INFO_ITEM_LIST_PRICE_NULL("50022", "入参订单商品价格数据有误：%s"),
    OPT_ORDER_SALE_ORDER_FAIL("50023", "转单异常，创建销售订单失败:%s"),
    QUERY_CUSTOMER_INFO_IS_NULL("50024", "获取不到%s的客户信息"),
    QUERY_CUSTOMER_INFO_REPEAT("50025", "%s客户信息重复，请检查"),
    QUERY_CUSTOMER_INFO_FAIL("50026", "获取%s客户信息失败"),
    QUERY_ORDER_INFO_ADDRESS_CODE_NULL("50027", "获取%s编码%s信息为空"),
    QUERY_ORDER_INFO_ADDRESS_CODE_WRONG_0("50028", "%s地区信息关系不全"),
    QUERY_ORDER_INFO_ADDRESS_CODE_WRONG_1("50029", "%s不属于%s，区域信息关系错误"),
    CHECK_ORDER_INFO_ORDER_SOURCE_NULL("50030", "订单来源不允许为空"),
    CHECK_ORDER_INFO_ORDER_SOURCE_EXCHANGE_NULL("50031", "订单来源转换异常"),
    CHECK_PARAM_ORDER_CHANNEL_CODE_NULL("50032", "订单渠道编号不能为空"),
    CHECK_PARAM_DEFAULT_WAREHOUSE_CODE_NULL("50033", "默认发货仓编号不能为空"),
    CHECK_PARAM_CHANNEL_WAREHOUSE_CODE_NULL("50033", "渠道仓编号不能为空"),
    QUERY_ORDER_CHANNEL_INFO_IS_NULL("50034", "获取%s订单渠道信息为空，请正确配置"),
    QUERY_ORDER_INFO_IS_NULL("50035", "获取%s为空"),
    QUERY_ORDER_CHANNEL_INFO_STATUS_FAIL("50036", "%s订单渠道未启用，请正确配置"),
    QUERY_WAREHOUSE_REL_IS_NULL("50037", "渠道和逻辑仓库关系为空"),
    QUERY_CANCEL_PLATFORM_ORDER_NULL("50040", "取消平台单-该平台单号获取不到平台单"),
    ;

    private final String code;

    private final String msg;

    private PlatformExceptionCode(String val, String info) {
        this.code = val;
        this.msg = info;

    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public String getMsg(Object... formats) {
        return String.format(this.msg, formats);
    }

    public BizException buildBizException() {
        return new BizException(this.code, this.msg);
    }

    public BizException buildBizException(Object... formats) {
        String message = String.format(this.msg, formats);
        return new BizException(this.code, message);
    }
}
