package com.dtyunxi.yundt.cube.center.transform.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderChannelReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PcpOrderChannelRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* PCP订单渠道表服务接口
*
* @author yuangui
* @since 2022-04-01
*/
@Api(tags = {"PCP订单渠道表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-transform-api-query-IPcpOrderChannelQueryApi",
    name = "${yundt.cube.center.transform.api.name:yundt-cube-center-transform}",
    path = "/v1/platform/orderChannel",
    url = "${yundt.cube.center.transform.api:}"
)
public interface IPcpOrderChannelQueryApi {

    /**
    * 根据id查询PCP订单渠道表
    *
    * @param id PCP订单渠道表id
    * @return   PCP订单渠道表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询PCP订单渠道表", notes = "根据id查询PCP订单渠道表")
    RestResponse<PcpOrderChannelRespDto> queryById(@PathVariable("id") Long id);

    /**
     * @Description 根据对象查询PCP店铺渠道表
     * @param reqDto
     * @return {@link RestResponse<  PcpOrderChannelRespDto >}
     **/
    @PostMapping(value = "/queryByOrderChannel", produces = "application/json")
    @ApiOperation(value = "根据对象查询PCP店铺渠道表", notes = "根据对象查询PCP店铺渠道表")
    RestResponse<List<PcpOrderChannelRespDto>> queryByShopChannel(@RequestBody PcpOrderChannelReqDto reqDto);

    /**
    * PCP订单渠道表分页数据
    *
    * @param filter   PCP订单渠道表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return PCP订单渠道表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "PCP订单渠道表分页数据", notes = "根据filter查询条件查询PCP订单渠道表数据，filter=PcpOrderChannelReqDto")
    RestResponse<PageInfo<PcpOrderChannelRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
