/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.transform.biz.apiimpl;

import com.dtyunxi.cube.component.track.commons.utils.TransactionTrackContextUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.transform.api.IPcpOrderApi;
import com.dtyunxi.yundt.cube.center.transform.api.constant.PlatformOrderSource;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderAuditOptReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderCancelReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderRespDto;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPcpOrderSourceService;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPlatformOrderService;
import com.dtyunxi.yundt.cube.center.transform.biz.utils.AssertUtil;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="pcpOrderApi")
public class PcpOrderApiImpl
implements IPcpOrderApi {
    private static final Logger logger = LoggerFactory.getLogger(PcpOrderApiImpl.class);
    @Resource
    private IPcpOrderSourceService pcpOrderSourceService;
    @Resource
    private IPlatformOrderService platformOrderService;

    public RestResponse<Long> addPcpOrderProcess(PcpOrderReqDto addReqDto) {
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestUrl", (Object)"http://127.0.0.1/");
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestData", (Object)"code=51241243&id=125623&");
        Integer orderSource = Objects.isNull(addReqDto.getOrderSource()) ? 0 : addReqDto.getOrderSource();
        return this.pcpOrderSourceService.source(orderSource).addPcpOrderProcess(addReqDto);
    }

    public RestResponse<Void> addPcpYyjOrderProcess(List<PcpOrderReqDto> pcpOrderReqDtos) {
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestUrl", (Object)"http://127.0.0.1/");
        TransactionTrackContextUtils.setTrackLogRequestData((String)"requestData", (Object)"code=51241243&id=125623&");
        return this.pcpOrderSourceService.source(PlatformOrderSource.SOURCE_1.getCode()).addPcpYyjOrderProcess(pcpOrderReqDtos);
    }

    public RestResponse<Void> transformPcpOrder(Long id) {
        return this.pcpOrderSourceService.source(0).transformPcpOrder(id);
    }

    public RestResponse<Void> transformPcpOrder(PcpOrderReqDto pcpOrderReqDto) {
        return this.pcpOrderSourceService.source(0).transformPcpOrder(pcpOrderReqDto);
    }

    public RestResponse<Void> abolishPcpOrder(PcpOrderReqDto pcpOrderReqDto) {
        Integer orderSource = Objects.isNull(pcpOrderReqDto.getOrderSource()) ? 0 : pcpOrderReqDto.getOrderSource();
        return this.pcpOrderSourceService.source(orderSource).abolishPcpOrder(pcpOrderReqDto);
    }

    public RestResponse<Long> savePcpOrder(PcpOrderReqDto pcpOrderReqDto) {
        return this.pcpOrderSourceService.source(0).savePcpOrder(pcpOrderReqDto);
    }

    public RestResponse<Void> cancelPlatformOrder(PlatformOrderCancelReqDto platformOrderCancelReqDto) {
        AssertUtil.assertNotBlank(platformOrderCancelReqDto.getPlatformOrderNo(), "\u5e73\u53f0\u5355\u53f7\u4e3a\u7a7a");
        PlatformOrderRespDto platformOrderRespDto = this.platformOrderService.queryNormalByPlatformNo(platformOrderCancelReqDto.getPlatformOrderNo());
        AssertUtil.assertNotNull(platformOrderRespDto, "\u5e73\u53f0\u5355\u4fe1\u606f\u4e3a\u7a7a");
        Integer orderSource = Objects.isNull(platformOrderRespDto.getOrderSource()) ? 0 : platformOrderRespDto.getOrderSource();
        return this.pcpOrderSourceService.source(orderSource).cancelPlatformOrder(platformOrderCancelReqDto);
    }

    public RestResponse<Boolean> checkPcpOrder(PcpOrderReqDto pcpOrderReqDto) {
        return null;
    }

    public RestResponse<Void> logisticsAudit(PlatformOrderAuditOptReqDto auditOptReqDto) {
        this.pcpOrderSourceService.source(PlatformOrderSource.SOURCE_1.getCode()).logisticsAudit(auditOptReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> warehouseAudit(PlatformOrderAuditOptReqDto auditOptReqDto) {
        this.pcpOrderSourceService.source(PlatformOrderSource.SOURCE_1.getCode()).warehouseAudit(auditOptReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> yyjRefTransformOpt(String parentPlatformNo, Boolean refTransform) {
        this.pcpOrderSourceService.source(PlatformOrderSource.SOURCE_1.getCode()).yyjRefTransformOpt(parentPlatformNo, refTransform);
        return RestResponse.VOID;
    }
}

