/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.transform.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.component.track.commons.utils.TransactionTrackContextUtils;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.common.csp.constant.CspClaimOrderStatusEnum;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPUpdateCspClaimOrderReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.data.api.IPcpDictApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.PcpRegionRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderSourceEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.constant.PlatformOrderAuditStatusEnum;
import com.dtyunxi.yundt.cube.center.transform.api.constant.PlatformOrderSource;
import com.dtyunxi.yundt.cube.center.transform.api.constant.PlatformOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.transform.api.constant.PlatformTransformOrderStatus;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderAuditOptReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderCancelReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderSpAuditReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderSpExtReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PcpOrderChannelRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderSpExtRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.exception.PlatformAssert;
import com.dtyunxi.yundt.cube.center.transform.api.exception.PlatformExceptionCode;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPcpOrderService;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPcpOrderSourceService;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPlatformOrderItemService;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPlatformOrderService;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPlatformOrderSpAuditService;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPlatformOrderSpExtService;
import com.dtyunxi.yundt.cube.center.transform.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.transform.biz.utils.NoGenerateUtil;
import com.dtyunxi.yundt.cube.center.transform.dao.das.PlatformOrderDas;
import com.dtyunxi.yundt.cube.center.transform.dao.eo.PlatformOrderEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserExtQueryApi;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.share.dto.calc.DisplacePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.UpdatePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDetailDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.CollectionUtils;

@Service
public class CspPcpOrderServiceImpl
implements IPcpOrderService {
    private static final Logger logger = LoggerFactory.getLogger(CspPcpOrderServiceImpl.class);
    @Resource
    private IPlatformOrderService platformOrderService;
    @Resource
    private IPlatformOrderItemService platformOrderItemService;
    @Lazy
    @Resource
    private IPcpOrderSourceService pcpOrderSourceService;
    @Resource
    private ISaleOrderOptApi saleOrderOptApi;
    @Resource
    private NoGenerateUtil noGenerateUtil;
    @Resource
    private ICacheService cacheService;
    @Autowired
    private PlatformOrderDas platformOrderDas;
    public static final String YYJ_CHILD_ORDER_NUM_GROUP = "yyj-child-order-num";
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private IChannelInventoryExposedApi shareChannelInventoryExposedApi;
    @Resource
    private IPcpDictApi pcpDictApi;
    @Resource
    private IPlatformOrderSpAuditService platformOrderSpAuditService;
    @Resource
    private IPlatformOrderSpExtService platformOrderSpExtService;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ISaleOrderApi saleOrderApi;
    @Resource
    private IUserExtQueryApi userExtQueryApi;
    @Value(value="${yundt.com.yyj.maximumPool.size:20}")
    private Integer yyjMaximumPoolSize = 20;
    private final ExecutorService executorService = new ThreadPoolExecutor(2, this.yyjMaximumPoolSize, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(5, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
    private static final List<String> yyjOrderTypeList = Lists.newArrayList((Object[])new String[]{SaleOrderTypeEnum.REPLENISHMENT_ORDER.getType(), SaleOrderTypeEnum.ACTIVITY_ORDER.getType(), SaleOrderTypeEnum.NUTRITION_INTEGRAL.getType()});
    private static final List<String> cspOrderTypeList = Lists.newArrayList((Object[])new String[]{SaleOrderTypeEnum.INTEGRAL_ORDER.getType(), SaleOrderTypeEnum.AGENCY_ORDER.getType(), SaleOrderTypeEnum.OTHER_OUT_STOCK.getType(), SaleOrderTypeEnum.SECONDARY_DISTRIBUTION.getType(), SaleOrderTypeEnum.INTERNAL_DISTRIBUTION.getType(), SaleOrderTypeEnum.CHILD_DIRECT_SALES.getType(), SaleOrderTypeEnum.PRESALE_ORDER.getType(), SaleOrderTypeEnum.MAIYOU_ALLOT.getType(), SaleOrderTypeEnum.SPECIAL_CHANNEL_ORDER.getType()});

    @Override
    public int getOrderSourceType() {
        return PlatformOrderSource.SOURCE_1.getCode();
    }

    private boolean getTransOrderStatus() {
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.pcpDictApi.queryByGroupCodeAndCode("pcpTransform", "pcpTransfromStatus"));
        logger.info("\u83b7\u53d6\u8f6c\u5355\u5b57\u5178\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)dictDto));
        if (Objects.isNull(dictDto)) {
            return false;
        }
        return Objects.equals(dictDto.getValue(), "1");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> addPcpOrderProcess(PcpOrderReqDto addReqDto) {
        logger.info("CSP\u63d0\u4ea4\u8ba2\u5355\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
        Long orderId = null;
        if (cspOrderTypeList.contains(addReqDto.getOrderType())) {
            orderId = this.savePcpPurchaseOrder(addReqDto);
        } else if (Objects.equals(SaleOrderTypeEnum.COMPENSATION_ORDER.getType(), addReqDto.getOrderType()) || Objects.equals(SaleOrderTypeEnum.COMPENSATION_NOT_ORDER.getType(), addReqDto.getOrderType())) {
            PlatformOrderRespDto normalPlatformDto = this.platformOrderService.queryNormalByPlatformNo(addReqDto.getPlatformOrderNo());
            if (Objects.nonNull(normalPlatformDto) && Objects.nonNull(normalPlatformDto.getId()) && !Objects.equals(normalPlatformDto.getTransferOrderStatus(), PlatformTransformOrderStatus.STATUS_2.code)) {
                PcpOrderReqDto abolishDto = new PcpOrderReqDto();
                abolishDto.setId(normalPlatformDto.getId());
                abolishDto.setOrderSource(normalPlatformDto.getOrderSource());
                abolishDto.setObsoleteReason("CSP\u518d\u6b21\u901a\u8fc7\u4f5c\u5e9f\u6e20\u9053\u5355");
                logger.info("CSP\u63a8\u9001\u7d22\u8d54\u8ba2\u5355\u4f5c\u5e9f\u6e20\u9053\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)abolishDto));
                this.abolishPcpOrder(abolishDto);
            }
            addReqDto.setTransferOrderStatus(Integer.valueOf(PlatformTransformOrderStatus.STATUS_4.code));
            orderId = (Long)RestResponseHelper.extractData(this.pcpOrderSourceService.source(PlatformOrderSource.SOURCE_0.getCode()).savePcpOrder(addReqDto));
            addReqDto.setId(orderId);
            this.saveCspAuditLog(addReqDto, PlatformOrderAuditStatusEnum.AUDIT_PASS.getCode(), addReqDto.getSpExtReqDto().getApprover(), addReqDto.getSpExtReqDto().getApprovalRemark());
        } else {
            orderId = (Long)RestResponseHelper.extractData(this.pcpOrderSourceService.source(PlatformOrderSource.SOURCE_0.getCode()).savePcpOrder(addReqDto));
            addReqDto.setId(orderId);
            this.transformPcpOrder(addReqDto);
        }
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseStatus", (Object)"ok");
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseData", (Object)"status=abc&msg=ok");
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseCode", (Object)"200");
        return new RestResponse((Object)orderId);
    }

    private void saveCspAuditLog(PcpOrderReqDto addReqDto, String auditOperation, String approver, String approvalRemark) {
        PlatformOrderSpAuditReqDto spAuditReqDto = new PlatformOrderSpAuditReqDto();
        spAuditReqDto.setOrganizationId(addReqDto.getOrganizationId());
        spAuditReqDto.setOrganizationCode(addReqDto.getOrganizationCode());
        spAuditReqDto.setOrganizationName(addReqDto.getOrganizationName());
        spAuditReqDto.setPlatformOrderId(addReqDto.getId());
        spAuditReqDto.setPlatformOrderNo(addReqDto.getPlatformOrderNo());
        spAuditReqDto.setTransferOrderStatus(addReqDto.getTransferOrderStatus());
        spAuditReqDto.setAuditFile("");
        spAuditReqDto.setAuditOperation(auditOperation);
        spAuditReqDto.setAuditRemark(approvalRemark);
        spAuditReqDto.setAuditTime(new Date());
        spAuditReqDto.setAuditPerson(approver);
        this.platformOrderSpAuditService.addPlatformOrderSpAudit(spAuditReqDto);
    }

    private Long savePcpPurchaseOrder(PcpOrderReqDto addReqDto) {
        Long orderId = null;
        if (Objects.equals(addReqDto.getPlatformOrderStatus(), PlatformOrderStatusEnum.SUBMIT.getCode())) {
            orderId = (Long)RestResponseHelper.extractData(this.pcpOrderSourceService.source(PlatformOrderSource.SOURCE_0.getCode()).savePcpOrder(addReqDto));
        }
        if (Objects.equals(addReqDto.getPlatformOrderStatus(), PlatformOrderStatusEnum.AUDIT_PASS.getCode())) {
            if (Objects.equals(addReqDto.getOrderType(), SaleOrderTypeEnum.INTEGRAL_ORDER.getType())) {
                logger.info("\u5e73\u53f0\u8ba2\u5355[{}]\u79ef\u5206\u8ba2\u5355\u7c7b\u578b\u4e0d\u505a\u5904\u7406", (Object)addReqDto.getPlatformOrderNo());
                PlatformOrderRespDto platformOrderRespDto = this.platformOrderService.queryNormalByPlatformNo(addReqDto.getPlatformOrderNo());
                return Objects.nonNull(platformOrderRespDto) ? platformOrderRespDto.getId() : null;
            }
            ArrayList abolishStatusList = Lists.newArrayList((Object[])new Integer[]{PlatformTransformOrderStatus.STATUS_2.getCode()});
            PlatformOrderQueryReqDto oldPlatformOrderQuery = new PlatformOrderQueryReqDto();
            oldPlatformOrderQuery.setPlatformOrderNo(addReqDto.getPlatformOrderNo());
            oldPlatformOrderQuery.setNotInTransferOrderStatusList((List)abolishStatusList);
            List<PlatformOrderRespDto> normalPlatformDto = this.platformOrderService.queryListByParam(oldPlatformOrderQuery);
            logger.info("csp\u5ba1\u6838\u901a\u8fc7\u9700\u4f5c\u5e9f\u539f\u5355:{}", (Object)JSON.toJSONString(normalPlatformDto));
            for (PlatformOrderRespDto orderRespDto : normalPlatformDto) {
                this.abolishPlatformOrderStatus(orderRespDto.getId(), "CSP\u5ba1\u6838\u901a\u8fc7\u4f5c\u5e9f\u539f\u6e20\u9053\u5355");
            }
            this.pcpOrderSourceService.source(PlatformOrderSource.SOURCE_0.getCode()).savePcpOrder(addReqDto);
            String sourceOrderNo = addReqDto.getSourceOrderNo();
            logger.info("SourceOrderNo==>{}", (Object)sourceOrderNo);
            if (StringUtils.isEmpty((CharSequence)sourceOrderNo)) {
                logger.info("\u5e73\u53f0\u8ba2\u5355[{}]\u6765\u6e90\u5355\u53f7\u4e3a\u7a7a", (Object)sourceOrderNo);
                sourceOrderNo = addReqDto.getPlatformOrderNo();
            }
            List<String> sourceOrderList = Arrays.asList(sourceOrderNo.split(","));
            logger.info("platformOrderNoList==>{}", (Object)JSON.toJSONString(sourceOrderList));
            PlatformOrderQueryReqDto queryDto = new PlatformOrderQueryReqDto();
            queryDto.setPlatformOrderNoList(sourceOrderList);
            queryDto.setNotInTransferOrderStatusList((List)abolishStatusList);
            List<PlatformOrderRespDto> platformOrderRespDtos = this.platformOrderService.queryListByParam(queryDto);
            if (CollectionUtils.isEmpty(platformOrderRespDtos)) {
                logger.info("\u5e73\u53f0\u8ba2\u5355\u5df2\u5168\u90e8\u4f5c\u5e9f,\u91cd\u65b0\u751f\u6210\u5355\u636e");
            }
            if (platformOrderRespDtos.size() > 1) {
                ArrayList releasePcpOrderList = Lists.newArrayList((Object[])new PcpOrderReqDto[]{addReqDto});
                String oldOrderId = "";
                String oldOrderNo = "";
                String transformOrderNo = this.noGenerateUtil.generateTransformOrderNo();
                addReqDto.setTransformOrderNo(transformOrderNo);
                addReqDto.setNewSaleOrderNo(this.getSaleOrderNo(addReqDto.getPlatformOrderNo()));
                for (PlatformOrderRespDto platformOrderRespDto : platformOrderRespDtos) {
                    if (StringUtils.isEmpty((CharSequence)oldOrderId)) {
                        oldOrderId = platformOrderRespDto.getId() + "";
                        oldOrderNo = platformOrderRespDto.getTransformOrderNo();
                    } else {
                        oldOrderId = oldOrderId + "," + platformOrderRespDto.getId();
                        oldOrderNo = oldOrderNo + "," + platformOrderRespDto.getTransformOrderNo();
                    }
                    this.mergePlatformOrderStatus(platformOrderRespDto.getId(), transformOrderNo);
                    if (!Objects.equals(platformOrderRespDto.getOrderType(), SaleOrderTypeEnum.INTEGRAL_ORDER.getType())) continue;
                    List<PlatformOrderItemRespDto> platformOrderItemRespDtos = this.platformOrderItemService.queryListByOrderId(platformOrderRespDto.getId());
                    ArrayList itemReqDtoList = Lists.newArrayList();
                    CubeBeanUtils.copyCollection((Collection)itemReqDtoList, platformOrderItemRespDtos, PlatformOrderItemReqDto.class);
                    PcpOrderReqDto pcpOrderReqDto = new PcpOrderReqDto();
                    CubeBeanUtils.copyProperties((Object)pcpOrderReqDto, (Object)platformOrderRespDto, (String[])new String[0]);
                    pcpOrderReqDto.setItemReqDtoList((List)itemReqDtoList);
                    releasePcpOrderList.add(pcpOrderReqDto);
                    for (PlatformOrderItemReqDto platformOrderItemReqDto : itemReqDtoList) {
                        platformOrderItemReqDto.setIntegral(YesOrNoEnum.YES.getType());
                        platformOrderItemReqDto.setOldItemId(platformOrderItemReqDto.getId());
                        platformOrderItemReqDto.setId(null);
                    }
                    addReqDto.getItemReqDtoList().addAll(itemReqDtoList);
                    String redisKey = platformOrderRespDto.getPlatformOrderNo();
                    this.cacheService.delCache("platform-sale-order", redisKey);
                }
                addReqDto.setReTransformOrderNo(oldOrderNo);
                addReqDto.setOldOrderId(oldOrderId);
                addReqDto.setId(null);
                orderId = (Long)RestResponseHelper.extractData(this.pcpOrderSourceService.source(PlatformOrderSource.SOURCE_0.getCode()).savePcpOrder(addReqDto));
                logger.info("\u662f\u5426\u63d0\u524d\u9884\u5360\u5e93\u5b58ReleaseState{}", (Object)addReqDto.getReleaseState());
                if (Objects.equals(addReqDto.getReleaseState(), 1)) {
                    try {
                        this.releaseChildPreemptParent(addReqDto, releasePcpOrderList, addReqDto.getNewSaleOrderNo());
                    }
                    catch (Exception e) {
                        logger.info("\u91ca\u653e\u7ecf\u9500&\u79ef\u5206\u8ba2\u5355\uff0c\u9884\u5360\u5408\u5355\u540e\u7684\u5e93\u5b58\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                        logger.warn("{},{}", (Object)e.getMessage(), (Object)e);
                    }
                }
            } else {
                orderId = platformOrderRespDtos.get(0).getId();
            }
            try {
                logger.info("\u4f5c\u5e9f\u9500\u552e\u5355:{}", (Object)addReqDto.getPlatformOrderNo());
                RestResponseHelper.checkOrThrow((RestResponse)this.saleOrderApi.cspObsoleteByPlatformOrderNo(addReqDto.getPlatformOrderNo()));
            }
            catch (Exception e) {
                logger.info("\u4f5c\u5e9f\u9500\u552e\u5355\u5f02\u5e38:{}", (Object)e.getMessage());
                logger.error(e.getMessage(), (Throwable)e);
            }
            addReqDto.setId(orderId);
            if (this.getTransOrderStatus()) {
                logger.info("csp\u5ba1\u6838\u901a\u8fc7\uff0c\u8f6c\u5355");
                this.pcpOrderSourceService.source(PlatformOrderSource.SOURCE_0.getCode()).transformPcpOrder(addReqDto);
            } else {
                logger.info("csp\u5ba1\u6838\u901a\u8fc7\uff0c\u72b6\u6001\u53d8\u5f02\u5e38");
                this.errorPlatformOrderStatus(orderId, PlatformTransformOrderStatus.STATUS_INIT_1.code, "\u672a\u5f00\u542f\u8f6c\u5355\u914d\u7f6e");
            }
        }
        return orderId;
    }

    private String getSaleOrderNo(String platformOrderNo) {
        String saleOrderNo = (String)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.getSaleOrderNo());
        return saleOrderNo;
    }

    private void releaseChildPreemptParent(PcpOrderReqDto addReqDto, List<PcpOrderReqDto> releasePcpOrderList, String newSaleOrderNo) {
        UpdatePreemptDto childOrderPreempt = new UpdatePreemptDto();
        PreemptDto shPreemptParam = new PreemptDto();
        shPreemptParam.setSourceType(addReqDto.getOrderType());
        shPreemptParam.setSourceNo(newSaleOrderNo);
        shPreemptParam.setExternalOrderNo(addReqDto.getPlatformOrderNo());
        shPreemptParam.setValidNegative(Boolean.FALSE);
        if (Objects.equals(addReqDto.getCanSplitFlag(), YesOrNoEnum.NO.getType()) && com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)addReqDto.getStoragePlace())) {
            shPreemptParam.setIsShoutVirtualWarehouse(Boolean.TRUE);
            shPreemptParam.setShoutVirtualWarehouseCode(addReqDto.getStoragePlace());
        }
        List itemReqDtoList = addReqDto.getItemReqDtoList();
        ArrayList shOperationDetailParamList = Lists.newArrayList();
        for (PlatformOrderItemReqDto itemReqDto : itemReqDtoList) {
            OperationDetailDto shOperationDetailParam = new OperationDetailDto();
            shOperationDetailParam.setSkuCode(itemReqDto.getSkuCode());
            shOperationDetailParam.setNum(itemReqDto.getItemNum());
            shOperationDetailParam.setWarehouseCode(addReqDto.getChannelWarehouseCode());
            shOperationDetailParamList.add(shOperationDetailParam);
        }
        shPreemptParam.setDetails((List)shOperationDetailParamList);
        childOrderPreempt.setPreemptParamList((List)Lists.newArrayList((Object[])new PreemptDto[]{shPreemptParam}));
        ArrayList releasePreemptParamList = Lists.newArrayList();
        for (PcpOrderReqDto pcpOrderReqDto : releasePcpOrderList) {
            ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
            releasePreemptParam.setExternalOrderNo(pcpOrderReqDto.getPlatformOrderNo());
            releasePreemptParam.setSourceType(pcpOrderReqDto.getOrderType());
            releasePreemptParam.setSourceNo(pcpOrderReqDto.getSaleOrderNo());
            releasePreemptParamList.add(releasePreemptParam);
        }
        childOrderPreempt.setReleasePreemptParamList((List)releasePreemptParamList);
        logger.info("\u91ca\u653e\u5b50\u5355\u9884\u5360\uff0c\u91cd\u65b0\u6309\u4e3b\u5355\u9884\u5360\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)childOrderPreempt));
        RestResponseHelper.extractData((RestResponse)this.shareChannelInventoryExposedApi.updatePreempt(childOrderPreempt));
    }

    private void releaseMergePreemptOrig(PlatformOrderRespDto mergeOrder, List<PlatformOrderRespDto> preemptPcpOrderList, List<PlatformOrderItemRespDto> orderItemRespDtos) {
        UpdatePreemptDto childOrderPreempt = new UpdatePreemptDto();
        ArrayList shPreemptParamList = Lists.newArrayList();
        for (PlatformOrderRespDto orderRespDto : preemptPcpOrderList) {
            PreemptDto shPreemptParam = new PreemptDto();
            shPreemptParam.setSourceType(orderRespDto.getOrderType());
            shPreemptParam.setSourceNo(orderRespDto.getSaleOrderNo());
            shPreemptParam.setExternalOrderNo(orderRespDto.getPlatformOrderNo());
            shPreemptParam.setValidNegative(Boolean.FALSE);
            if (Objects.equals(orderRespDto.getCanSplitFlag(), YesOrNoEnum.NO.getType()) && com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotBlank((CharSequence)orderRespDto.getStoragePlace())) {
                shPreemptParam.setIsShoutVirtualWarehouse(Boolean.TRUE);
                shPreemptParam.setShoutVirtualWarehouseCode(orderRespDto.getStoragePlace());
            }
            List itemReqDtoList = orderItemRespDtos.stream().filter(dto -> Objects.equals(dto.getOrderId(), orderRespDto.getId())).collect(Collectors.toList());
            ArrayList shOperationDetailParamList = Lists.newArrayList();
            for (PlatformOrderItemRespDto orderItem : itemReqDtoList) {
                OperationDetailDto shOperationDetailParam = new OperationDetailDto();
                shOperationDetailParam.setSkuCode(orderItem.getSkuCode());
                shOperationDetailParam.setNum(orderItem.getItemNum());
                shOperationDetailParam.setWarehouseCode(mergeOrder.getChannelWarehouseCode());
                shOperationDetailParamList.add(shOperationDetailParam);
            }
            shPreemptParam.setDetails((List)shOperationDetailParamList);
            shPreemptParamList.add(shPreemptParam);
        }
        childOrderPreempt.setPreemptParamList((List)shPreemptParamList);
        ArrayList releasePreemptParamList = Lists.newArrayList();
        ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
        releasePreemptParam.setExternalOrderNo(mergeOrder.getPlatformOrderNo());
        releasePreemptParam.setSourceType(mergeOrder.getOrderType());
        releasePreemptParam.setSourceNo(mergeOrder.getSaleOrderNo());
        releasePreemptParamList.add(releasePreemptParam);
        childOrderPreempt.setReleasePreemptParamList((List)releasePreemptParamList);
        logger.info("\u91ca\u653e\u5b50\u5355\u9884\u5360\uff0c\u91cd\u65b0\u6309\u4e3b\u5355\u9884\u5360\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)childOrderPreempt));
        RestResponseHelper.extractData((RestResponse)this.shareChannelInventoryExposedApi.updatePreempt(childOrderPreempt));
    }

    @Override
    public RestResponse<Void> transformPcpOrder(Long id) {
        return this.pcpOrderSourceService.source(PlatformOrderSource.SOURCE_0.getCode()).transformPcpOrder(id);
    }

    @Override
    public RestResponse<Void> transformPcpOrder(PcpOrderReqDto pcpOrderReqDto) {
        return this.pcpOrderSourceService.source(PlatformOrderSource.SOURCE_0.getCode()).transformPcpOrder(pcpOrderReqDto);
    }

    @Override
    public RestResponse<Void> abolishPcpOrder(PcpOrderReqDto pcpOrderReqDto) {
        PlatformAssert.notNull((Object)pcpOrderReqDto.getId(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u5e73\u53f0\u5355id\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformOrderRespDto platformOrderRespDto = this.platformOrderService.queryById(pcpOrderReqDto.getId());
        PlatformAssert.notNull((Object)platformOrderRespDto, (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u5e73\u53f0\u5355\u4fe1\u606f\u4e0d\u5b58\u5728"});
        this.checkPlatformOrderStatus(pcpOrderReqDto, PlatformTransformOrderStatus.forCode((int)platformOrderRespDto.getTransferOrderStatus()), PlatformTransformOrderStatus.STATUS_INIT_1, PlatformTransformOrderStatus.STATUS_1, PlatformTransformOrderStatus.STATUS_0);
        this.abolishPlatformOrderStatus(pcpOrderReqDto.getId(), pcpOrderReqDto.getObsoleteReason());
        return RestResponse.VOID;
    }

    private void checkPlatformOrderStatus(PcpOrderReqDto pcpOrderReqDto, PlatformTransformOrderStatus nowStatus, PlatformTransformOrderStatus ... allowStatus) {
        PlatformTransformOrderStatus status;
        logger.info("checkPlatformOrderStatus\uff0c{}\u5f53\u524d\u72b6\u6001={},\u5141\u8bb8\u901a\u8fc7\u72b6\u6001={}", new Object[]{pcpOrderReqDto.getId(), nowStatus, JSON.toJSONString((Object)allowStatus)});
        if (allowStatus == null) {
            throw PlatformExceptionCode.CHECK_STATUS_STATUS_NOT_ALLOW.buildBizException(new Object[]{nowStatus.desc});
        }
        boolean inAllow = false;
        PlatformTransformOrderStatus[] platformTransformOrderStatusArray = allowStatus;
        int n = platformTransformOrderStatusArray.length;
        for (int i = 0; i < n && !(inAllow = (status = platformTransformOrderStatusArray[i]) == nowStatus); ++i) {
        }
        if (!inAllow) {
            throw PlatformExceptionCode.CHECK_STATUS_STATUS_NOT_ALLOW.buildBizException(new Object[]{nowStatus.desc});
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> cancelPlatformOrder(PlatformOrderCancelReqDto platformOrderCancelReqDto) {
        PlatformOrderQueryReqDto queryDto = new PlatformOrderQueryReqDto();
        queryDto.setPlatformOrderNoList(Collections.singletonList(platformOrderCancelReqDto.getPlatformOrderNo()));
        List<Object> platformOrderRespDtos = this.platformOrderService.queryListByParam(queryDto);
        platformOrderRespDtos = platformOrderRespDtos.stream().filter(dto -> !Objects.equals(dto.getTransferOrderStatus(), PlatformTransformOrderStatus.STATUS_2.getCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(platformOrderRespDtos)) {
            logger.info("\u5e73\u53f0\u8ba2\u5355\u5df2\u5168\u90e8\u4f5c\u5e9f");
            return RestResponse.VOID;
        }
        if (Objects.equals(platformOrderCancelReqDto.getPlatformOrderStatus(), PlatformOrderStatusEnum.AUDIT_NOT_PASS.getCode())) {
            this.cspAuditNotPass(platformOrderCancelReqDto, platformOrderRespDtos);
        }
        if (PlatformOrderStatusEnum.CANCEL.getCode().equals(platformOrderCancelReqDto.getPlatformOrderStatus())) {
            this.cspCancelPlatform(platformOrderCancelReqDto, platformOrderRespDtos);
        }
        return RestResponse.VOID;
    }

    private void cspAuditNotPass(PlatformOrderCancelReqDto platformOrderCancelReqDto, List<PlatformOrderRespDto> platformOrderRespDtos) {
        Object queryReqDto;
        Integer ifCancelIntegral = platformOrderCancelReqDto.getIfCancelIntegral();
        logger.info("\u662f\u5426\u53d6\u6d88\u79ef\u5206\u8ba2\u5355:{}", (Object)ifCancelIntegral);
        HashSet<Long> invalidPlatformList = new HashSet<Long>();
        ArrayList invalidSaleOrderList = Lists.newArrayList();
        List<Object> oldOrderIdList = Lists.newArrayList();
        ArrayList releaseInventoryList = Lists.newArrayList();
        PlatformOrderRespDto mainOrderDto = null;
        PlatformOrderRespDto childOrderDto = null;
        String jfPlatformOrderNo = null;
        for (PlatformOrderRespDto platformOrderRespDto : platformOrderRespDtos) {
            if (PlatformTransformOrderStatus.STATUS_INIT_1.getCode() == platformOrderRespDto.getTransferOrderStatus().intValue()) {
                String sourceOrderNo;
                if (Objects.equals(platformOrderRespDto.getReleaseState(), 1)) {
                    releaseInventoryList.add(platformOrderRespDto);
                }
                invalidPlatformList.add(platformOrderRespDto.getId());
                if (Objects.equals(ifCancelIntegral, YesOrNoEnum.YES.getType()) && StringUtils.isNotEmpty((CharSequence)(sourceOrderNo = platformOrderRespDto.getSourceOrderNo()))) {
                    List<String> sourceOrderList = Arrays.asList(sourceOrderNo.split(","));
                    for (String sourceNo : sourceOrderList) {
                        if (Objects.equals(sourceNo, platformOrderRespDto.getPlatformOrderNo())) continue;
                        jfPlatformOrderNo = sourceNo;
                    }
                }
            }
            if (PlatformTransformOrderStatus.STATUS_0.getCode() == platformOrderRespDto.getTransferOrderStatus().intValue()) {
                invalidSaleOrderList.add(platformOrderRespDto.getPlatformOrderNo());
            }
            if (PlatformTransformOrderStatus.STATUS_0.getCode() == platformOrderRespDto.getTransferOrderStatus().intValue() || PlatformTransformOrderStatus.STATUS_1.getCode() == platformOrderRespDto.getTransferOrderStatus().intValue()) {
                logger.info("\u6e20\u9053\u5355\u5df2\u8f6c\u5355\u4f5c\u5e9f\u9500\u552e\u8ba2\u5355:{}", (Object)platformOrderRespDto.getPlatformOrderNo());
                invalidPlatformList.add(platformOrderRespDto.getId());
                mainOrderDto = platformOrderRespDto;
                String oldOrderId = platformOrderRespDto.getOldOrderId();
                logger.info("\u7ecf\u9500\u8ba2\u5355\u91ca\u653e\u6709\u5df2\u5408\u5355\u72b6\u6001\u7684\u6e20\u9053\u5355:{}", (Object)oldOrderId);
                if (StringUtils.isNotEmpty((CharSequence)oldOrderId)) {
                    oldOrderIdList = Arrays.asList(oldOrderId.split(",")).stream().map(x -> Long.valueOf(x)).collect(Collectors.toList());
                }
            }
            if (!Objects.equals(SaleOrderTypeEnum.COMPENSATION_ORDER.getType(), platformOrderRespDto.getOrderType()) && !Objects.equals(SaleOrderTypeEnum.COMPENSATION_NOT_ORDER.getType(), platformOrderRespDto.getOrderType())) continue;
            PcpOrderReqDto pcpOrderReqDto = new PcpOrderReqDto();
            CubeBeanUtils.copyProperties((Object)pcpOrderReqDto, (Object)platformOrderRespDto, (String[])new String[0]);
            this.saveCspAuditLog(pcpOrderReqDto, PlatformOrderAuditStatusEnum.AUDIT_NOT_PASS.getCode(), platformOrderCancelReqDto.getApprover(), platformOrderCancelReqDto.getApprovalRemark());
        }
        if (null != jfPlatformOrderNo) {
            queryReqDto = new PlatformOrderQueryReqDto();
            queryReqDto.setPlatformOrderNo(jfPlatformOrderNo);
            queryReqDto.setOrderType(SaleOrderTypeEnum.INTEGRAL_ORDER.getType());
            queryReqDto.setNotInTransferOrderStatusList((List)Lists.newArrayList((Object[])new Integer[]{PlatformTransformOrderStatus.STATUS_2.getCode()}));
            List<PlatformOrderRespDto> jfPlatformList = this.platformOrderService.queryListByParam((PlatformOrderQueryReqDto)queryReqDto);
            logger.info("\u67e5\u8be2\u672a\u4f5c\u5e9f\u7684\u79ef\u5206\u8ba2\u5355:{},{}", jfPlatformOrderNo, (Object)jfPlatformList.size());
            for (PlatformOrderRespDto platformOrderRespDto : jfPlatformList) {
                releaseInventoryList.add(platformOrderRespDto);
                invalidPlatformList.add(platformOrderRespDto.getId());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)oldOrderIdList)) {
            queryReqDto = new PlatformOrderQueryReqDto();
            queryReqDto.setIdList((List)oldOrderIdList);
            List<PlatformOrderRespDto> oldPlatformList = this.platformOrderService.queryListByParam((PlatformOrderQueryReqDto)queryReqDto);
            for (PlatformOrderRespDto platformOrderRespDto : oldPlatformList) {
                if (Objects.equals(ifCancelIntegral, YesOrNoEnum.NO.getType()) && SaleOrderTypeEnum.INTEGRAL_ORDER.getType().equals(platformOrderRespDto.getOrderType())) {
                    childOrderDto = platformOrderRespDto;
                    continue;
                }
                invalidPlatformList.add(platformOrderRespDto.getId());
            }
        }
        logger.info("\u9700\u8981\u4f5c\u5e9f\u7684\u6e20\u9053\u8ba2\u5355id:{}", (Object)JSON.toJSONString(invalidPlatformList));
        for (Long platformOrderId : invalidPlatformList) {
            this.abolishPlatformOrderStatus(platformOrderId, "CSP\u8ba2\u5355\u5ba1\u6838\u4e0d\u901a\u8fc7");
        }
        if (Objects.isNull(jfPlatformOrderNo) && Objects.nonNull(childOrderDto)) {
            this.initPlatformOrderStatus(childOrderDto.getId(), childOrderDto.getTransferOrderStatus());
        }
        logger.info("\u4f5c\u5e9f\u9500\u552e\u8ba2\u5355\uff0c\u91ca\u653e\u5e93\u5b58:{}", (Object)JSON.toJSONString((Object)invalidSaleOrderList));
        if (invalidSaleOrderList.size() == 1) {
            RestResponseHelper.checkOrThrow((RestResponse)this.saleOrderOptApi.invalidOrderByPlatformOrderNo((String)invalidSaleOrderList.get(0)));
        }
        logger.info("\u5ba1\u6838\u4e0d\u901a\u8fc7\u4f5c\u5e9f\u6e20\u9053\u8ba2\u5355:{}", (Object)releaseInventoryList.size());
        for (PlatformOrderRespDto platformOrderRespDto : releaseInventoryList) {
            try {
                logger.info("\u5ba1\u6838\u4e0d\u901a\u8fc7\u4f5c\u5e9f\u91ca\u653e\u6e20\u9053\u5e93\u5b58\u4fe1\u606f");
                this.releaseInventory(platformOrderRespDto.getSaleOrderNo(), platformOrderRespDto.getOrderType(), platformOrderRespDto.getCanSplitFlag(), platformOrderRespDto.getPlatformOrderNo());
                logger.info("\u5ba1\u6838\u4e0d\u901a\u8fc7\u4f5c\u5e9f\u91ca\u653e\u6e20\u9053\u5e93\u5b58\u4fe1\u606f\u6210\u529f");
            }
            catch (Exception e) {
                logger.info("\u5ba1\u6838\u4e0d\u901a\u8fc7\u4f5c\u5e9f\u91ca\u653e\u6e20\u9053\u5e93\u5b58\u4fe1\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (Objects.nonNull(mainOrderDto) && Objects.nonNull(childOrderDto)) {
            try {
                logger.info("\u91ca\u653e\u7ecf\u9500\u8ba2\u5355:{}\u5e93\u5b58\uff0c\u9884\u5360\u7ecf\u9500\u79ef\u5206\u8ba2\u5355:{}\u5e93\u5b58", (Object)mainOrderDto.getSaleOrderNo(), (Object)childOrderDto.getSaleOrderNo());
                this.resleaseParentPreemptChild(mainOrderDto, childOrderDto, invalidSaleOrderList);
                logger.info("\u91ca\u653e\u7ecf\u9500\u8ba2\u5355:{}\u5e93\u5b58\uff0c\u9884\u5360\u7ecf\u9500\u79ef\u5206\u8ba2\u5355:{}\u5e93\u5b58\u6210\u529f", (Object)mainOrderDto.getSaleOrderNo(), (Object)childOrderDto.getSaleOrderNo());
            }
            catch (Exception e) {
                logger.info("\u91ca\u653e\u7ecf\u9500\u8ba2\u5355:{}\u5e93\u5b58\uff0c\u9884\u5360\u7ecf\u9500\u79ef\u5206\u8ba2\u5355:{}\u5e93\u5b58\u5f02\u5e38", (Object)mainOrderDto.getSaleOrderNo(), (Object)childOrderDto.getSaleOrderNo());
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void cspCancelPlatform(PlatformOrderCancelReqDto platformOrderCancelReqDto, List<PlatformOrderRespDto> platformOrderRespDtos) {
        PlatformOrderRespDto platformOrder = platformOrderRespDtos.get(0);
        List errorOrderList = platformOrderRespDtos.stream().filter(dto -> Objects.equals(dto.getTransferOrderStatus(), PlatformTransformOrderStatus.STATUS_1.code)).collect(Collectors.toList());
        logger.info("CSP\u53cd\u5ba1\u8ba2\u5355");
        if (SaleOrderTypeEnum.COMPENSATION_NOT_ORDER.getType().equals(platformOrder.getOrderType())) {
            List status0PlatformList = platformOrderRespDtos.stream().filter(dto -> Objects.equals(dto.getTransferOrderStatus(), PlatformTransformOrderStatus.STATUS_6.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(status0PlatformList)) {
                logger.info("\u672a\u5b58\u5728\u5df2\u8f6c\u5355\u72b6\u6001\u6e20\u9053\u5355\uff0c\u4e0d\u505a\u5904\u7406");
                return;
            }
            platformOrder = (PlatformOrderRespDto)status0PlatformList.get(0);
            logger.info("\u7ecf\u9500\u72b6\u6001\u5df2\u5ba1\u6838=>\u5f85\u4e0a\u6e38\u5ba1\u6838");
            this.initPlatformOrderStatus(platformOrder.getId(), platformOrder.getTransferOrderStatus());
        } else if (SaleOrderTypeEnum.CUSTOMER_REFUNDING_ORDER.getType().equals(platformOrder.getOrderType())) {
            this.abolishPlatformOrderStatus(platformOrder.getId(), "CSP\u53d6\u6d88\u8ba2\u5355");
            logger.info("csp\u53cd\u5ba1\u4f5c\u5e9f\u9500\u552e\u8ba2\u5355:{}", (Object)platformOrderCancelReqDto.getPlatformOrderNo());
            RestResponseHelper.checkOrThrow((RestResponse)this.saleOrderOptApi.invalidOrderByPlatformOrderNo(platformOrderCancelReqDto.getPlatformOrderNo()));
        } else if (!CollectionUtils.isEmpty(errorOrderList)) {
            logger.info("CSP\u53cd\u5ba1\u5904\u7406\u6e20\u9053\u5355\u5f02\u5e38:{}", (Object)platformOrderCancelReqDto.getPlatformOrderNo());
            this.doCspCancelError((PlatformOrderRespDto)errorOrderList.get(0));
        } else {
            logger.info("CSP\u53cd\u5ba1\u8ba2\u5355\u6302\u8d77:{}", (Object)platformOrderCancelReqDto.getPlatformOrderNo());
            RestResponseHelper.checkOrThrow((RestResponse)this.saleOrderApi.cspCancelOrderLock(platformOrderCancelReqDto.getPlatformOrderNo()));
        }
    }

    private void doCspCancelError(PlatformOrderRespDto platformOrder) {
        String sourceOrderNo = platformOrder.getSourceOrderNo();
        List<Object> sourceOrderList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)sourceOrderNo)) {
            sourceOrderList = Arrays.asList(sourceOrderNo.split(","));
        }
        if (!CollectionUtils.isEmpty((Collection)sourceOrderList) && sourceOrderList.size() == 1) {
            this.initPlatformOrderStatus(platformOrder.getId(), platformOrder.getTransferOrderStatus());
        } else {
            this.abolishPlatformOrderStatus(platformOrder.getId(), "CSP\u53cd\u5ba1\u4f5c\u5e9f");
            PlatformOrderQueryReqDto queryDto = new PlatformOrderQueryReqDto();
            queryDto.setPlatformOrderNoList((List)sourceOrderList);
            queryDto.setTransferOrderStatus(Integer.valueOf(PlatformTransformOrderStatus.STATUS_3.code));
            List<PlatformOrderRespDto> platformOrderRespDtoList = this.platformOrderService.queryListByParam(queryDto);
            if (CollectionUtils.isEmpty(platformOrderRespDtoList)) {
                logger.info("\u5e73\u53f0\u8ba2\u5355\u672a\u5b58\u5728\u5df2\u5408\u5e76\u8ba2\u5355,\u4e0d\u505a\u5904\u7406");
                return;
            }
            ArrayList origIdList = Lists.newArrayList();
            for (PlatformOrderRespDto platformOrderRespDto : platformOrderRespDtoList) {
                this.initPlatformOrderStatus(platformOrderRespDto.getId(), platformOrderRespDto.getTransferOrderStatus());
                origIdList.add(platformOrderRespDto.getId());
            }
            List<PlatformOrderItemRespDto> orderItemRespDtos = this.platformOrderItemService.queryListByOrderIds(origIdList);
            if (Objects.equals(platformOrder.getReleaseState(), 1)) {
                try {
                    this.releaseMergePreemptOrig(platformOrder, platformOrderRespDtoList, orderItemRespDtos);
                }
                catch (Exception e) {
                    logger.info("\u9884\u5360\u7ecf\u9500&\u79ef\u5206\u8ba2\u5355\uff0c\u91ca\u653e\u5408\u5355\u540e\u7684\u5e93\u5b58\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    logger.warn("{},{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    private void resleaseParentPreemptChild(PlatformOrderRespDto mainOrderDto, PlatformOrderRespDto childorderRespDto, List<String> invalidSaleOrderList) {
        if (StringUtils.isEmpty((CharSequence)mainOrderDto.getSaleOrderNo()) || StringUtils.isEmpty((CharSequence)childorderRespDto.getSaleOrderNo())) {
            logger.info("\u91ca\u653e\u7684\u4e3b\u5355\u6216\u9884\u5360\u5b50\u5355\u9500\u552e\u5355\u53f7\u4e3a\u7a7a");
            return;
        }
        UpdatePreemptDto parentOrderPreemt = new UpdatePreemptDto();
        ReleasePreemptDto shReleasePreemptParam = new ReleasePreemptDto();
        if (CollectionUtils.isEmpty(invalidSaleOrderList)) {
            shReleasePreemptParam.setSourceNo(mainOrderDto.getSaleOrderNo());
            shReleasePreemptParam.setSourceType(mainOrderDto.getOrderType());
            shReleasePreemptParam.setExternalOrderNo(mainOrderDto.getPlatformOrderNo());
        }
        parentOrderPreemt.setReleasePreemptParamList((List)Lists.newArrayList((Object[])new ReleasePreemptDto[]{shReleasePreemptParam}));
        ArrayList preemptParamList = Lists.newArrayList();
        PreemptDto shPreemptParam = new PreemptDto();
        shPreemptParam.setValidNegative(Boolean.FALSE);
        shPreemptParam.setExternalOrderNo(childorderRespDto.getPlatformOrderNo());
        shPreemptParam.setSourceNo(childorderRespDto.getSaleOrderNo());
        shPreemptParam.setSourceType(childorderRespDto.getOrderType());
        if (Objects.equals(mainOrderDto.getCanSplitFlag(), YesOrNoEnum.NO.getType()) && StringUtils.isNotBlank((CharSequence)mainOrderDto.getStoragePlace())) {
            shPreemptParam.setIsShoutVirtualWarehouse(Boolean.TRUE);
            shPreemptParam.setShoutVirtualWarehouseCode(mainOrderDto.getStoragePlace());
        }
        ArrayList details = Lists.newArrayList();
        List<PlatformOrderItemRespDto> platformOrderItemRespDtos = this.platformOrderItemService.queryListByOrderId(childorderRespDto.getId());
        for (PlatformOrderItemRespDto itemDto : platformOrderItemRespDtos) {
            OperationDetailDto itemDetail = new OperationDetailDto();
            itemDetail.setSkuCode(itemDto.getSkuCode());
            itemDetail.setNum(itemDto.getItemNum());
            itemDetail.setWarehouseCode(mainOrderDto.getChannelWarehouseCode());
            details.add(itemDetail);
        }
        shPreemptParam.setDetails((List)details);
        preemptParamList.add(shPreemptParam);
        parentOrderPreemt.setPreemptParamList((List)preemptParamList);
        logger.info("\u91ca\u653e\u4e3b\u5355\u9884\u5360\uff0c\u91cd\u65b0\u6309\u5b50\u5355\u9884\u5360\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)parentOrderPreemt));
        RestResponseHelper.extractData((RestResponse)this.shareChannelInventoryExposedApi.updatePreempt(parentOrderPreemt));
        String redisKey = childorderRespDto.getPlatformOrderNo();
        this.cacheService.delCache("platform-sale-order", redisKey);
    }

    private boolean checkObsoleteOrder(Long platformOrderId) {
        SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
        saleOrderQueryReqDto.setPlatformOrderId(platformOrderId);
        List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
        if (CollectionUtils.isEmpty((Collection)saleOrderRespDtos)) {
            return true;
        }
        SaleOrderRespDto saleOrderRespDto = saleOrderRespDtos.stream().filter(dto -> StringUtils.isEmpty((CharSequence)dto.getMainOrderNo())).findFirst().get();
        if (Objects.equals(saleOrderRespDto.getOrderStatus(), SaleOrderStatusEnum.OBSOLETE.getCode())) {
            return false;
        }
        throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u9500\u552e\u5355:" + saleOrderRespDto.getSaleOrderNo() + "\u672a\u4f5c\u5e9f\uff0c\u4e0d\u53ef\u64cd\u4f5c\u3002"});
    }

    private void releaseInventory(String saleOrderNo, String orderType, Integer canSplitFlag, String platformOrderNo) {
        ReleasePreemptDto csInventoryOperateReqDto = new ReleasePreemptDto();
        csInventoryOperateReqDto.setSourceNo(saleOrderNo);
        csInventoryOperateReqDto.setSourceType(orderType);
        csInventoryOperateReqDto.setExternalOrderNo(platformOrderNo);
        logger.info("\u4f5c\u5e9f\u6e20\u9053\u5355\u91ca\u653e\u5e93\u5b58\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)csInventoryOperateReqDto));
        RestResponseHelper.extractData((RestResponse)this.shareChannelInventoryExposedApi.releasePreempt(csInventoryOperateReqDto));
        String redisKey = platformOrderNo;
        this.cacheService.delCache("platform-sale-order", redisKey);
    }

    private void initPlatformOrderStatus(Long orderId, Integer updateWhereStatus) {
        PlatformOrderEo platformOrderEo = new PlatformOrderEo();
        platformOrderEo.setTransferOrderStatus(Integer.valueOf(PlatformTransformOrderStatus.STATUS_INIT_1.getCode()));
        PlatformOrderEo queryEo = new PlatformOrderEo();
        queryEo.setId(orderId);
        UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
        updateWrapper.eq((Object)"transfer_order_status", (Object)updateWhereStatus);
        this.platformOrderService.optimisticModifyPlatformOrder(platformOrderEo, (UpdateWrapper<PlatformOrderEo>)updateWrapper, 1, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> savePcpOrder(PcpOrderReqDto addReqDto) {
        return this.pcpOrderSourceService.source(PlatformOrderSource.SOURCE_0.getCode()).savePcpOrder(addReqDto);
    }

    private void abolishPlatformOrderStatus(Long orderId, String abolishReason) {
        PlatformOrderEo platformOrderEo = new PlatformOrderEo();
        platformOrderEo.setTransferOrderStatus(Integer.valueOf(PlatformTransformOrderStatus.STATUS_2.getCode()));
        String requestUserCode = (String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"");
        platformOrderEo.setObsoletePerson(requestUserCode);
        platformOrderEo.setObsoleteReason(abolishReason);
        platformOrderEo.setObsoleteTime(new Date());
        PlatformOrderEo queryEo = new PlatformOrderEo();
        queryEo.setId(orderId);
        UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
        updateWrapper.in((Object)"transfer_order_status", Arrays.asList(PlatformTransformOrderStatus.STATUS_INIT_1.getCode(), PlatformTransformOrderStatus.STATUS_1.getCode(), PlatformTransformOrderStatus.STATUS_3.getCode(), PlatformTransformOrderStatus.STATUS_0.getCode(), PlatformTransformOrderStatus.STATUS_6.getCode()));
        this.platformOrderService.optimisticModifyPlatformOrder(platformOrderEo, (UpdateWrapper<PlatformOrderEo>)updateWrapper, 1, true);
    }

    private void checkSaveBaseParam(PcpOrderReqDto pcpOrderReqDto) {
        PlatformAssert.notNull((Object)pcpOrderReqDto.getPlatformOrderPcpExtendReqDto(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u6269\u5c55\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a"});
        if (SaleOrderTypeEnum.REPLENISHMENT_ORDER.getType().equals(pcpOrderReqDto.getOrderType()) && !this.isYyjParentOrder(pcpOrderReqDto)) {
            PlatformAssert.notNull((Object)pcpOrderReqDto.getEasOrgId(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"easOrgId\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        PlatformAssert.notBlank((String)pcpOrderReqDto.getOrderType(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformAssert.notNull((Object)SaleOrderTypeEnum.enumOf((String)pcpOrderReqDto.getOrderType()), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u8ba2\u5355\u7c7b\u578b\u9519\u8bef"});
        PlatformAssert.notBlank((String)pcpOrderReqDto.getPlatformOrderNo(), (PlatformExceptionCode)PlatformExceptionCode.CHECK_PARAM_PNO_NULL, (String[])new String[0]);
        PlatformAssert.notBlank((String)pcpOrderReqDto.getOrderChannelCode(), (PlatformExceptionCode)PlatformExceptionCode.CHECK_PARAM_ORDER_CHANNEL_CODE_NULL, (String[])new String[0]);
        if (!Objects.equals(pcpOrderReqDto.getOrderType(), SaleOrderTypeEnum.SHOPPE_ORDER.getType())) {
            PlatformAssert.notBlank((String)pcpOrderReqDto.getChannelWarehouseCode(), (PlatformExceptionCode)PlatformExceptionCode.CHECK_PARAM_CHANNEL_WAREHOUSE_CODE_NULL, (String[])new String[0]);
        }
        PlatformAssert.notBlank((String)pcpOrderReqDto.getThirdPartyId(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u5ba2\u6237\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformAssert.notEmpty((Collection)pcpOrderReqDto.getItemReqDtoList(), (PlatformExceptionCode)PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_NULL, (String[])new String[0]);
        PlatformAssert.notNull((Object)pcpOrderReqDto.getOrderSource(), (PlatformExceptionCode)PlatformExceptionCode.CHECK_ORDER_INFO_ORDER_SOURCE_NULL, (String[])new String[0]);
        Optional.ofNullable(SaleOrderSourceEnum.enumOf((Integer)pcpOrderReqDto.getOrderSource())).orElseThrow(() -> ((PlatformExceptionCode)PlatformExceptionCode.CHECK_ORDER_INFO_ORDER_SOURCE_EXCHANGE_NULL).buildBizException());
        pcpOrderReqDto.getItemReqDtoList().forEach(dto -> {
            if (StringUtils.isBlank((CharSequence)dto.getSkuCode())) {
                throw PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_CODE_NULL.buildBizException();
            }
            if (dto.getItemNum() == null || dto.getItemNum().compareTo(BigDecimal.ZERO) <= 0) {
                throw PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_NUM_NULL.buildBizException(new Object[]{dto.getItemCode()});
            }
            if (dto.getPrice() == null || dto.getPrice().compareTo(BigDecimal.ZERO) < 0) {
                throw PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_PRICE_NULL.buildBizException(new Object[]{dto.getItemCode()});
            }
            if (dto.getGift() == null || dto.getGift() != 1 && dto.getGift() != 0) {
                throw PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_GIFT_TYPE_WRONG.buildBizException(new Object[]{dto.getItemCode()});
            }
        });
        Map<String, List<PlatformOrderItemReqDto>> itemMap = pcpOrderReqDto.getItemReqDtoList().stream().collect(Collectors.groupingBy(PlatformOrderItemReqDto::getSkuCode));
        if (!this.isYyjParentOrder(pcpOrderReqDto)) {
            if (StringUtils.isBlank((CharSequence)pcpOrderReqDto.getPlatformOrderAddrReqDto().getReceiveAddress())) {
                throw PlatformExceptionCode.CHECK_ORDER_INFO_ADDRESS_FAIL.buildBizException(new Object[]{"\u8be6\u7ec6\u5730\u5740"});
            }
            if (StringUtils.isBlank((CharSequence)pcpOrderReqDto.getPlatformOrderAddrReqDto().getReceiveName())) {
                throw PlatformExceptionCode.CHECK_ORDER_INFO_ADDRESS_FAIL.buildBizException(new Object[]{"\u6536\u8d27\u4eba"});
            }
            if (StringUtils.isBlank((CharSequence)pcpOrderReqDto.getPlatformOrderAddrReqDto().getReceivePhone())) {
                throw PlatformExceptionCode.CHECK_ORDER_INFO_ADDRESS_FAIL.buildBizException(new Object[]{"\u6536\u8d27\u7535\u8bdd"});
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveTransformInfo(PcpOrderReqDto pcpOrderReqDto, PcpOrderChannelRespDto pcpOrderChannelRespDto, Map<String, PcpItemRespDto> csItemRespDtoMap, CustomerRespDto pcpCustomerRespDto, OrgAdvDetailRespDto organizationDto, Map<String, PcpRegionRespDto> pcpRegionRespDtoMap) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> addPcpYyjOrderProcess(final List<PcpOrderReqDto> pcpOrderReqDtos) {
        Object pcpOrderReqDto;
        String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
        PlatformOrderRespDto parentPlatformOrderRespDto = null;
        if (!CollectionUtils.isEmpty(pcpOrderReqDtos) && !this.isYyjParentOrder((PcpOrderReqDto)(pcpOrderReqDto = pcpOrderReqDtos.get(0)))) {
            String platformParentOrderNo = pcpOrderReqDto.getPlatformParentOrderNo();
            PlatformOrderQueryReqDto platformOrderQueryReqDto = new PlatformOrderQueryReqDto();
            platformOrderQueryReqDto.setPlatformOrderNo(platformParentOrderNo);
            platformOrderQueryReqDto.setNotInTransferOrderStatusList((List)Lists.newArrayList((Object[])new Integer[]{PlatformTransformOrderStatus.STATUS_2.code}));
            List<PlatformOrderRespDto> platformOrderRespDtos = this.platformOrderService.queryListByParam(platformOrderQueryReqDto);
            parentPlatformOrderRespDto = platformOrderRespDtos.get(0);
        }
        logger.info("[\u8425\u517b\u5bb6\u65b0\u589e\u9500\u552e\u8ba2\u5355]");
        for (PcpOrderReqDto pcpOrderReqDto2 : pcpOrderReqDtos) {
            this.executorService.execute(() -> {
                MDC.put((String)"yes.req.requestId", (String)reqId);
                logger.info("[\u5f02\u6b65\u8425\u517b\u5bb6\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)pcpOrderReqDto2));
                ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
                RestResponseHelper.extractData(this.pcpOrderSourceService.source(PlatformOrderSource.SOURCE_0.getCode()).savePcpOrder(pcpOrderReqDto2));
                if (!this.isYyjParentOrder(pcpOrderReqDto2)) {
                    Long oldNum = (Long)this.cacheService.getCache(YYJ_CHILD_ORDER_NUM_GROUP, pcpOrderReqDto2.getPlatformParentOrderNo(), Long.class);
                    logger.info("[\u5f02\u6b65\u8425\u517b\u5bb6\u65b0\u589e\u9500\u552e\u8ba2\u5355],\u5b50\u5355\u8f6c\u5355\u6210\u529f\u4fee\u6539\u7f13\u5b58\u5b50\u5355\u6570\u91cf\uff1a{},{}", (Object)pcpOrderReqDto2.getPlatformParentOrderNo(), (Object)oldNum);
                    Long afterNum = this.cacheService.decrBy(YYJ_CHILD_ORDER_NUM_GROUP, pcpOrderReqDto2.getPlatformParentOrderNo(), 1L);
                    logger.info("[\u5f02\u6b65\u8425\u517b\u5bb6\u65b0\u589e\u9500\u552e\u8ba2\u5355],\u5b50\u5355\u8f6c\u5355\u6210\u529f\u4fee\u6539\u7f13\u5b58\u5b50\u5355\u6570\u91cf,\u5e73\u53f0\u5355\u53f7:{},\u4fee\u6539\u540e\u6570\u91cf\uff1a{}", (Object)pcpOrderReqDto2.getPlatformParentOrderNo(), (Object)afterNum);
                    if (afterNum <= 0L) {
                        logger.info("[\u5f02\u6b65\u8425\u517b\u5bb6\u65b0\u589e\u9500\u552e\u8ba2\u5355],\u7f13\u5b58\u5b50\u5355\u6570\u91cf\u5c0f\u4e8e0\uff0c\u5220\u9664\u7f13\u5b58\uff0c\u5e76\u4fee\u6539\u603b\u5355\u72b6\u6001\uff1a{}", (Object)pcpOrderReqDto2.getPlatformParentOrderNo());
                        this.cacheService.delCache(YYJ_CHILD_ORDER_NUM_GROUP, pcpOrderReqDto2.getPlatformParentOrderNo());
                        PlatformOrderEo platformOrderEo = new PlatformOrderEo();
                        platformOrderEo.setTransferOrderStatus(Integer.valueOf(PlatformTransformOrderStatus.STATUS_0.getCode()));
                        this.platformOrderDas.setUpdateSystemFields((BaseEo)platformOrderEo);
                        UpdateWrapper updateWrapper = new UpdateWrapper();
                        updateWrapper.eq((Object)"platform_order_no", (Object)pcpOrderReqDto2.getPlatformParentOrderNo());
                        this.platformOrderDas.getMapper().update((Object)platformOrderEo, (Wrapper)updateWrapper);
                    }
                }
            });
        }
        final PlatformOrderRespDto finalParentPlatformOrderRespDto = parentPlatformOrderRespDto;
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                CspPcpOrderServiceImpl.this.displacePreemptInventoryBatch(pcpOrderReqDtos, finalParentPlatformOrderRespDto);
            }
        });
        return new RestResponse();
    }

    private boolean isYyjParentOrder(PcpOrderReqDto pcpOrderReqDto) {
        return StringUtils.isBlank((CharSequence)pcpOrderReqDto.getPlatformParentOrderNo());
    }

    private void mergePlatformOrderStatus(Long orderId, String reRransformOrderNo) {
        PlatformOrderEo platformOrderEo = new PlatformOrderEo();
        platformOrderEo.setTransferOrderStatus(Integer.valueOf(PlatformTransformOrderStatus.STATUS_3.getCode()));
        platformOrderEo.setReTransformOrderNo(reRransformOrderNo);
        PlatformOrderEo queryEo = new PlatformOrderEo();
        queryEo.setId(orderId);
        UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
        updateWrapper.in((Object)"transfer_order_status", Arrays.asList(PlatformTransformOrderStatus.STATUS_INIT_1.getCode(), PlatformTransformOrderStatus.STATUS_1.getCode(), PlatformTransformOrderStatus.STATUS_0.getCode(), PlatformTransformOrderStatus.STATUS_3.getCode()));
        this.platformOrderService.optimisticModifyPlatformOrder(platformOrderEo, (UpdateWrapper<PlatformOrderEo>)updateWrapper, 1, true);
    }

    private void errorPlatformOrderStatus(Long orderId, Integer updateWhereStatus, String errorMsg) {
        PlatformOrderEo platformOrderEo = new PlatformOrderEo();
        platformOrderEo.setTransferOrderStatus(Integer.valueOf(PlatformTransformOrderStatus.STATUS_1.getCode()));
        platformOrderEo.setExceptionReason(errorMsg);
        PlatformOrderEo queryEo = new PlatformOrderEo();
        queryEo.setId(orderId);
        UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
        updateWrapper.eq((Object)"transfer_order_status", (Object)updateWhereStatus);
        this.platformOrderService.optimisticModifyPlatformOrder(platformOrderEo, (UpdateWrapper<PlatformOrderEo>)updateWrapper, 1, true);
    }

    private void displacePreemptInventoryBatch(List<PcpOrderReqDto> pcpOrderReqDtoList, PlatformOrderRespDto parentPlatformOrderRespDto) {
        if (Objects.isNull(parentPlatformOrderRespDto)) {
            logger.info("\u8425\u517b\u5bb6\u7f6e\u6362\u9884\u5360\u5e93\u5b58\u5b50\u5355\u5bf9\u5e94\u7684\u4e3b\u5355\u672a\u67e5\u8be2\u5230{}", (Object)pcpOrderReqDtoList.get(0).getPlatformParentOrderNo());
            return;
        }
        DisplacePreemptDto shDisplacePreemptParam = new DisplacePreemptDto();
        shDisplacePreemptParam.setSourceType(parentPlatformOrderRespDto.getOrderType());
        shDisplacePreemptParam.setDisplaceSourceNo(parentPlatformOrderRespDto.getSaleOrderNo());
        DisplacePreemptDto parentOrderParam = new DisplacePreemptDto();
        parentOrderParam.setSourceType(parentPlatformOrderRespDto.getOrderType());
        parentOrderParam.setDisplaceSourceNo(parentPlatformOrderRespDto.getSaleOrderNo());
        ArrayList shOperationParams = Lists.newArrayList();
        for (PcpOrderReqDto pcpOrderReqDto : pcpOrderReqDtoList) {
            PreemptDto shOperationParam = new PreemptDto();
            shOperationParam.setSourceNo(pcpOrderReqDto.getSaleOrderNo());
            shOperationParam.setExternalOrderNo(pcpOrderReqDto.getPlatformOrderNo());
            shOperationParam.setSourceType(pcpOrderReqDto.getOrderType());
            shOperationParam.setValidNegative(Boolean.FALSE);
            shOperationParam.setDisplacePreemptParam(parentOrderParam);
            ArrayList details = Lists.newArrayList();
            for (PlatformOrderItemReqDto itemReqDto : pcpOrderReqDto.getItemReqDtoList()) {
                OperationDetailDto itemDetail = new OperationDetailDto();
                itemDetail.setSkuCode(itemReqDto.getSkuCode());
                itemDetail.setNum(itemReqDto.getItemNum());
                itemDetail.setWarehouseCode(pcpOrderReqDto.getChannelWarehouseCode());
                details.add(itemDetail);
            }
            shOperationParam.setDetails((List)details);
            shOperationParams.add(shOperationParam);
        }
        shDisplacePreemptParam.setShPreemptParams((List)shOperationParams);
        logger.info("\u8425\u517b\u5bb6\u7f6e\u6362\u9884\u5360\u5e93\u5b58\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)shDisplacePreemptParam));
        try {
            Date startTime = new Date();
            String DISPLACE_PREEMPT_ASYNC = "DISPLACE_PREEMPT_ASYNC";
            String key = DISPLACE_PREEMPT_ASYNC + shDisplacePreemptParam.getDisplaceSourceNo();
            Map<String, String> displacePreemptParamMap = shDisplacePreemptParam.getShPreemptParams().stream().collect(Collectors.toMap(a -> a.getSourceNo(), a -> JSON.toJSONString((Object)a)));
            this.cacheService.hmset(key, shDisplacePreemptParam.getDisplaceSourceNo(), displacePreemptParamMap);
            this.cacheService.setCache(DISPLACE_PREEMPT_ASYNC, shDisplacePreemptParam.getDisplaceSourceNo(), (Object)JSON.toJSONString(displacePreemptParamMap.keySet()));
            String timeDiffWithMilliseconds = DateUtil.getTimeDiffWithMilliseconds((Date)startTime, (Date)new Date());
            logger.info("\u8425\u517b\u5bb6\u7f6e\u6362\u5e93\u5b58\u65f6\u95f4:{}", (Object)timeDiffWithMilliseconds);
            RestResponseHelper.extractData((RestResponse)this.shareChannelInventoryExposedApi.displacePreempt(shDisplacePreemptParam));
        }
        catch (Exception e) {
            logger.info("\u8425\u517b\u5bb6\u7f6e\u6362\u9884\u5360\u5e93\u5b58\u5f02\u5e38:{}", (Throwable)e);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logisticsAudit(PlatformOrderAuditOptReqDto auditOptReqDto) {
        String[] res;
        UserDto userDto;
        AssertUtil.assertNotNull(auditOptReqDto.getPlatformOrderId(), "\u53c2\u6570PlatformOrderId\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtil.assertNotBlank(auditOptReqDto.getAuditOperation(), "\u53c2\u6570AuditOperation\u4e0d\u53ef\u4e3a\u7a7a");
        PlatformOrderEo selectEo = new PlatformOrderEo();
        selectEo.setId(auditOptReqDto.getPlatformOrderId());
        PlatformOrderEo platformOrderEo = (PlatformOrderEo)this.platformOrderDas.selectOne((BaseEo)selectEo);
        AssertUtil.assertNotNull(platformOrderEo, "\u6e20\u9053\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        Integer transferOrderStatus = platformOrderEo.getTransferOrderStatus();
        AssertUtil.isTrue(Objects.equals(transferOrderStatus, PlatformTransformOrderStatus.STATUS_4.code), "\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u7269\u6d41\u5ba1\u6838");
        PlatformOrderAuditStatusEnum auditStatusEnum = PlatformOrderAuditStatusEnum.forCode((String)auditOptReqDto.getAuditOperation());
        PlatformOrderSpExtRespDto platformOrderSpExtRespDto = this.platformOrderSpExtService.queryByPlatformOrderId(auditOptReqDto.getPlatformOrderId());
        String userCode = ServiceContext.getContext().getRequestUserCode();
        Long userId = ServiceContext.getContext().getRequestUserId();
        if (Objects.nonNull(userId) && Objects.nonNull(userDto = (UserDto)RestResponseHelper.extractData((RestResponse)this.userExtQueryApi.queryUserByUserNames(userId, res = new String[0]))) && StringUtils.isNotEmpty((CharSequence)userDto.getNickName())) {
            userCode = userDto.getNickName();
        }
        switch (auditStatusEnum) {
            case AUDIT_PASS: {
                this.updatePlatformStatus(platformOrderEo.getId(), PlatformTransformOrderStatus.STATUS_5, platformOrderEo.getTransferOrderStatus());
                this.updateSpExtAuditFile(platformOrderSpExtRespDto.getId(), auditOptReqDto.getAuditFile(), null);
                break;
            }
            case WAIT_TO_UP: {
                AssertUtil.isFalse(Objects.equals(platformOrderEo.getOrderType(), SaleOrderTypeEnum.CLAIM_REISSUE.getType()) || Objects.equals(platformOrderEo.getOrderType(), SaleOrderTypeEnum.CLAIM_POSTING.getType()), "\u4ed3\u5e93\u7d22\u8d54\u5355\u65e0\u6cd5\u53cd\u5ba1\u81f3\u4e0a\u6e38");
                this.updatePlatformStatus(platformOrderEo.getId(), PlatformTransformOrderStatus.STATUS_INIT_1, platformOrderEo.getTransferOrderStatus());
                this.updateSpExtAuditFile(platformOrderSpExtRespDto.getId(), auditOptReqDto.getAuditFile(), null);
                this.sendCspSpMq(platformOrderEo.getPlatformOrderNo(), CspClaimOrderStatusEnum.WAIT_BUSINESS_REVIEW, null, userCode, auditOptReqDto.getAuditRemark());
                break;
            }
            case AUDIT_NOT_PASS: {
                this.updatePlatformStatus(platformOrderEo.getId(), PlatformTransformOrderStatus.STATUS_2, platformOrderEo.getTransferOrderStatus());
                this.updateSpExtAuditFile(platformOrderSpExtRespDto.getId(), auditOptReqDto.getAuditFile(), null);
                if (StringUtils.isNotEmpty((CharSequence)platformOrderEo.getSaleOrderNo()) && !Objects.equals(platformOrderEo.getOrderType(), SaleOrderTypeEnum.CLAIM_POSTING.getType())) {
                    this.releaseInventory(platformOrderEo.getSaleOrderNo(), platformOrderEo.getOrderType(), platformOrderEo.getCanSplitFlag(), platformOrderEo.getPlatformOrderNo());
                }
                if (Objects.equals(platformOrderEo.getOrderType(), SaleOrderTypeEnum.CLAIM_REISSUE.getType()) || Objects.equals(platformOrderEo.getOrderType(), SaleOrderTypeEnum.CLAIM_POSTING.getType())) break;
                this.sendCspSpMq(platformOrderEo.getPlatformOrderNo(), CspClaimOrderStatusEnum.DENIED, null, userCode, auditOptReqDto.getAuditRemark());
                break;
            }
            default: {
                throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException();
            }
        }
        this.saveAuditLog(auditOptReqDto, platformOrderEo, userCode);
    }

    private void saveAuditLog(PlatformOrderAuditOptReqDto auditOptReqDto, PlatformOrderEo platformOrderEo, String userCode) {
        PlatformOrderSpAuditReqDto spAuditReqDto = new PlatformOrderSpAuditReqDto();
        spAuditReqDto.setOrganizationId(platformOrderEo.getOrganizationId());
        spAuditReqDto.setOrganizationCode(platformOrderEo.getOrganizationCode());
        spAuditReqDto.setOrganizationName(platformOrderEo.getOrganizationName());
        spAuditReqDto.setPlatformOrderId(platformOrderEo.getId());
        spAuditReqDto.setPlatformOrderNo(platformOrderEo.getPlatformOrderNo());
        spAuditReqDto.setTransferOrderStatus(platformOrderEo.getTransferOrderStatus());
        spAuditReqDto.setAuditFile(auditOptReqDto.getAuditFile());
        spAuditReqDto.setAuditOperation(auditOptReqDto.getAuditOperation());
        spAuditReqDto.setAuditRemark(auditOptReqDto.getAuditRemark());
        spAuditReqDto.setAuditTime(new Date());
        spAuditReqDto.setAuditPerson(userCode);
        this.platformOrderSpAuditService.addPlatformOrderSpAudit(spAuditReqDto);
    }

    private void updatePlatformStatus(Long id, PlatformTransformOrderStatus status, Integer oldStatus) {
        PlatformOrderEo platformOrderEo = new PlatformOrderEo();
        platformOrderEo.setTransferOrderStatus(Integer.valueOf(status.getCode()));
        PlatformOrderEo queryEo = new PlatformOrderEo();
        queryEo.setId(id);
        UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
        updateWrapper.eq((Object)"transfer_order_status", (Object)oldStatus);
        this.platformOrderService.optimisticModifyPlatformOrder(platformOrderEo, (UpdateWrapper<PlatformOrderEo>)updateWrapper, 1, true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void warehouseAudit(PlatformOrderAuditOptReqDto auditOptReqDto) {
        String[] res;
        UserDto userDto;
        AssertUtil.assertNotNull(auditOptReqDto.getPlatformOrderId(), "\u53c2\u6570PlatformOrderId\u4e0d\u53ef\u4e3a\u7a7a");
        AssertUtil.assertNotBlank(auditOptReqDto.getAuditOperation(), "\u53c2\u6570AuditOperation\u4e0d\u53ef\u4e3a\u7a7a");
        PlatformOrderEo selectEo = new PlatformOrderEo();
        selectEo.setId(auditOptReqDto.getPlatformOrderId());
        PlatformOrderEo platformOrderEo = (PlatformOrderEo)this.platformOrderDas.selectOne((BaseEo)selectEo);
        AssertUtil.assertNotNull(platformOrderEo, "\u6e20\u9053\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        Integer transferOrderStatus = platformOrderEo.getTransferOrderStatus();
        AssertUtil.isTrue(Objects.equals(transferOrderStatus, PlatformTransformOrderStatus.STATUS_5.code), "\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u4ed3\u5e93\u5ba1\u6838");
        PlatformOrderAuditStatusEnum auditStatusEnum = PlatformOrderAuditStatusEnum.forCode((String)auditOptReqDto.getAuditOperation());
        PlatformOrderSpExtRespDto platformOrderSpExtRespDto = this.platformOrderSpExtService.queryByPlatformOrderId(platformOrderEo.getId());
        String userCode = ServiceContext.getContext().getRequestUserCode();
        Long userId = ServiceContext.getContext().getRequestUserId();
        if (Objects.nonNull(userId) && Objects.nonNull(userDto = (UserDto)RestResponseHelper.extractData((RestResponse)this.userExtQueryApi.queryUserByUserNames(userId, res = new String[0]))) && StringUtils.isNotEmpty((CharSequence)userDto.getNickName())) {
            userCode = userDto.getNickName();
        }
        switch (auditStatusEnum) {
            case AUDIT_PASS: {
                this.updatePlatformStatus(platformOrderEo.getId(), PlatformTransformOrderStatus.STATUS_6, platformOrderEo.getTransferOrderStatus());
                this.updateSpExtAuditFile(platformOrderSpExtRespDto.getId(), null, auditOptReqDto.getAuditFile());
                if (!Objects.equals(platformOrderEo.getOrderType(), SaleOrderTypeEnum.CLAIM_REISSUE.getType()) && !Objects.equals(platformOrderEo.getOrderType(), SaleOrderTypeEnum.CLAIM_POSTING.getType())) {
                    this.sendCspSpMq(platformOrderEo.getPlatformOrderNo(), CspClaimOrderStatusEnum.WAREHOUSE_APPROVE, platformOrderSpExtRespDto.getTargetClaimLogisticsCode(), userCode, auditOptReqDto.getAuditRemark());
                }
                if (!Objects.equals(platformOrderEo.getOrderType(), SaleOrderTypeEnum.COMPENSATION_ORDER.getType()) && !Objects.equals(platformOrderEo.getOrderType(), SaleOrderTypeEnum.CLAIM_REISSUE.getType()) && !Objects.equals(platformOrderEo.getOrderType(), SaleOrderTypeEnum.CLAIM_POSTING.getType())) break;
                logger.info("\u4ed3\u5e93\u5ba1\u6838\u901a\u8fc7\u8fdb\u884c\u8f6c\u5355");
                this.transformPcpOrder(platformOrderEo.getId());
                break;
            }
            case WAIT_TO_UP: {
                AssertUtil.isFalse(Objects.equals(platformOrderEo.getOrderType(), SaleOrderTypeEnum.CLAIM_REISSUE.getType()) || Objects.equals(platformOrderEo.getOrderType(), SaleOrderTypeEnum.CLAIM_POSTING.getType()), "\u4ed3\u5e93\u7d22\u8d54\u5355\u65e0\u6cd5\u53cd\u5ba1\u81f3\u4e0a\u6e38");
                this.updatePlatformStatus(platformOrderEo.getId(), PlatformTransformOrderStatus.STATUS_INIT_1, platformOrderEo.getTransferOrderStatus());
                this.updateSpExtAuditFile(platformOrderSpExtRespDto.getId(), null, auditOptReqDto.getAuditFile());
                this.sendCspSpMq(platformOrderEo.getPlatformOrderNo(), CspClaimOrderStatusEnum.WAIT_BUSINESS_REVIEW, null, userCode, auditOptReqDto.getAuditRemark());
                break;
            }
            case WAIT_TO_LOGISTICS: {
                this.updatePlatformStatus(platformOrderEo.getId(), PlatformTransformOrderStatus.STATUS_4, platformOrderEo.getTransferOrderStatus());
                this.updateSpExtAuditFile(platformOrderSpExtRespDto.getId(), null, auditOptReqDto.getAuditFile());
                break;
            }
            case AUDIT_NOT_PASS: {
                this.updatePlatformStatus(platformOrderEo.getId(), PlatformTransformOrderStatus.STATUS_2, platformOrderEo.getTransferOrderStatus());
                this.updateSpExtAuditFile(platformOrderSpExtRespDto.getId(), null, auditOptReqDto.getAuditFile());
                if (StringUtils.isNotEmpty((CharSequence)platformOrderEo.getSaleOrderNo()) && !Objects.equals(platformOrderEo.getOrderType(), SaleOrderTypeEnum.CLAIM_POSTING.getType())) {
                    this.releaseInventory(platformOrderEo.getSaleOrderNo(), platformOrderEo.getOrderType(), platformOrderEo.getCanSplitFlag(), platformOrderEo.getPlatformOrderNo());
                }
                if (Objects.equals(platformOrderEo.getOrderType(), SaleOrderTypeEnum.CLAIM_REISSUE.getType()) || Objects.equals(platformOrderEo.getOrderType(), SaleOrderTypeEnum.CLAIM_POSTING.getType())) break;
                this.sendCspSpMq(platformOrderEo.getPlatformOrderNo(), CspClaimOrderStatusEnum.DENIED, null, userCode, auditOptReqDto.getAuditRemark());
                break;
            }
            default: {
                throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException();
            }
        }
        this.saveAuditLog(auditOptReqDto, platformOrderEo, userCode);
    }

    private void updateSpExtAuditFile(Long id, String logisticsFile, String warehouseAuditFile) {
        if (StringUtils.isEmpty((CharSequence)logisticsFile) && StringUtils.isEmpty((CharSequence)warehouseAuditFile)) {
            return;
        }
        PlatformOrderSpExtReqDto platformOrderSpExtReqDto = new PlatformOrderSpExtReqDto();
        if (StringUtils.isNotEmpty((CharSequence)logisticsFile)) {
            platformOrderSpExtReqDto.setLogisticsFile(logisticsFile);
        }
        if (StringUtils.isNotEmpty((CharSequence)warehouseAuditFile)) {
            platformOrderSpExtReqDto.setWarehouseAuditFile(warehouseAuditFile);
        }
        platformOrderSpExtReqDto.setId(id);
        this.platformOrderSpExtService.modifyPlatformOrderSpExt(platformOrderSpExtReqDto);
    }

    private MessageResponse sendCspSpMq(String platformOrderNo, CspClaimOrderStatusEnum cspClaimOrderStatusEnum, String logisticsProvider, String approval, String approvalRemark) {
        CSPUpdateCspClaimOrderReqDto cspUpdateCspClaimOrderReqDto = new CSPUpdateCspClaimOrderReqDto();
        cspUpdateCspClaimOrderReqDto.setOaSheetNo(platformOrderNo);
        cspUpdateCspClaimOrderReqDto.setStatus(cspClaimOrderStatusEnum.getType());
        if (StringUtils.isNotEmpty((CharSequence)logisticsProvider)) {
            cspUpdateCspClaimOrderReqDto.setLogisticsProvider(logisticsProvider);
        }
        if (StringUtils.isNotEmpty((CharSequence)approval)) {
            cspUpdateCspClaimOrderReqDto.setApprover(approval);
        }
        if (StringUtils.isNotEmpty((CharSequence)approvalRemark)) {
            cspUpdateCspClaimOrderReqDto.setApprovalRemark(approvalRemark);
        }
        MessageVo vo = new MessageVo();
        vo.setData((Object)cspUpdateCspClaimOrderReqDto);
        logger.info("\u7269\u6d41\u5546\u7d22\u8d54\u8ba2\u5355\u53d1\u9001\u66f4\u65b0csp\u8ba2\u5355\u72b6\u6001MQ\uff1a{}", (Object)JSON.toJSONString((Object)vo));
        this.commonsMqService.sendSingleMessage("OP_EXTERNAL_TOPIC", "UPDATE_CSP_CLAIM_ORDER_STATUS", (Object)JSON.toJSONString((Object)vo));
        return MessageResponse.SUCCESS;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void yyjRefTransformOpt(String parentPlatformNo, Boolean refTransform) {
        AssertUtil.assertNotBlank(parentPlatformNo, PlatformExceptionCode.CHECK_PARAM_PNO_NULL.getMsg());
        PlatformOrderQueryReqDto platformOrderQueryReqDto = new PlatformOrderQueryReqDto();
        platformOrderQueryReqDto.setPlatformParentOrderNo(parentPlatformNo);
        platformOrderQueryReqDto.setNotInTransferOrderStatusList((List)Lists.newArrayList((Object[])new Integer[]{PlatformTransformOrderStatus.STATUS_2.code}));
        List<PlatformOrderRespDto> childOrderDtoList = this.platformOrderService.queryListByParam(platformOrderQueryReqDto);
        if (CollectionUtils.isEmpty(childOrderDtoList)) {
            throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u8425\u517b\u5bb6\u5b50\u5355\u4e0d\u5b58\u5728"});
        }
        if (refTransform.booleanValue()) {
            logger.info("\u8425\u517b\u5bb6\u76f4\u63a5\u8f6c\u5355");
            final String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
            for (final PlatformOrderRespDto platformOrderRespDto : childOrderDtoList) {
                if (!Objects.equals(platformOrderRespDto.getTransferOrderStatus(), PlatformTransformOrderStatus.STATUS_INIT_1.getCode()) && !Objects.equals(platformOrderRespDto.getTransferOrderStatus(), PlatformTransformOrderStatus.STATUS_1.getCode())) continue;
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        MDC.put((String)"yes.req.requestId", (String)reqId);
                        ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
                        try {
                            CspPcpOrderServiceImpl.this.pcpOrderSourceService.source(PlatformOrderSource.SOURCE_0.getCode()).transformPcpOrder(platformOrderRespDto.getId());
                        }
                        catch (Exception e) {
                            logger.error("\u8425\u517b\u5bb6\u5b50\u5355\u8f6c\u5355\u5931\u8d25", (Throwable)e);
                        }
                    }
                });
            }
        } else {
            logger.info("\u8425\u517b\u5bb6\u7f6e\u6362\u5e93\u5b58");
            platformOrderQueryReqDto = new PlatformOrderQueryReqDto();
            platformOrderQueryReqDto.setPlatformOrderNo(parentPlatformNo);
            List<PlatformOrderRespDto> platformOrderRespDtos = this.platformOrderService.queryListByParam(platformOrderQueryReqDto);
            if (CollectionUtils.isEmpty(platformOrderRespDtos)) {
                throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u8425\u517b\u5bb6\u7236\u5355\u4e0d\u5b58\u5728"});
            }
            List<Long> idList = childOrderDtoList.stream().map(PlatformOrderRespDto::getId).collect(Collectors.toList());
            List<PlatformOrderItemRespDto> platformOrderItemRespDtos = this.platformOrderItemService.queryListByOrderIds(idList);
            if (CollectionUtils.isEmpty(platformOrderItemRespDtos)) {
                throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u8425\u517b\u5bb6\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728"});
            }
            Map<Long, List<PlatformOrderItemRespDto>> orderItemMap = platformOrderItemRespDtos.stream().collect(Collectors.groupingBy(PlatformOrderItemRespDto::getOrderId));
            final PlatformOrderRespDto finalParentPlatformOrderRespDto = platformOrderRespDtos.get(0);
            final ArrayList pcpOrderReqDtoList = Lists.newArrayList();
            for (PlatformOrderRespDto childOrder : childOrderDtoList) {
                PcpOrderReqDto pcpOrderReqDto = new PcpOrderReqDto();
                CubeBeanUtils.copyProperties((Object)pcpOrderReqDto, (Object)childOrder, (String[])new String[0]);
                List<PlatformOrderItemRespDto> platformOrderItemList = orderItemMap.get(childOrder.getId());
                ArrayList itemReqDtoList = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)itemReqDtoList, platformOrderItemList, PlatformOrderItemReqDto.class);
                pcpOrderReqDto.setItemReqDtoList((List)itemReqDtoList);
                pcpOrderReqDtoList.add(pcpOrderReqDto);
            }
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    CspPcpOrderServiceImpl.this.displacePreemptInventoryBatch(pcpOrderReqDtoList, finalParentPlatformOrderRespDto);
                }
            });
        }
    }
}

