/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.transform.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.PascalNameFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.component.track.commons.constant.pcp.ExternalDispatchBaseEnum;
import com.dtyunxi.cube.component.track.commons.utils.TransactionTrackContextUtils;
import com.dtyunxi.cube.component.track.commons.vo.pcp.ExternalDispatchBaseVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.common.csp.constant.CspClaimOrderStatusEnum;
import com.dtyunxi.tcbj.center.openapi.common.csp.dto.CSPUpdateCspClaimOrderReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.PcpRegionRespDto;
import com.dtyunxi.yundt.cube.center.data.api.shop.dto.request.PcpShopReqDto;
import com.dtyunxi.yundt.cube.center.data.api.shop.dto.response.PcpShopRespDto;
import com.dtyunxi.yundt.cube.center.data.api.shop.query.IPcpShopQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsRelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsRelWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsRelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseQualityEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.AllotTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderSourceEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BizSaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderAddrReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.transform.api.constant.PlatformOrderSource;
import com.dtyunxi.yundt.cube.center.transform.api.constant.PlatformTransformOrderStatus;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderAddrReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderCancelReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderPcpExtendReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderSpExtReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PcpOrderChannelRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderAddrRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderPcpExtendRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderSpExtRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.exception.PlatformAssert;
import com.dtyunxi.yundt.cube.center.transform.api.exception.PlatformExceptionCode;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IDataQueryService;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPcpOrderService;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPlatformOrderAddrService;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPlatformOrderItemService;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPlatformOrderPcpExtendService;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPlatformOrderService;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPlatformOrderSpExtService;
import com.dtyunxi.yundt.cube.center.transform.biz.utils.IdUtils;
import com.dtyunxi.yundt.cube.center.transform.biz.utils.NoGenerateUtil;
import com.dtyunxi.yundt.cube.center.transform.dao.eo.PlatformOrderEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PcpOrderServiceImpl
implements IPcpOrderService {
    private static final Logger logger = LoggerFactory.getLogger(PcpOrderServiceImpl.class);
    @Resource
    private IPlatformOrderService platformOrderService;
    @Resource
    private IPlatformOrderItemService platformOrderItemService;
    @Resource
    private IPlatformOrderAddrService platformOrderAddrService;
    @Resource
    private IPlatformOrderPcpExtendService platformOrderPcpExtendService;
    @Resource
    private ILockService lockService;
    @Resource
    private IPcpShopQueryApi shopQueryApi;
    @Resource
    private ISaleOrderApi saleOrderApi;
    @Resource
    private ISaleOrderOptApi saleOrderOptApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ICsRelWarehouseApi csRelWarehouseQueryApi;
    @Resource
    private ICsLogicWarehouseExposedApi csLogicWarehouseExposedQueryApi;
    @Resource
    private IDataQueryService dataQueryService;
    @Resource
    private NoGenerateUtil noGenerateUtil;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ICsLogicWarehouseQueryApi csLogicWarehouseQueryApi;
    @Resource
    private IChannelWarehouseApi channelWarehouseQueryApi;
    @Resource
    private IPlatformOrderSpExtService platformOrderSpExtService;
    @Resource
    private ICacheService cacheService;
    public static final String SALE_ORDER_NO_KEY = "platform-sale-order";
    private static final List<String> purchaseOrderTypeList = Lists.newArrayList((Object[])new String[]{SaleOrderTypeEnum.AGENCY_ORDER.getType(), SaleOrderTypeEnum.INTEGRAL_ORDER.getType()});
    private static final List<Integer> checkOrderStatusList = Lists.newArrayList((Object[])new Integer[]{PlatformTransformOrderStatus.STATUS_2.getCode(), PlatformTransformOrderStatus.STATUS_3.getCode()});

    @Override
    public int getOrderSourceType() {
        return PlatformOrderSource.SOURCE_0.getCode();
    }

    @Override
    public RestResponse<Long> addPcpOrderProcess(PcpOrderReqDto addReqDto) {
        this.checkSaveBaseParam(addReqDto);
        Long orderId = null;
        orderId = (Long)RestResponseHelper.extractData(this.savePcpOrder(addReqDto));
        addReqDto.setId(orderId);
        this.transformPcpOrder(addReqDto);
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseStatus", (Object)"ok");
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseData", (Object)"status=abc&msg=ok");
        TransactionTrackContextUtils.setTrackLogResultData((String)"responseCode", (Object)"200");
        return new RestResponse((Object)orderId);
    }

    @Override
    public RestResponse<Void> transformPcpOrder(Long id) {
        return this.transformPcpOrder(this.buildPcpOrderReqDto(id));
    }

    @Override
    public RestResponse<Void> transformPcpOrder(PcpOrderReqDto pcpOrderReqDto) {
        if (pcpOrderReqDto.getId() == null) {
            throw PlatformExceptionCode.CHECK_PARAM_ID_NULL.buildBizException();
        }
        try {
            this.checkUpdateBaseParam(pcpOrderReqDto);
            PlatformOrderRespDto platformOrderRespDto = this.platformOrderService.queryById(pcpOrderReqDto.getId());
            this.checkPlatformOrderStatus(pcpOrderReqDto, PlatformTransformOrderStatus.forCode((int)platformOrderRespDto.getTransferOrderStatus()), PlatformTransformOrderStatus.STATUS_INIT_1, PlatformTransformOrderStatus.STATUS_1, PlatformTransformOrderStatus.STATUS_6);
            this.checkUpdateMaiyouParam(pcpOrderReqDto);
            this.executeTransform(pcpOrderReqDto);
            Integer easVerifyStatus = pcpOrderReqDto.getEasVerifyStatus();
            Date easVerifyTime = pcpOrderReqDto.getEasVerifyTime();
            pcpOrderReqDto = this.buildPcpOrderReqDto(pcpOrderReqDto.getId());
            pcpOrderReqDto.setEasVerifyStatus(easVerifyStatus);
            pcpOrderReqDto.setEasVerifyTime(easVerifyTime);
            String saleOrderNo = this.executeSaveSaleOrder(pcpOrderReqDto);
            logger.info("[\u5185\u90e8\u9500\u552e\u8ba2\u5355]\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)saleOrderNo));
            pcpOrderReqDto.setSaleOrderNo(StringUtils.isNotBlank((CharSequence)pcpOrderReqDto.getSaleOrderNo()) ? pcpOrderReqDto.getSaleOrderNo() : saleOrderNo);
            pcpOrderReqDto.setTransferOrderTime(new Date());
            pcpOrderReqDto.setSaleCreateTime(pcpOrderReqDto.getTransferOrderTime());
            this.sendEasSaleOrder(pcpOrderReqDto);
            if (Objects.equals(pcpOrderReqDto.getOrderType(), SaleOrderTypeEnum.COMPENSATION_ORDER.getType())) {
                this.sendCspSpMq(pcpOrderReqDto.getPlatformOrderNo(), CspClaimOrderStatusEnum.WAREHOUSE_TO_EAS);
            }
            this.transformPlatformOrderStatus(pcpOrderReqDto);
            if (Objects.equals(pcpOrderReqDto.getReleaseState(), YesOrNoEnum.YES.getType())) {
                String redisKey = pcpOrderReqDto.getPlatformOrderNo();
                this.cacheService.delCache(SALE_ORDER_NO_KEY, redisKey);
            }
        }
        catch (Exception e) {
            this.catchAndSaveOrderException(pcpOrderReqDto.getId(), e);
            logger.info("\u8f6c\u5355\u64cd\u4f5c\u5f02\u5e38:", (Throwable)e);
        }
        return new RestResponse();
    }

    public MessageResponse sendEasSaleOrder(PcpOrderReqDto respDto) {
        if (Objects.equals(SaleOrderTypeEnum.MAIYOU_ALLOT.getType(), respDto.getOrderType())) {
            logger.info("\u9ea6\u4f18\u8c03\u62e8\u8ba2\u5355\u7c7b\u578b\u4e0d\u63a8\u9001eas");
            return null;
        }
        if (Objects.equals(SaleOrderTypeEnum.COMPENSATION_ORDER.getType(), respDto.getOrderType()) || Objects.equals(SaleOrderTypeEnum.COMPENSATION_NOT_ORDER.getType(), respDto.getOrderType()) || Objects.equals(SaleOrderTypeEnum.CLAIM_POSTING.getType(), respDto.getOrderType()) || Objects.equals(SaleOrderTypeEnum.CLAIM_REISSUE.getType(), respDto.getOrderType())) {
            List replacementItemList = respDto.getItemReqDtoList().stream().filter(dto -> Objects.equals(dto.getReplacementFlag(), YesOrNoEnum.YES.getType())).collect(Collectors.toList());
            respDto.setItemReqDtoList(replacementItemList);
        }
        logger.info("\u8f6c\u5355\u6210\u529f\u63a8\u9001EAS\u9500\u552e\u8ba2\u5355\uff1a{}", (Object)JSON.toJSONString((Object)respDto));
        return this.sendMq(respDto, ExternalDispatchBaseEnum.API_EAS008);
    }

    private MessageResponse sendMq(Object obj, ExternalDispatchBaseEnum baseEnum) {
        ExternalDispatchBaseVo baseVo = new ExternalDispatchBaseVo();
        baseVo.setExternalDispatchBaseEnum(baseEnum);
        baseVo.setData(obj);
        logger.info("\u53d1\u9001\u5185\u5bb9\uff1a{}", (Object)JSON.toJSONString((Object)baseVo, (SerializeFilter)new PascalNameFilter(), (SerializerFeature[])new SerializerFeature[0]));
        this.commonsMqService.sendSingleMessage(baseEnum.getTopicKey(), baseEnum.getTagKey(), (Object)JSON.toJSONString((Object)baseVo));
        return MessageResponse.SUCCESS;
    }

    @Override
    public RestResponse<Void> abolishPcpOrder(PcpOrderReqDto pcpOrderReqDto) {
        PlatformAssert.notNull((Object)pcpOrderReqDto.getId(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u5e73\u53f0\u5355id\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformOrderRespDto platformOrderRespDto = this.platformOrderService.queryById(pcpOrderReqDto.getId());
        PlatformAssert.notNull((Object)platformOrderRespDto, (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u5e73\u53f0\u5355\u4fe1\u606f\u4e0d\u5b58\u5728"});
        this.checkPlatformOrderStatus(pcpOrderReqDto, PlatformTransformOrderStatus.forCode((int)platformOrderRespDto.getTransferOrderStatus()), PlatformTransformOrderStatus.STATUS_INIT_1, PlatformTransformOrderStatus.STATUS_1, PlatformTransformOrderStatus.STATUS_0);
        if (StringUtils.isNotBlank((CharSequence)platformOrderRespDto.getSaleOrderNo())) {
            BizSaleOrderRespDto bizSaleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(platformOrderRespDto.getSaleOrderNo()));
            PlatformAssert.notNull((Object)bizSaleOrderRespDto, (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u67e5\u8be2\u5173\u8054\u9500\u552e\u8ba2\u5355\u5931\u8d25"});
            if (!Objects.equals(bizSaleOrderRespDto.getOrderStatus(), SaleOrderStatusEnum.OBSOLETE.getCode())) {
                throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u5173\u8054\u9500\u552e\u8ba2\u5355\u672a\u53d6\u6d88\uff0c\u4e0d\u5141\u8bb8\u4f5c\u5e9f"});
            }
        }
        this.abolishPlatformOrderStatus(pcpOrderReqDto.getId(), pcpOrderReqDto.getObsoleteReason());
        return new RestResponse();
    }

    @Override
    public RestResponse<Void> cancelPlatformOrder(PlatformOrderCancelReqDto platformOrderCancelReqDto) {
        List<Object> platformOrderRespDtoList = this.platformOrderService.queryListNormalByPlatformNo(platformOrderCancelReqDto.getPlatformOrderNo());
        PlatformAssert.notEmpty(platformOrderRespDtoList, (PlatformExceptionCode)PlatformExceptionCode.QUERY_CANCEL_PLATFORM_ORDER_NULL, (String[])new String[0]);
        platformOrderRespDtoList = platformOrderRespDtoList.stream().filter(dto -> !dto.getTransferOrderStatus().equals(PlatformTransformOrderStatus.STATUS_2.getCode())).collect(Collectors.toList());
        if (platformOrderRespDtoList.size() > 1) {
            throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u5e73\u53f0\u5355\u6570\u636e\u91cd\u590d"});
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(platformOrderRespDtoList)) {
            return new RestResponse();
        }
        PlatformOrderRespDto orderRespDto = (PlatformOrderRespDto)platformOrderRespDtoList.get(0);
        this.checkPlatformOrderStatus(orderRespDto.getId(), PlatformTransformOrderStatus.forCode((int)orderRespDto.getTransferOrderStatus()), PlatformTransformOrderStatus.STATUS_0);
        PlatformAssert.notNull((Object)orderRespDto.getSaleOrderNo(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u53d6\u6d88\u8ba2\u5355-\u9500\u552e\u5355\u53f7\u7f3a\u5931"});
        BizSaleOrderRespDto bizSaleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(orderRespDto.getSaleOrderNo()));
        PlatformAssert.notNull((Object)bizSaleOrderRespDto, (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u53d6\u6d88\u8ba2\u5355-\u83b7\u53d6\u4e0d\u5230\u539f\u9500\u552e\u5355\u4fe1\u606f\uff1a" + orderRespDto.getSaleOrderNo()});
        if (SaleOrderStatusEnum.CANCEL.getCode().equals(bizSaleOrderRespDto.getOrderStatus())) {
            return new RestResponse();
        }
        PlatformOrderEo platformOrderEo = new PlatformOrderEo();
        platformOrderEo.setTransferOrderStatus(Integer.valueOf(PlatformTransformOrderStatus.STATUS_2.code));
        platformOrderEo.setObsoleteReason("\u4e0a\u6e38\u7cfb\u7edf\u53d6\u6d88");
        PlatformOrderEo queryEo = new PlatformOrderEo();
        queryEo.setId(orderRespDto.getId());
        UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
        updateWrapper.eq((Object)"transfer_order_status", (Object)orderRespDto.getTransferOrderStatus());
        this.platformOrderService.optimisticModifyPlatformOrder(platformOrderEo, (UpdateWrapper<PlatformOrderEo>)updateWrapper, 1, true);
        return this.saleOrderOptApi.cancelOrder(bizSaleOrderRespDto.getId(), "\u4e0a\u6e38\u7cfb\u7edf\u53d6\u6d88");
    }

    private PcpOrderReqDto buildPcpOrderReqDto(Long platformTransformOrderId) {
        PlatformOrderRespDto platformOrderRespDto = this.platformOrderService.queryById(platformTransformOrderId);
        if (Objects.isNull(platformOrderRespDto)) {
            throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u8f6c\u5355\u5931\u8d25:\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728"});
        }
        List<PlatformOrderItemRespDto> platformOrderItemRespDtos = this.platformOrderItemService.queryListByOrderId(platformOrderRespDto.getId());
        PlatformOrderAddrRespDto platformOrderAddrRespDto = this.platformOrderAddrService.queryByOrderId(platformOrderRespDto.getId());
        PlatformOrderPcpExtendRespDto platformOrderPcpExtendRespDto = this.platformOrderPcpExtendService.queryByOrderId(platformOrderRespDto.getId());
        PlatformOrderSpExtRespDto platformOrderSpExtRespDto = this.platformOrderSpExtService.queryByPlatformOrderId(platformOrderRespDto.getId());
        PcpOrderReqDto pcpOrderReqDto = new PcpOrderReqDto();
        CubeBeanUtils.copyProperties((Object)pcpOrderReqDto, (Object)platformOrderRespDto, (String[])new String[0]);
        ArrayList platformOrderItemReqDtos = new ArrayList();
        CubeBeanUtils.copyCollection(platformOrderItemReqDtos, platformOrderItemRespDtos, PlatformOrderItemReqDto.class);
        pcpOrderReqDto.setItemReqDtoList(platformOrderItemReqDtos);
        PlatformOrderAddrReqDto platformOrderAddrReqDto = new PlatformOrderAddrReqDto();
        CubeBeanUtils.copyProperties((Object)platformOrderAddrReqDto, (Object)platformOrderAddrRespDto, (String[])new String[0]);
        pcpOrderReqDto.setPlatformOrderAddrReqDto(platformOrderAddrReqDto);
        pcpOrderReqDto.setOutCreatePerson(platformOrderRespDto.getCreatePerson());
        PlatformOrderPcpExtendReqDto platformOrderPcpExtendReqDto = new PlatformOrderPcpExtendReqDto();
        CubeBeanUtils.copyProperties((Object)platformOrderPcpExtendReqDto, (Object)platformOrderPcpExtendRespDto, (String[])new String[0]);
        pcpOrderReqDto.setPlatformOrderPcpExtendReqDto(platformOrderPcpExtendReqDto);
        PlatformOrderSpExtReqDto platformOrderSpExtReqDto = new PlatformOrderSpExtReqDto();
        CubeBeanUtils.copyProperties((Object)platformOrderSpExtRespDto, (Object)platformOrderSpExtReqDto, (String[])new String[0]);
        pcpOrderReqDto.setSpExtReqDto(platformOrderSpExtReqDto);
        return pcpOrderReqDto;
    }

    private void catchAndSaveOrderException(Long orderId, Exception e) {
        logger.error(e.getMessage(), (Throwable)e);
        this.saveOrderExceptionStatus(orderId, e, PlatformTransformOrderStatus.STATUS_INIT_1.code, PlatformTransformOrderStatus.STATUS_1.code, PlatformTransformOrderStatus.STATUS_6.code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> savePcpOrder(PcpOrderReqDto addReqDto) {
        Long orderId;
        Mutex lock = null;
        try {
            lock = this.lockService.lock("savePcpOrder", addReqDto.getPlatformOrderNo(), 0, 300, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw PlatformExceptionCode.LOCK_OPT.buildBizException();
        }
        try {
            if (this.checkPlatformHadExist(addReqDto.getPlatformOrderNo())) {
                throw PlatformExceptionCode.CHECK_INSERT_PLATFORM_ORDER_EXIST.buildBizException(new Object[]{addReqDto.getPlatformOrderNo()});
            }
            if (StringUtils.isEmpty((CharSequence)addReqDto.getTransformOrderNo())) {
                addReqDto.setTransformOrderNo(this.noGenerateUtil.generateTransformOrderNo());
            }
            this.dataQueryService.setAddOrderInfo(addReqDto);
            addReqDto.setGoodsTotalNum(BigDecimal.ZERO);
            addReqDto.setGoodsTotalAmount(BigDecimal.ZERO);
            addReqDto.setGoodsSkuTotalNum(BigDecimal.ZERO);
            addReqDto.setPayAmount(BigDecimal.ZERO);
            addReqDto.setOrderTotalAmount(BigDecimal.ZERO);
            HashSet skuCode = new LinkedHashSet<String>();
            for (PlatformOrderItemReqDto item2 : addReqDto.getItemReqDtoList()) {
                if (Objects.equals(item2.getReplacementFlag(), YesOrNoEnum.YES.getType())) continue;
                addReqDto.setGoodsTotalNum(addReqDto.getGoodsTotalNum().add(item2.getItemNum()));
                skuCode.add(item2.getSkuCode());
                addReqDto.setGoodsTotalAmount(addReqDto.getGoodsTotalAmount().add(item2.getOrderTotalAmount()));
                if (Objects.nonNull(item2.getPayAmount())) {
                    addReqDto.setPayAmount(addReqDto.getPayAmount().add(item2.getPayAmount()));
                }
                if (!Objects.nonNull(item2.getOrderTotalAmount())) continue;
                addReqDto.setOrderTotalAmount(addReqDto.getOrderTotalAmount().add(item2.getOrderTotalAmount()));
            }
            addReqDto.setGoodsSkuTotalNum(new BigDecimal(skuCode.size()));
            PlatformOrderReqDto platformOrderReqDto = this.coverPlatformOrderReqDtoParam(addReqDto);
            orderId = this.platformOrderService.addPlatformOrder(platformOrderReqDto);
            List<Object> platformOrderEos = this.platformOrderService.queryListByPlatformOrderNo(orderId, platformOrderReqDto.getPlatformOrderNo());
            platformOrderEos = platformOrderEos.stream().filter(eo -> !checkOrderStatusList.contains(eo.getTransferOrderStatus())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(platformOrderEos) || platformOrderEos.size() > 1 || !this.checkOrderIdAndStatus(platformOrderEos, orderId)) {
                throw PlatformExceptionCode.CHECK_INSERT_PLATFORM_ORDER_REPEAT.buildBizException(new Object[]{platformOrderReqDto.getPlatformOrderNo()});
            }
            addReqDto.getItemReqDtoList().forEach(item -> {
                item.setId(IdUtils.getId());
                item.setOrderId(orderId);
                item.setOrganizationId(platformOrderReqDto.getOrganizationId());
                item.setOrganizationCode(platformOrderReqDto.getOrganizationCode());
                item.setOrganizationName(platformOrderReqDto.getOrganizationName());
                item.setRdc(platformOrderReqDto.getRdc());
                if (Objects.isNull(item.getLineAmount())) {
                    item.setLineAmount(item.getOrderTotalAmount());
                }
                this.platformOrderItemService.addPlatformOrderItem((PlatformOrderItemReqDto)item);
            });
            PlatformOrderAddrReqDto platformOrderAddrReqDto = addReqDto.getPlatformOrderAddrReqDto();
            if (platformOrderAddrReqDto != null) {
                platformOrderAddrReqDto.setId(IdUtils.getId());
                platformOrderAddrReqDto.setOrderId(orderId);
                platformOrderAddrReqDto.setOrganizationId(platformOrderReqDto.getOrganizationId());
                platformOrderAddrReqDto.setOrganizationCode(platformOrderReqDto.getOrganizationCode());
                platformOrderAddrReqDto.setOrganizationName(platformOrderReqDto.getOrganizationName());
                this.platformOrderAddrService.addPlatformOrderAddr(platformOrderAddrReqDto);
            }
            addReqDto.getPlatformOrderPcpExtendReqDto().setId(IdUtils.getId());
            addReqDto.getPlatformOrderPcpExtendReqDto().setPlatformOrderId(orderId);
            addReqDto.getPlatformOrderPcpExtendReqDto().setPlatformOrderNo(platformOrderReqDto.getPlatformOrderNo());
            addReqDto.getPlatformOrderPcpExtendReqDto().setOrganizationId(platformOrderReqDto.getOrganizationId());
            addReqDto.getPlatformOrderPcpExtendReqDto().setOrganizationCode(platformOrderReqDto.getOrganizationCode());
            addReqDto.getPlatformOrderPcpExtendReqDto().setOrganizationName(platformOrderReqDto.getOrganizationName());
            this.platformOrderPcpExtendService.addPlatformOrderPcpExtend(addReqDto.getPlatformOrderPcpExtendReqDto());
            if (Objects.equals(SaleOrderTypeEnum.COMPENSATION_ORDER.getType(), addReqDto.getOrderType()) || Objects.equals(SaleOrderTypeEnum.COMPENSATION_NOT_ORDER.getType(), addReqDto.getOrderType()) || Objects.equals(SaleOrderTypeEnum.CLAIM_POSTING.getType(), addReqDto.getOrderType()) || Objects.equals(SaleOrderTypeEnum.CLAIM_REISSUE.getType(), addReqDto.getOrderType())) {
                PlatformOrderSpExtReqDto platformOrderSpExtReqDto = new PlatformOrderSpExtReqDto();
                CubeBeanUtils.copyProperties((Object)platformOrderSpExtReqDto, (Object)addReqDto.getSpExtReqDto(), (String[])new String[0]);
                platformOrderSpExtReqDto.setId(IdUtils.getId());
                platformOrderSpExtReqDto.setOrganizationId(platformOrderReqDto.getOrganizationId());
                platformOrderSpExtReqDto.setOrganizationCode(platformOrderReqDto.getOrganizationCode());
                platformOrderSpExtReqDto.setOrganizationName(platformOrderReqDto.getOrganizationName());
                platformOrderSpExtReqDto.setPlatformOrderId(orderId);
                platformOrderSpExtReqDto.setPlatformOrderNo(platformOrderReqDto.getPlatformOrderNo());
                platformOrderSpExtReqDto.setItemSkuTotalNum(BigDecimal.ZERO);
                platformOrderSpExtReqDto.setItemTotalAmount(BigDecimal.ZERO);
                platformOrderSpExtReqDto.setItemTotalNum(BigDecimal.ZERO);
                skuCode = new HashSet();
                for (PlatformOrderItemReqDto item3 : addReqDto.getItemReqDtoList()) {
                    if (!Objects.equals(item3.getReplacementFlag(), YesOrNoEnum.YES.getType())) continue;
                    platformOrderSpExtReqDto.setItemTotalNum(platformOrderSpExtReqDto.getItemTotalNum().add(item3.getItemNum()));
                    skuCode.add(item3.getSkuCode());
                    platformOrderSpExtReqDto.setItemTotalAmount(platformOrderSpExtReqDto.getItemTotalAmount().add(item3.getOrderTotalAmount()));
                }
                platformOrderSpExtReqDto.setItemSkuTotalNum(new BigDecimal(skuCode.size()));
                this.platformOrderSpExtService.addPlatformOrderSpExt(platformOrderSpExtReqDto);
            }
        }
        finally {
            this.lockService.unlock(lock);
        }
        return new RestResponse((Object)orderId);
    }

    private boolean checkPlatformHadExist(String platformOrderNo) {
        PlatformOrderRespDto platformOrderRespDto = this.platformOrderService.queryNormalByPlatformNo(platformOrderNo);
        return platformOrderRespDto != null && !checkOrderStatusList.contains(platformOrderRespDto.getTransferOrderStatus());
    }

    private boolean checkOrderIdAndStatus(List<PlatformOrderEo> platformOrderEos, Long orderId) {
        for (PlatformOrderEo platformOrderEo : platformOrderEos) {
            if (platformOrderEo.getId().equals(orderId)) continue;
            return false;
        }
        return true;
    }

    private void saveOrderExceptionStatus(Long orderId, Exception e, Integer ... beforeStatus) {
        try {
            PlatformOrderEo platformOrderEo = new PlatformOrderEo();
            platformOrderEo.setTransferOrderStatus(Integer.valueOf(PlatformTransformOrderStatus.STATUS_1.code));
            platformOrderEo.setTransferOrderTime(new Date());
            platformOrderEo.setExceptionReason(e.getMessage());
            PlatformOrderEo queryEo = new PlatformOrderEo();
            queryEo.setId(orderId);
            UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
            updateWrapper.in((Object)"transfer_order_status", Arrays.asList(beforeStatus));
            this.platformOrderService.optimisticModifyPlatformOrder(platformOrderEo, (UpdateWrapper<PlatformOrderEo>)updateWrapper, 1, true);
        }
        catch (Exception e1) {
            logger.error("\u4fee\u6539\u8f6c\u5355\u72b6\u6001\u5931\u8d25:" + e1.getMessage(), (Throwable)e1);
        }
    }

    private PlatformOrderReqDto coverPlatformOrderReqDtoParam(PcpOrderReqDto addReqDto) {
        PlatformOrderReqDto platformOrderReqDto = new PlatformOrderReqDto();
        CubeBeanUtils.copyProperties((Object)platformOrderReqDto, (Object)addReqDto, (String[])new String[0]);
        platformOrderReqDto.setId(IdUtils.getId());
        platformOrderReqDto.setOrderType(addReqDto.getOrderType());
        if (Objects.isNull(addReqDto.getTransferOrderStatus())) {
            platformOrderReqDto.setTransferOrderStatus(Integer.valueOf(PlatformTransformOrderStatus.STATUS_INIT_1.code));
        }
        platformOrderReqDto.setCreatePerson(Optional.ofNullable(addReqDto.getOutCreatePerson()).orElse("system"));
        platformOrderReqDto.setExtension(JSON.toJSONString((Object)addReqDto.getExtFields()));
        if (StringUtils.isNotEmpty((CharSequence)addReqDto.getNewSaleOrderNo())) {
            platformOrderReqDto.setSaleOrderNo(addReqDto.getNewSaleOrderNo());
        }
        return platformOrderReqDto;
    }

    private void transformPlatformOrderStatus(PcpOrderReqDto pcpOrderReqDto) {
        if (StringUtils.isBlank((CharSequence)pcpOrderReqDto.getSaleOrderNo())) {
            throw PlatformExceptionCode.CHECK_PARAM_SALE_ORDER_NO_NOT_ALLOW.buildBizException();
        }
        PlatformOrderEo platformOrderEo = new PlatformOrderEo();
        platformOrderEo.setTransferOrderStatus(Integer.valueOf(PlatformTransformOrderStatus.STATUS_0.code));
        platformOrderEo.setTransferOrderTime(pcpOrderReqDto.getTransferOrderTime());
        platformOrderEo.setSaleOrderNo(pcpOrderReqDto.getSaleOrderNo());
        platformOrderEo.setSaleCreateTime(pcpOrderReqDto.getSaleCreateTime());
        platformOrderEo.setExceptionReason("-");
        PlatformOrderEo queryEo = new PlatformOrderEo();
        queryEo.setId(pcpOrderReqDto.getId());
        UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
        updateWrapper.ne((Object)"transfer_order_status", (Object)PlatformTransformOrderStatus.STATUS_0.code);
        this.platformOrderService.optimisticModifyPlatformOrder(platformOrderEo, (UpdateWrapper<PlatformOrderEo>)updateWrapper, 1, true);
    }

    private void abolishPlatformOrderStatus(Long orderId, String abolishReason) {
        PlatformOrderEo platformOrderEo = new PlatformOrderEo();
        platformOrderEo.setTransferOrderStatus(Integer.valueOf(PlatformTransformOrderStatus.STATUS_2.code));
        String requestUserCode = (String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"");
        platformOrderEo.setObsoletePerson(requestUserCode);
        platformOrderEo.setObsoleteReason(abolishReason);
        platformOrderEo.setObsoleteTime(new Date());
        PlatformOrderEo queryEo = new PlatformOrderEo();
        queryEo.setId(orderId);
        UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
        updateWrapper.in((Object)"transfer_order_status", Arrays.asList(PlatformTransformOrderStatus.STATUS_INIT_1.code, PlatformTransformOrderStatus.STATUS_1.code, PlatformTransformOrderStatus.STATUS_0.code));
        this.platformOrderService.optimisticModifyPlatformOrder(platformOrderEo, (UpdateWrapper<PlatformOrderEo>)updateWrapper, 1, true);
    }

    private void checkUpdateBaseParam(PcpOrderReqDto pcpOrderReqDto) {
        this.checkSaveBaseParam(pcpOrderReqDto);
    }

    private void checkUpdateMaiyouParam(PcpOrderReqDto pcpOrderReqDto) {
        CsLogicWarehousePageRespDto inLogicWarehousePageRespDto;
        if (!Objects.equals(pcpOrderReqDto.getOrderType(), SaleOrderTypeEnum.MAIYOU_ALLOT.getType())) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)pcpOrderReqDto.getAllotInWarehouseCode())) {
            throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u8c03\u5165\u903b\u8f91\u4ed3\u7f16\u7801\u4e3a\u7a7a"});
        }
        if ((Objects.equals(pcpOrderReqDto.getAllotType(), AllotTypeEnum.MAIYOU_CC_ALLOT.getType()) || Objects.equals(pcpOrderReqDto.getAllotType(), AllotTypeEnum.MAIYOU_CC_ALLOT_OUT.getType())) && StringUtils.isEmpty((CharSequence)pcpOrderReqDto.getAllotOutWarehouseCode())) {
            throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u8c03\u51fa\u903b\u8f91\u4ed3\u7f16\u7801\u4e3a\u7a7a"});
        }
        ArrayList codeList = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)pcpOrderReqDto.getAllotOutWarehouseCode())) {
            codeList.add(pcpOrderReqDto.getAllotOutWarehouseCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)pcpOrderReqDto.getAllotInWarehouseCode())) {
            codeList.add(pcpOrderReqDto.getAllotInWarehouseCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)pcpOrderReqDto.getMyArrangeLogicalWarehouseCode())) {
            codeList.add(pcpOrderReqDto.getMyArrangeLogicalWarehouseCode());
        }
        if (CollectionUtils.isEmpty((Collection)codeList)) {
            logger.info("\u9ea6\u4f18\u8c03\u62e8\u8865\u8d27\u5355\u8c03\u51fa\u4ed3\u548c\u8c03\u5165\u4ed3\u4e0d\u5b58\u5728");
            throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u8c03\u51fa\u4ed3\u548c\u8c03\u5165\u4ed3\u4e0d\u5b58\u5728"});
        }
        CsRelWarehouseQueryDto queryLogicReqDto = new CsRelWarehouseQueryDto();
        queryLogicReqDto.setWarehouseCodeList((List)codeList);
        queryLogicReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        List csRelWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csRelWarehouseQueryApi.queryWarehouseByConditions(queryLogicReqDto));
        PlatformAssert.notEmpty((Collection)csRelWarehouseRespDtos, (PlatformExceptionCode)PlatformExceptionCode.QUERY_ORDER_INFO_IS_NULL, (String[])new String[]{"\u8c03\u5165\u4ed3/\u8c03\u51fa\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728"});
        CsLogicWarehouseParamQueryDto logicWarehouseParamQueryDto = new CsLogicWarehouseParamQueryDto();
        logicWarehouseParamQueryDto.setWarehouseCodeList((List)codeList);
        List csLogicWarehousePageRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryParam(logicWarehouseParamQueryDto));
        PlatformAssert.notEmpty((Collection)csLogicWarehousePageRespDtos, (PlatformExceptionCode)PlatformExceptionCode.QUERY_ORDER_INFO_IS_NULL, (String[])new String[]{"\u8c03\u5165/\u8c03\u51fa\u903b\u8f91\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728"});
        Map logicMap = csLogicWarehousePageRespDtos.stream().collect(Collectors.toMap(CsLogicWarehousePageRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        if (Objects.equals(pcpOrderReqDto.getAllotType(), AllotTypeEnum.MAIYOU_CC_ALLOT.getType()) || Objects.equals(pcpOrderReqDto.getAllotType(), AllotTypeEnum.MAIYOU_CC_ALLOT_OUT.getType())) {
            CsLogicWarehousePageRespDto outLogicWarehousePageRespDto = (CsLogicWarehousePageRespDto)logicMap.get(pcpOrderReqDto.getAllotOutWarehouseCode());
            if (Objects.isNull(outLogicWarehousePageRespDto)) {
                throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u8c03\u51fa\u903b\u8f91\u4ed3" + pcpOrderReqDto.getAllotOutWarehouseCode() + "\u4fe1\u606f\u4e0d\u5b58\u5728"});
            }
            PlatformAssert.needEquals((Object)outLogicWarehousePageRespDto.getWarehouseStatus(), (Object)CsValidFlagEnum.ENABLE.getCode(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{outLogicWarehousePageRespDto.getWarehouseCode() + "\u903b\u8f91\u4ed3\u5e93\u672a\u542f\u7528"});
            pcpOrderReqDto.setAllotOutWarehouseName(outLogicWarehousePageRespDto.getWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)pcpOrderReqDto.getMyArrangeLogicalWarehouseCode())) {
            CsLogicWarehousePageRespDto myLogicWarehousePageRespDto = (CsLogicWarehousePageRespDto)logicMap.get(pcpOrderReqDto.getMyArrangeLogicalWarehouseCode());
            if (Objects.isNull(myLogicWarehousePageRespDto)) {
                throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u6307\u5b9a\u903b\u8f91\u4ed3" + pcpOrderReqDto.getMyArrangeLogicalWarehouseCode() + "\u4fe1\u606f\u4e0d\u5b58\u5728"});
            }
            PlatformAssert.needEquals((Object)myLogicWarehousePageRespDto.getWarehouseStatus(), (Object)CsValidFlagEnum.ENABLE.getCode(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{myLogicWarehousePageRespDto.getWarehouseCode() + "\u903b\u8f91\u4ed3\u5e93\u672a\u542f\u7528"});
            pcpOrderReqDto.setMyArrangeLogicalWarehouseName(myLogicWarehousePageRespDto.getWarehouseName());
        }
        if (Objects.isNull(inLogicWarehousePageRespDto = (CsLogicWarehousePageRespDto)logicMap.get(pcpOrderReqDto.getAllotInWarehouseCode()))) {
            throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u8c03\u5165\u903b\u8f91\u4ed3" + pcpOrderReqDto.getAllotInWarehouseCode() + "\u4fe1\u606f\u4e0d\u5b58\u5728"});
        }
        PlatformAssert.needEquals((Object)inLogicWarehousePageRespDto.getWarehouseStatus(), (Object)CsValidFlagEnum.ENABLE.getCode(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{inLogicWarehousePageRespDto.getWarehouseCode() + "\u903b\u8f91\u4ed3\u5e93\u672a\u542f\u7528"});
        pcpOrderReqDto.setAllotInWarehouseName(inLogicWarehousePageRespDto.getWarehouseName());
    }

    private void checkSaveBaseParam(PcpOrderReqDto pcpOrderReqDto) {
        PlatformAssert.notNull((Object)pcpOrderReqDto.getPlatformOrderPcpExtendReqDto(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u6269\u5c55\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformAssert.notNull((Object)pcpOrderReqDto.getEasOrgId(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"EasOrgId\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformAssert.notBlank((String)pcpOrderReqDto.getOrderType(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"});
        PlatformAssert.notNull((Object)SaleOrderTypeEnum.enumOf((String)pcpOrderReqDto.getOrderType()), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u8ba2\u5355\u7c7b\u578b\u9519\u8bef"});
        PlatformAssert.notBlank((String)pcpOrderReqDto.getPlatformOrderNo(), (PlatformExceptionCode)PlatformExceptionCode.CHECK_PARAM_PNO_NULL, (String[])new String[0]);
        PlatformAssert.notBlank((String)pcpOrderReqDto.getOrderChannelCode(), (PlatformExceptionCode)PlatformExceptionCode.CHECK_PARAM_ORDER_CHANNEL_CODE_NULL, (String[])new String[0]);
        if (!(Objects.equals(pcpOrderReqDto.getOrderType(), SaleOrderTypeEnum.SHOPPE_ORDER.getType()) || Objects.equals(pcpOrderReqDto.getAllotType(), AllotTypeEnum.MAIYOU_CC_ALLOT.getType()) || Objects.equals(pcpOrderReqDto.getAllotType(), AllotTypeEnum.MAIYOU_CC_ALLOT_OUT.getType()))) {
            PlatformAssert.notBlank((String)pcpOrderReqDto.getChannelWarehouseCode(), (PlatformExceptionCode)PlatformExceptionCode.CHECK_PARAM_CHANNEL_WAREHOUSE_CODE_NULL, (String[])new String[0]);
        }
        if (!Objects.equals(pcpOrderReqDto.getOrderType(), SaleOrderTypeEnum.CLAIM_REISSUE.getType()) && !Objects.equals(pcpOrderReqDto.getOrderType(), SaleOrderTypeEnum.CLAIM_POSTING.getType())) {
            PlatformAssert.notBlank((String)pcpOrderReqDto.getThirdPartyId(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{"\u5ba2\u6237\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        PlatformAssert.notEmpty((Collection)pcpOrderReqDto.getItemReqDtoList(), (PlatformExceptionCode)PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_NULL, (String[])new String[0]);
        PlatformAssert.notNull((Object)pcpOrderReqDto.getOrderSource(), (PlatformExceptionCode)PlatformExceptionCode.CHECK_ORDER_INFO_ORDER_SOURCE_NULL, (String[])new String[0]);
        Optional.ofNullable(SaleOrderSourceEnum.enumOf((Integer)pcpOrderReqDto.getOrderSource())).orElseThrow(() -> ((PlatformExceptionCode)PlatformExceptionCode.CHECK_ORDER_INFO_ORDER_SOURCE_EXCHANGE_NULL).buildBizException());
        pcpOrderReqDto.getItemReqDtoList().forEach(dto -> {
            if (StringUtils.isBlank((CharSequence)dto.getSkuCode())) {
                throw PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_CODE_NULL.buildBizException();
            }
            if (dto.getItemNum() == null || dto.getItemNum().compareTo(BigDecimal.ZERO) <= 0) {
                throw PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_NUM_NULL.buildBizException(new Object[]{dto.getItemCode()});
            }
            if (dto.getPrice() == null || dto.getPrice().compareTo(BigDecimal.ZERO) < 0) {
                throw PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_PRICE_NULL.buildBizException(new Object[]{dto.getItemCode()});
            }
            if (dto.getGift() == null || dto.getGift() != 1 && dto.getGift() != 0) {
                throw PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_GIFT_TYPE_WRONG.buildBizException(new Object[]{dto.getItemCode()});
            }
        });
        Map<String, List<PlatformOrderItemReqDto>> itemMap = pcpOrderReqDto.getItemReqDtoList().stream().collect(Collectors.groupingBy(PlatformOrderItemReqDto::getSkuCode));
        if (!(Objects.equals(pcpOrderReqDto.getOrderType(), SaleOrderTypeEnum.SHOPPE_ORDER.getType()) || Objects.equals(pcpOrderReqDto.getOrderType(), SaleOrderTypeEnum.REPLENISHMENT_ORDER.getType()) || Objects.equals(pcpOrderReqDto.getOrderType(), SaleOrderTypeEnum.NUTRITION_INTEGRAL.getType()) || Objects.equals(pcpOrderReqDto.getOrderType(), SaleOrderTypeEnum.ACTIVITY_ORDER.getType()))) {
            if (StringUtils.isBlank((CharSequence)pcpOrderReqDto.getPlatformOrderAddrReqDto().getProvinceCode())) {
                throw PlatformExceptionCode.CHECK_ORDER_INFO_ADDRESS_FAIL.buildBizException(new Object[]{"\u7701"});
            }
            if (StringUtils.isBlank((CharSequence)pcpOrderReqDto.getPlatformOrderAddrReqDto().getCityCode())) {
                throw PlatformExceptionCode.CHECK_ORDER_INFO_ADDRESS_FAIL.buildBizException(new Object[]{"\u5e02"});
            }
        }
        if (StringUtils.isBlank((CharSequence)pcpOrderReqDto.getPlatformOrderAddrReqDto().getReceiveAddress())) {
            throw PlatformExceptionCode.CHECK_ORDER_INFO_ADDRESS_FAIL.buildBizException(new Object[]{"\u8be6\u7ec6\u5730\u5740"});
        }
        if (StringUtils.isBlank((CharSequence)pcpOrderReqDto.getPlatformOrderAddrReqDto().getReceiveName())) {
            throw PlatformExceptionCode.CHECK_ORDER_INFO_ADDRESS_FAIL.buildBizException(new Object[]{"\u6536\u8d27\u4eba"});
        }
        if (StringUtils.isBlank((CharSequence)pcpOrderReqDto.getPlatformOrderAddrReqDto().getReceivePhone())) {
            throw PlatformExceptionCode.CHECK_ORDER_INFO_ADDRESS_FAIL.buildBizException(new Object[]{"\u6536\u8d27\u7535\u8bdd"});
        }
    }

    private void checkPlatformOrderStatus(PcpOrderReqDto pcpOrderReqDto, PlatformTransformOrderStatus nowStatus, PlatformTransformOrderStatus ... allowStatus) {
        PlatformTransformOrderStatus status;
        logger.info("checkPlatformOrderStatus\uff0c{}\u5f53\u524d\u72b6\u6001={},\u5141\u8bb8\u901a\u8fc7\u72b6\u6001={}", new Object[]{pcpOrderReqDto.getId(), nowStatus, JSON.toJSONString((Object)allowStatus)});
        if (allowStatus == null) {
            throw PlatformExceptionCode.CHECK_STATUS_STATUS_NOT_ALLOW.buildBizException(new Object[]{nowStatus.desc});
        }
        boolean inAllow = false;
        PlatformTransformOrderStatus[] platformTransformOrderStatusArray = allowStatus;
        int n = platformTransformOrderStatusArray.length;
        for (int i = 0; i < n && !(inAllow = (status = platformTransformOrderStatusArray[i]) == nowStatus); ++i) {
        }
        if (!inAllow) {
            throw PlatformExceptionCode.CHECK_STATUS_STATUS_NOT_ALLOW.buildBizException(new Object[]{nowStatus.desc});
        }
    }

    private void checkPlatformOrderStatus(Long id, PlatformTransformOrderStatus nowStatus, PlatformTransformOrderStatus ... allowStatus) {
        PlatformTransformOrderStatus status;
        logger.info("checkPlatformOrderStatus\uff0c{}\u5f53\u524d\u72b6\u6001={},\u5141\u8bb8\u901a\u8fc7\u72b6\u6001={}", new Object[]{id, nowStatus, JSON.toJSONString((Object)allowStatus)});
        if (allowStatus == null) {
            throw PlatformExceptionCode.CHECK_STATUS_STATUS_NOT_ALLOW.buildBizException(new Object[]{nowStatus.desc});
        }
        boolean inAllow = false;
        PlatformTransformOrderStatus[] platformTransformOrderStatusArray = allowStatus;
        int n = platformTransformOrderStatusArray.length;
        for (int i = 0; i < n && !(inAllow = (status = platformTransformOrderStatusArray[i]) == nowStatus); ++i) {
        }
        if (!inAllow) {
            throw PlatformExceptionCode.CHECK_STATUS_STATUS_NOT_ALLOW.buildBizException(new Object[]{nowStatus.desc});
        }
    }

    public void executeTransform(PcpOrderReqDto pcpOrderReqDto) {
        CustomerRespDto pcpCustomerRespDto = this.dataQueryService.queryAndCheckPCPCustomerRespDto(pcpOrderReqDto.getCustomerCode());
        OrgAdvDetailRespDto orgAdvDetailRespDto = this.dataQueryService.queryEasOrgDto(pcpOrderReqDto.getEasOrgId());
        PcpOrderChannelRespDto pcpOrderChannelRespDto = null;
        if (Objects.isNull(pcpOrderReqDto.getOrderChannelId())) {
            pcpOrderChannelRespDto = this.dataQueryService.queryPcpOrderChannelRespDto(pcpOrderReqDto.getOrderChannelCode());
        }
        if (!Objects.equals(pcpOrderReqDto.getOrderType(), SaleOrderTypeEnum.SHOPPE_ORDER.getType()) || !Objects.equals(pcpOrderReqDto.getOrderSource(), PlatformOrderSource.SOURCE_1.getCode())) {
            this.queryAndSetShareWarehouseInfo(pcpOrderReqDto);
        }
        Map<String, PcpItemRespDto> csItemRespDtoMap = this.dataQueryService.queryAndCheckItemInfo(pcpOrderReqDto.getItemReqDtoList().stream().map(PlatformOrderItemReqDto::getSkuCode).distinct().collect(Collectors.toList()));
        HashMap<String, PcpRegionRespDto> pcpRegionRespDtoMap = new HashMap();
        if (!Objects.equals(pcpOrderReqDto.getOrderType(), SaleOrderTypeEnum.SHOPPE_ORDER.getType()) || !Objects.equals(pcpOrderReqDto.getOrderSource(), PlatformOrderSource.SOURCE_1.getCode())) {
            pcpRegionRespDtoMap = this.dataQueryService.queryAndCheckOrderAddressInfo(pcpOrderReqDto.getPlatformOrderAddrReqDto().getProvinceCode(), pcpOrderReqDto.getPlatformOrderAddrReqDto().getCityCode(), pcpOrderReqDto.getPlatformOrderAddrReqDto().getCountyCode());
        }
        this.saveTransformInfo(pcpOrderReqDto, pcpOrderChannelRespDto, csItemRespDtoMap, pcpCustomerRespDto, orgAdvDetailRespDto, pcpRegionRespDtoMap);
    }

    private void queryAndSetWarehouseInfo(PcpOrderReqDto pcpOrderReqDto) {
        try {
            PlatformAssert.notBlank((String)pcpOrderReqDto.getChannelWarehouseCode(), (PlatformExceptionCode)PlatformExceptionCode.CHECK_PARAM_CHANNEL_WAREHOUSE_CODE_NULL, (String[])new String[0]);
            PlatformAssert.notBlank((String)pcpOrderReqDto.getDefaultWarehouseCode(), (PlatformExceptionCode)PlatformExceptionCode.CHECK_PARAM_DEFAULT_WAREHOUSE_CODE_NULL, (String[])new String[0]);
            ChannelWarehouseRespDto csChannelWarehouseRespDto = (ChannelWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.channelWarehouseQueryApi.queryByWarehouseCode(pcpOrderReqDto.getChannelWarehouseCode()));
            PlatformAssert.notNull((Object)csChannelWarehouseRespDto, (PlatformExceptionCode)PlatformExceptionCode.QUERY_ORDER_INFO_IS_NULL, (String[])new String[]{"\u6e20\u9053\u4ed3"});
            PlatformAssert.needEquals((Object)csChannelWarehouseRespDto.getWarehouseStatus(), (Object)CsValidFlagEnum.ENABLE.getCode(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{csChannelWarehouseRespDto.getWarehouseCode() + "\u6e20\u9053\u4ed3\u5e93\u672a\u542f\u7528"});
            pcpOrderReqDto.setChannelWarehouseId(csChannelWarehouseRespDto.getId());
            pcpOrderReqDto.setChannelWarehouseName(csChannelWarehouseRespDto.getWarehouseName());
            CsRelWarehouseQueryDto queryLogicReqDto = new CsRelWarehouseQueryDto();
            queryLogicReqDto.setWarehouseCode(pcpOrderReqDto.getDefaultWarehouseCode());
            queryLogicReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
            List csRelWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csRelWarehouseQueryApi.queryWarehouseByConditions(queryLogicReqDto));
            PlatformAssert.notEmpty((Collection)csRelWarehouseRespDtos, (PlatformExceptionCode)PlatformExceptionCode.QUERY_ORDER_INFO_IS_NULL, (String[])new String[]{"\u9ed8\u8ba4\u903b\u8f91\u4ed3"});
            CsLogicWarehouseDetailRespDto csLogicWarehouseDetailRespDto = (CsLogicWarehouseDetailRespDto)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryDetailById(((CsRelWarehouseRespDto)csRelWarehouseRespDtos.get(0)).getWarehouseId()));
            PlatformAssert.needEquals((Object)csLogicWarehouseDetailRespDto.getWarehouseStatus(), (Object)CsValidFlagEnum.ENABLE.getCode(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{csLogicWarehouseDetailRespDto.getWarehouseCode() + "\u903b\u8f91\u4ed3\u5e93\u672a\u542f\u7528"});
            PlatformAssert.needEquals((Object)csLogicWarehouseDetailRespDto.getWarehouseQuality(), (Object)CsLogicWarehouseQualityEnum.QUALIFIED.getCode(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{csLogicWarehouseDetailRespDto.getWarehouseCode() + "\u903b\u8f91\u4ed3\u5e93\u672a\u5408\u683c"});
            pcpOrderReqDto.setDefaultWarehouseId(csLogicWarehouseDetailRespDto.getId());
            pcpOrderReqDto.setDefaultWarehouseName(csLogicWarehouseDetailRespDto.getWarehouseName());
            CsRelWarehouseQueryDto queryLogicRefReqDto = new CsRelWarehouseQueryDto();
            queryLogicRefReqDto.setWarehouseCode(pcpOrderReqDto.getDefaultWarehouseCode());
            queryLogicRefReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
            queryLogicRefReqDto.setRefWarehouseClassify(CsWarehouseClassifyEnum.CHANNEL.getCode());
            List newRelWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csRelWarehouseQueryApi.queryWarehouseByConditions(queryLogicRefReqDto));
            logger.info("\u3010\u67e5\u8be2\u4ed3\u5e93\u5173\u7cfb\u3011{}", (Object)JSON.toJSONString((Object)newRelWarehouseRespDtos));
            PlatformAssert.notEmpty((Collection)newRelWarehouseRespDtos, (PlatformExceptionCode)PlatformExceptionCode.QUERY_WAREHOUSE_REL_IS_NULL, (String[])new String[0]);
            PlatformAssert.notEmpty((Collection)newRelWarehouseRespDtos.stream().filter(dto -> dto.getRefWarehouseCode().equals(pcpOrderReqDto.getChannelWarehouseCode())).collect(Collectors.toList()), (PlatformExceptionCode)PlatformExceptionCode.QUERY_WAREHOUSE_REL_IS_NULL, (String[])new String[0]);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u6821\u9a8c\u4ed3\u5e93\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage()});
        }
    }

    private void queryAndSetShareWarehouseInfo(PcpOrderReqDto pcpOrderReqDto) {
        if (Objects.equals(pcpOrderReqDto.getAllotType(), AllotTypeEnum.MAIYOU_CC_ALLOT.getType()) || Objects.equals(pcpOrderReqDto.getAllotType(), AllotTypeEnum.MAIYOU_CC_ALLOT_OUT.getType())) {
            return;
        }
        try {
            PlatformAssert.notBlank((String)pcpOrderReqDto.getChannelWarehouseCode(), (PlatformExceptionCode)PlatformExceptionCode.CHECK_PARAM_CHANNEL_WAREHOUSE_CODE_NULL, (String[])new String[0]);
            List<ChannelWarehouseRespDto> channelWarehouseRespDtoList = this.getChannelWarehouseCache(pcpOrderReqDto.getChannelWarehouseCode());
            PlatformAssert.notEmpty(channelWarehouseRespDtoList, (PlatformExceptionCode)PlatformExceptionCode.QUERY_ORDER_INFO_IS_NULL, (String[])new String[]{"\u6e20\u9053\u4ed3"});
            ChannelWarehouseRespDto channelWarehouseRespDto = channelWarehouseRespDtoList.get(0);
            PlatformAssert.needEquals((Object)channelWarehouseRespDto.getWarehouseStatus(), (Object)CsValidFlagEnum.ENABLE.getCode(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{channelWarehouseRespDto.getWarehouseCode() + "\u6e20\u9053\u4ed3\u5e93\u672a\u542f\u7528"});
            pcpOrderReqDto.setChannelWarehouseId(channelWarehouseRespDto.getId());
            pcpOrderReqDto.setChannelWarehouseName(channelWarehouseRespDto.getWarehouseName());
            if (StringUtils.isNotEmpty((CharSequence)pcpOrderReqDto.getDefaultWarehouseCode())) {
                CsRelWarehouseQueryDto queryLogicReqDto = new CsRelWarehouseQueryDto();
                queryLogicReqDto.setWarehouseCode(pcpOrderReqDto.getDefaultWarehouseCode());
                queryLogicReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
                List csRelWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.csRelWarehouseQueryApi.queryWarehouseByConditions(queryLogicReqDto));
                PlatformAssert.notEmpty((Collection)csRelWarehouseRespDtos, (PlatformExceptionCode)PlatformExceptionCode.QUERY_ORDER_INFO_IS_NULL, (String[])new String[]{"\u9ed8\u8ba4\u903b\u8f91\u4ed3"});
                CsLogicWarehouseDetailRespDto csLogicWarehouseDetailRespDto = (CsLogicWarehouseDetailRespDto)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryDetailById(((CsRelWarehouseRespDto)csRelWarehouseRespDtos.get(0)).getWarehouseId()));
                PlatformAssert.needEquals((Object)csLogicWarehouseDetailRespDto.getWarehouseStatus(), (Object)CsValidFlagEnum.ENABLE.getCode(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{csLogicWarehouseDetailRespDto.getWarehouseCode() + "\u903b\u8f91\u4ed3\u5e93\u672a\u542f\u7528"});
                if (!Objects.equals(SaleOrderTypeEnum.CLAIM_POSTING.getType(), pcpOrderReqDto.getOrderType()) && !Objects.equals(SaleOrderTypeEnum.CLAIM_REISSUE.getType(), pcpOrderReqDto.getOrderType())) {
                    PlatformAssert.needEquals((Object)csLogicWarehouseDetailRespDto.getWarehouseQuality(), (Object)CsLogicWarehouseQualityEnum.QUALIFIED.getCode(), (PlatformExceptionCode)PlatformExceptionCode.NORMAL_EXCEPTION, (String[])new String[]{csLogicWarehouseDetailRespDto.getWarehouseCode() + "\u903b\u8f91\u4ed3\u5e93\u672a\u5408\u683c"});
                }
                pcpOrderReqDto.setDefaultWarehouseId(csLogicWarehouseDetailRespDto.getId());
                pcpOrderReqDto.setDefaultWarehouseName(csLogicWarehouseDetailRespDto.getWarehouseName());
                List logicWarehouseList = channelWarehouseRespDto.getLogicWarehouseList();
                logger.info("\u3010\u67e5\u8be2\u4ed3\u5e93\u5173\u7cfb\u3011{}", (Object)JSON.toJSONString((Object)logicWarehouseList));
                PlatformAssert.notEmpty((Collection)logicWarehouseList, (PlatformExceptionCode)PlatformExceptionCode.QUERY_WAREHOUSE_REL_IS_NULL, (String[])new String[0]);
                PlatformAssert.notEmpty((Collection)logicWarehouseList.stream().filter(dto -> dto.getWarehouseCode().equals(pcpOrderReqDto.getDefaultWarehouseCode())).collect(Collectors.toList()), (PlatformExceptionCode)PlatformExceptionCode.QUERY_WAREHOUSE_REL_IS_NULL, (String[])new String[0]);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u6821\u9a8c\u4ed3\u5e93\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage()});
        }
    }

    private PcpShopRespDto queryAndCheckShopChannelInfo(String shopCode) {
        PcpShopRespDto shopRespDto = null;
        try {
            PcpShopReqDto shopReqDto = new PcpShopReqDto();
            shopReqDto.setShopCode(shopCode);
            List shopRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryDetail(shopReqDto));
            if (CollectionUtils.isEmpty((Collection)shopRespDtos)) {
                throw PlatformExceptionCode.QUERY_SHOP_INFO_IS_NULL.buildBizException(new Object[]{shopCode});
            }
            if (shopRespDtos.size() > 1) {
                throw PlatformExceptionCode.QUERY_SHOP_INFO_NUM_WRONG.buildBizException(new Object[]{shopCode, String.valueOf(shopRespDtos.size())});
            }
            shopRespDto = (PcpShopRespDto)shopRespDtos.get(0);
        }
        catch (BizException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw PlatformExceptionCode.QUERY_SHOP_INFO_FAIL.buildBizException(new Object[]{shopCode});
        }
        return shopRespDto;
    }

    private String executeSaveSaleOrder(PcpOrderReqDto pcpOrderReqDto) {
        try {
            logger.info("\u6267\u884c\u4fdd\u5b58\u9500\u552e\u8ba2\u5355\u63a5\u53e3\u5e76\u8fd4\u56de\u9500\u552e\u8ba2\u5355\u53f7\uff1a{}", (Object)JSON.toJSONString((Object)pcpOrderReqDto));
            BizSaleOrderReqDto bizSaleOrderReqDto = new BizSaleOrderReqDto();
            CubeBeanUtils.copyProperties((Object)bizSaleOrderReqDto, (Object)pcpOrderReqDto, (String[])new String[0]);
            SaleOrderAddrReqDto saleOrderAddrReqDto = new SaleOrderAddrReqDto();
            CubeBeanUtils.copyProperties((Object)saleOrderAddrReqDto, (Object)pcpOrderReqDto.getPlatformOrderAddrReqDto(), (String[])new String[0]);
            ArrayList<SaleOrderItemReqDto> saleOrderItemReqDtos = new ArrayList<SaleOrderItemReqDto>();
            BigDecimal totalDiscountAmount = BigDecimal.ZERO;
            BigDecimal spTotalItemAmount = BigDecimal.ZERO;
            BigDecimal spTotalItemNum = BigDecimal.ZERO;
            for (PlatformOrderItemReqDto platformOrderItemReqDto : pcpOrderReqDto.getItemReqDtoList()) {
                if ((Objects.equals(SaleOrderTypeEnum.COMPENSATION_ORDER.getType(), pcpOrderReqDto.getOrderType()) || Objects.equals(SaleOrderTypeEnum.COMPENSATION_NOT_ORDER.getType(), pcpOrderReqDto.getOrderType()) || Objects.equals(SaleOrderTypeEnum.CLAIM_POSTING.getType(), pcpOrderReqDto.getOrderType()) || Objects.equals(SaleOrderTypeEnum.CLAIM_REISSUE.getType(), pcpOrderReqDto.getOrderType())) && Objects.equals(platformOrderItemReqDto.getReplacementFlag(), YesOrNoEnum.NO.getType())) continue;
                SaleOrderItemReqDto saleOrderItemReqDto = new SaleOrderItemReqDto();
                CubeBeanUtils.copyProperties((Object)saleOrderItemReqDto, (Object)platformOrderItemReqDto, (String[])new String[0]);
                if (Objects.equals(SaleOrderTypeEnum.CLAIM_POSTING.getType(), pcpOrderReqDto.getOrderType()) || Objects.equals(SaleOrderTypeEnum.CLAIM_REISSUE.getType(), pcpOrderReqDto.getOrderType())) {
                    saleOrderItemReqDto.setClaimPrice(platformOrderItemReqDto.getSalePrice());
                    saleOrderItemReqDto.setSettleRate(platformOrderItemReqDto.getEasPromotionActivityAmount());
                    saleOrderItemReqDto.setEasPromotionActivityAmount(null);
                    saleOrderItemReqDto.setEasOrderTotalAmount(null);
                }
                saleOrderItemReqDto.setDiscountAmount(platformOrderItemReqDto.getSettleAmount());
                saleOrderItemReqDto.setVolume(BigDecimal.ZERO);
                saleOrderItemReqDto.setWeight(BigDecimal.ZERO);
                if (StringUtils.isNotEmpty((CharSequence)platformOrderItemReqDto.getExtension())) {
                    String extension = platformOrderItemReqDto.getExtension();
                    Map map = (Map)JSON.parseObject((String)extension, Map.class);
                    if (map.containsKey("volume") && Objects.nonNull(map.get("volume"))) {
                        saleOrderItemReqDto.setVolume(new BigDecimal(map.get("volume").toString()));
                    }
                    if (map.containsKey("weight") && Objects.nonNull(map.get("weight"))) {
                        saleOrderItemReqDto.setWeight(new BigDecimal(map.get("weight").toString()));
                    }
                    if (map.containsKey("weightUnit") && Objects.nonNull(map.get("weightUnit"))) {
                        saleOrderItemReqDto.setWeightUnit(map.get("weightUnit").toString());
                    }
                }
                saleOrderItemReqDtos.add(saleOrderItemReqDto);
                pcpOrderReqDto.setRdc(platformOrderItemReqDto.getRdc());
                totalDiscountAmount = totalDiscountAmount.add(Optional.ofNullable(saleOrderItemReqDto.getDiscountAmount()).orElse(BigDecimal.ZERO));
                spTotalItemNum = spTotalItemNum.add(Optional.ofNullable(saleOrderItemReqDto.getItemNum()).orElse(BigDecimal.ZERO));
                spTotalItemAmount = spTotalItemAmount.add(Optional.ofNullable(saleOrderItemReqDto.getLineAmount()).orElse(BigDecimal.ZERO));
            }
            bizSaleOrderReqDto.setDiscountAmount(totalDiscountAmount);
            bizSaleOrderReqDto.setItemList(saleOrderItemReqDtos);
            bizSaleOrderReqDto.setPlatformOrderId(pcpOrderReqDto.getId());
            bizSaleOrderReqDto.setOrderAddrReqDto(saleOrderAddrReqDto);
            bizSaleOrderReqDto.setChannelName(pcpOrderReqDto.getOrderChannelName());
            bizSaleOrderReqDto.setChannelCode(pcpOrderReqDto.getOrderChannelCode());
            bizSaleOrderReqDto.setChannelId(pcpOrderReqDto.getOrderChannelId());
            bizSaleOrderReqDto.setDefaultLogicalWarehouseCode(pcpOrderReqDto.getDefaultWarehouseCode());
            bizSaleOrderReqDto.setDefaultLogicalWarehouseId(pcpOrderReqDto.getDefaultWarehouseId());
            bizSaleOrderReqDto.setDefaultLogicalWarehouseName(pcpOrderReqDto.getDefaultWarehouseName());
            bizSaleOrderReqDto.setAllowSplitFlag(pcpOrderReqDto.getCanSplitFlag());
            bizSaleOrderReqDto.setStoragePlace(pcpOrderReqDto.getStoragePlace());
            bizSaleOrderReqDto.setEasOrderNo(pcpOrderReqDto.getSapPlatformOrderNo());
            if (Objects.equals(SaleOrderTypeEnum.COMPENSATION_ORDER.getType(), pcpOrderReqDto.getOrderType()) || Objects.equals(SaleOrderTypeEnum.COMPENSATION_NOT_ORDER.getType(), pcpOrderReqDto.getOrderType()) || Objects.equals(SaleOrderTypeEnum.CLAIM_POSTING.getType(), pcpOrderReqDto.getOrderType()) || Objects.equals(SaleOrderTypeEnum.CLAIM_REISSUE.getType(), pcpOrderReqDto.getOrderType())) {
                bizSaleOrderReqDto.setGoodsTotalNum(spTotalItemNum);
                bizSaleOrderReqDto.setGoodsTotalAmount(spTotalItemAmount);
            }
            if (PlatformOrderSource.SOURCE_0.getCode() == pcpOrderReqDto.getOrderSource().intValue() && (Objects.equals(SaleOrderTypeEnum.CLAIM_POSTING.getType(), pcpOrderReqDto.getOrderType()) || Objects.equals(SaleOrderTypeEnum.CLAIM_REISSUE.getType(), pcpOrderReqDto.getOrderType()))) {
                bizSaleOrderReqDto.setLogicalWarehouseId(pcpOrderReqDto.getDefaultWarehouseId());
                bizSaleOrderReqDto.setLogicalWarehouseCode(pcpOrderReqDto.getDefaultWarehouseCode());
                bizSaleOrderReqDto.setLogicalWarehouseName(pcpOrderReqDto.getDefaultWarehouseName());
            }
            if (Objects.equals(SaleOrderTypeEnum.BAIJIAN_DIRECT_SALES.getType(), pcpOrderReqDto.getOrderType())) {
                bizSaleOrderReqDto.setEasOrderNo(pcpOrderReqDto.getPlatformOrderNo());
                bizSaleOrderReqDto.setEasVerifyTime(pcpOrderReqDto.getPlatformCreateTime());
            }
            ServiceContext.getContext().setAttachment("yes.req.userCode", pcpOrderReqDto.getOutCreatePerson());
            logger.info("\u3010\u8f6c\u5355\u5b8c\u6210-\u8bf7\u6c42\u751f\u6210\u9500\u552e\u8ba2\u5355\u3011bizSaleOrderReqDto={}", (Object)JSON.toJSONString((Object)bizSaleOrderReqDto));
            RestResponse addResult = this.saleOrderApi.addSaleOrder(bizSaleOrderReqDto);
            if (addResult.getResultCode().equals(PcpTradeExceptionCode.MUTIL_SALE_ORDER_EXCEPTION.getCode())) {
                return (String)addResult.getData();
            }
            return (String)RestResponseHelper.extractData((RestResponse)addResult);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw PlatformExceptionCode.OPT_ORDER_SALE_ORDER_FAIL.buildBizException(new Object[]{e.getMessage()});
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveTransformInfo(PcpOrderReqDto pcpOrderReqDto, PcpOrderChannelRespDto pcpOrderChannelRespDto, Map<String, PcpItemRespDto> csItemRespDtoMap, CustomerRespDto pcpCustomerRespDto, OrgAdvDetailRespDto organizationDto, Map<String, PcpRegionRespDto> pcpRegionRespDtoMap) {
        PlatformOrderReqDto platformOrderReqDto = new PlatformOrderReqDto();
        platformOrderReqDto.setId(pcpOrderReqDto.getId());
        if (Objects.nonNull(pcpOrderChannelRespDto)) {
            platformOrderReqDto.setOrderChannelId(pcpOrderChannelRespDto.getId());
            platformOrderReqDto.setOrderChannelCode(pcpOrderChannelRespDto.getChannelCode());
            platformOrderReqDto.setOrderChannelName(pcpOrderChannelRespDto.getChannelName());
        }
        platformOrderReqDto.setCustomerCode(pcpCustomerRespDto.getCode());
        platformOrderReqDto.setCustomerId(pcpCustomerRespDto.getId());
        platformOrderReqDto.setCustomerName(pcpCustomerRespDto.getName());
        platformOrderReqDto.setEasCode(pcpCustomerRespDto.getEasCode());
        pcpOrderReqDto.setEasCode(pcpCustomerRespDto.getEasCode());
        platformOrderReqDto.setThirdPartyId(pcpCustomerRespDto.getThirdPartyId());
        platformOrderReqDto.setOrganizationId(organizationDto.getId());
        platformOrderReqDto.setOrganizationName(organizationDto.getName());
        platformOrderReqDto.setOrganizationCode(organizationDto.getCode());
        platformOrderReqDto.setChannelWarehouseId(pcpOrderReqDto.getChannelWarehouseId());
        platformOrderReqDto.setChannelWarehouseName(pcpOrderReqDto.getChannelWarehouseName());
        platformOrderReqDto.setDefaultWarehouseId(pcpOrderReqDto.getDefaultWarehouseId());
        platformOrderReqDto.setDefaultWarehouseName(pcpOrderReqDto.getDefaultWarehouseName());
        if (StringUtils.isEmpty((CharSequence)platformOrderReqDto.getSendDate())) {
            platformOrderReqDto.setSendDate(DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd"));
        }
        if (StringUtils.isEmpty((CharSequence)platformOrderReqDto.getDeliveryDate())) {
            platformOrderReqDto.setDeliveryDate(DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd"));
        }
        if (null != pcpRegionRespDtoMap && !pcpRegionRespDtoMap.isEmpty()) {
            pcpOrderReqDto.getPlatformOrderAddrReqDto().setCity((String)Optional.ofNullable(pcpRegionRespDtoMap.get(pcpOrderReqDto.getPlatformOrderAddrReqDto().getCityCode())).map(PcpRegionRespDto::getName).orElse(null));
            pcpOrderReqDto.getPlatformOrderAddrReqDto().setProvince((String)Optional.ofNullable(pcpRegionRespDtoMap.get(pcpOrderReqDto.getPlatformOrderAddrReqDto().getProvinceCode())).map(PcpRegionRespDto::getName).orElse(null));
            pcpOrderReqDto.getPlatformOrderAddrReqDto().setCounty((String)Optional.ofNullable(pcpRegionRespDtoMap.get(pcpOrderReqDto.getPlatformOrderAddrReqDto().getCountyCode())).map(PcpRegionRespDto::getName).orElse(null));
        }
        this.platformOrderService.modifyPlatformOrder(platformOrderReqDto);
        PlatformOrderAddrRespDto platformOrderAddrRespDto = this.platformOrderAddrService.queryByOrderId(pcpOrderReqDto.getId());
        PlatformOrderAddrReqDto platformOrderAddrReqDto = new PlatformOrderAddrReqDto();
        CubeBeanUtils.copyProperties((Object)platformOrderAddrReqDto, (Object)pcpOrderReqDto.getPlatformOrderAddrReqDto(), (String[])new String[0]);
        platformOrderAddrReqDto.setOrderId(null);
        platformOrderAddrReqDto.setId(platformOrderAddrRespDto.getId());
        platformOrderAddrReqDto.setOrganizationId(organizationDto.getId());
        platformOrderAddrReqDto.setOrganizationCode(organizationDto.getCode());
        platformOrderAddrReqDto.setOrganizationName(organizationDto.getName());
        this.platformOrderAddrService.modifyPlatformOrderAddr(platformOrderAddrReqDto);
        List<PlatformOrderItemRespDto> platformOrderItemRespDtos = this.platformOrderItemService.queryListByOrderId(pcpOrderReqDto.getId());
        LinkedList savePlatformOrderItems = Lists.newLinkedList();
        platformOrderItemRespDtos.forEach(dto -> {
            PcpItemRespDto csItemRespDto = (PcpItemRespDto)csItemRespDtoMap.get(dto.getSkuCode());
            if (csItemRespDto == null) {
                throw PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_INFO_HAD_NULL.buildBizException(new Object[]{dto.getSkuCode()});
            }
            if (csItemRespDto.getItemStatus() != null && csItemRespDto.getItemStatus() != 2L) {
                throw PlatformExceptionCode.CHECK_ORDER_INFO_ITEM_LIST_INFO_STATUS_0.buildBizException(new Object[]{dto.getSkuCode()});
            }
            PlatformOrderItemReqDto tempDto = new PlatformOrderItemReqDto();
            CubeBeanUtils.copyProperties((Object)tempDto, (Object)csItemRespDto, (String[])new String[0]);
            tempDto.setItemCode(csItemRespDto.getCode());
            tempDto.setItemName(csItemRespDto.getName());
            tempDto.setSkuCode(csItemRespDto.getLongCode());
            tempDto.setItemNum(dto.getItemNum());
            tempDto.setId(dto.getId());
            tempDto.setItemId(csItemRespDto.getId());
            tempDto.setOrganizationId(organizationDto.getId());
            tempDto.setOrganizationCode(organizationDto.getCode());
            tempDto.setOrganizationName(organizationDto.getName());
            HashMap<String, Object> itemSkuMap = new HashMap<String, Object>();
            if (StringUtils.isNotEmpty((CharSequence)dto.getExtension())) {
                Map map = (Map)JSON.parseObject((String)dto.getExtension(), Map.class);
                itemSkuMap.putAll(map);
            }
            BigDecimal itemVolume = BigDecimal.ZERO;
            if (Objects.nonNull(csItemRespDto.getVolume())) {
                itemVolume = csItemRespDto.getVolume().multiply(dto.getItemNum());
            }
            BigDecimal itemWeight = BigDecimal.ZERO;
            if (Objects.nonNull(csItemRespDto.getGrossWeight())) {
                itemWeight = csItemRespDto.getGrossWeight().multiply(dto.getItemNum());
            }
            itemSkuMap.put("volume", itemVolume);
            itemSkuMap.put("weight", itemWeight);
            itemSkuMap.put("weightUnit", csItemRespDto.getGrossWeightUnit());
            tempDto.setExtFields(itemSkuMap);
            savePlatformOrderItems.add(tempDto);
            this.platformOrderItemService.modifyPlatformOrderItem(tempDto);
        });
    }

    public MessageResponse sendCspSpMq(String platformOrderNo, CspClaimOrderStatusEnum cspClaimOrderStatusEnum) {
        CSPUpdateCspClaimOrderReqDto cspUpdateCspClaimOrderReqDto = new CSPUpdateCspClaimOrderReqDto();
        cspUpdateCspClaimOrderReqDto.setOaSheetNo(platformOrderNo);
        cspUpdateCspClaimOrderReqDto.setStatus(cspClaimOrderStatusEnum.getType());
        MessageVo vo = new MessageVo();
        vo.setData((Object)cspUpdateCspClaimOrderReqDto);
        logger.info("\u7269\u6d41\u5546\u7d22\u8d54\u8ba2\u5355\u53d1\u9001\u66f4\u65b0csp\u8ba2\u5355\u72b6\u6001MQ\uff1a{}", (Object)JSON.toJSONString((Object)vo));
        this.commonsMqService.sendSingleMessage("OP_EXTERNAL_TOPIC", "UPDATE_CSP_CLAIM_ORDER_STATUS", (Object)JSON.toJSONString((Object)vo));
        return MessageResponse.SUCCESS;
    }

    private List<ChannelWarehouseRespDto> getChannelWarehouseCache(String channelWarehouseCode) {
        String groupStr = "transform-channel";
        String key = "warehouseCode-" + channelWarehouseCode;
        String channelCodeStr = (String)this.cacheService.getCache(groupStr, key, String.class);
        if (StringUtils.isNotEmpty((CharSequence)channelCodeStr)) {
            List channelWarehouseRespDtos = JSON.parseArray((String)channelCodeStr, ChannelWarehouseRespDto.class);
            return channelWarehouseRespDtos;
        }
        HashSet codeSet = Sets.newHashSet((Object[])new String[]{channelWarehouseCode});
        List channelWarehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.channelWarehouseQueryApi.queryByCodes((Set)codeSet));
        if (CollectionUtils.isEmpty((Collection)channelWarehouseRespDtoList)) {
            return Lists.newArrayList();
        }
        this.cacheService.setCache(groupStr, key, JSON.toJSON((Object)channelWarehouseRespDtoList), 2400);
        return channelWarehouseRespDtoList;
    }
}

