/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.transform.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderAddrReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderAddrRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.exception.PlatformExceptionCode;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPlatformOrderAddrService;
import com.dtyunxi.yundt.cube.center.transform.dao.das.PlatformOrderAddrDas;
import com.dtyunxi.yundt.cube.center.transform.dao.eo.PlatformOrderAddrEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PlatformOrderAddrServiceImpl
implements IPlatformOrderAddrService {
    @Resource
    private PlatformOrderAddrDas platformOrderAddrDas;

    @Override
    public Long addPlatformOrderAddr(PlatformOrderAddrReqDto addReqDto) {
        PlatformOrderAddrEo platformOrderAddrEo = new PlatformOrderAddrEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)platformOrderAddrEo);
        this.platformOrderAddrDas.insert((BaseEo)platformOrderAddrEo);
        return platformOrderAddrEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyPlatformOrderAddr(PlatformOrderAddrReqDto modifyReqDto) {
        PlatformOrderAddrEo platformOrderAddrEo = new PlatformOrderAddrEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)platformOrderAddrEo);
        if (Objects.nonNull(modifyReqDto.getId())) {
            this.platformOrderAddrDas.updateSelective((BaseEo)platformOrderAddrEo);
        } else {
            if (Objects.isNull(modifyReqDto.getOrderId())) {
                throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"orderId \u4e3a\u7a7a"});
            }
            PlatformOrderAddrEo queryEo = new PlatformOrderAddrEo();
            queryEo.setOrderId(modifyReqDto.getOrderId());
            List orderAddrEos = this.platformOrderAddrDas.select((BaseEo)queryEo);
            if (!CollectionUtils.isEmpty((Collection)orderAddrEos)) {
                List idList = orderAddrEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                this.platformOrderAddrDas.logicDeleteByIds(idList);
            }
            this.platformOrderAddrDas.insert((BaseEo)platformOrderAddrEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePlatformOrderAddr(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.platformOrderAddrDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public PlatformOrderAddrRespDto queryById(Long id) {
        PlatformOrderAddrEo platformOrderAddrEo = (PlatformOrderAddrEo)this.platformOrderAddrDas.selectByPrimaryKey(id);
        if (platformOrderAddrEo == null) {
            return null;
        }
        PlatformOrderAddrRespDto platformOrderAddrRespDto = new PlatformOrderAddrRespDto();
        DtoHelper.eo2Dto((BaseEo)platformOrderAddrEo, (BaseVo)platformOrderAddrRespDto);
        return platformOrderAddrRespDto;
    }

    @Override
    public PageInfo<PlatformOrderAddrRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PlatformOrderAddrReqDto platformOrderAddrReqDto = (PlatformOrderAddrReqDto)JSON.parseObject((String)filter, PlatformOrderAddrReqDto.class);
        PlatformOrderAddrEo platformOrderAddrEo = new PlatformOrderAddrEo();
        DtoHelper.dto2Eo((BaseVo)platformOrderAddrReqDto, (BaseEo)platformOrderAddrEo);
        PageInfo eoPageInfo = this.platformOrderAddrDas.selectPage((BaseEo)platformOrderAddrEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, PlatformOrderAddrRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PlatformOrderAddrRespDto queryByOrderId(Long orderId) {
        PlatformOrderAddrEo queryEo = new PlatformOrderAddrEo();
        queryEo.setOrderId(orderId);
        PlatformOrderAddrEo platformOrderAddrEo = (PlatformOrderAddrEo)this.platformOrderAddrDas.selectOne((BaseEo)queryEo);
        PlatformOrderAddrRespDto platformOrderAddrRespDto = new PlatformOrderAddrRespDto();
        DtoHelper.eo2Dto((BaseEo)platformOrderAddrEo, (BaseVo)platformOrderAddrRespDto);
        return platformOrderAddrRespDto;
    }
}

