/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.transform.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.RChannelLogicWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.RChannelLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.YyjWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IRChannelLogicWarehouseService;
import com.dtyunxi.yundt.cube.center.transform.dao.das.EasChannelWarehouseDas;
import com.dtyunxi.yundt.cube.center.transform.dao.das.RChannelLogicWarehouseDas;
import com.dtyunxi.yundt.cube.center.transform.dao.eo.EasChannelWarehouseEo;
import com.dtyunxi.yundt.cube.center.transform.dao.eo.RChannelLogicWarehouseEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RChannelLogicWarehouseServiceImpl
implements IRChannelLogicWarehouseService {
    @Resource
    private RChannelLogicWarehouseDas rChannelLogicWarehouseDas;
    @Autowired
    private EasChannelWarehouseDas easChannelWarehouseDas;

    @Override
    public Long addRChannelLogicWarehouse(RChannelLogicWarehouseReqDto addReqDto) {
        RChannelLogicWarehouseEo rChannelLogicWarehouseEo = new RChannelLogicWarehouseEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)rChannelLogicWarehouseEo);
        this.rChannelLogicWarehouseDas.insert((BaseEo)rChannelLogicWarehouseEo);
        return rChannelLogicWarehouseEo.getId();
    }

    @Override
    public void modifyRChannelLogicWarehouse(RChannelLogicWarehouseReqDto modifyReqDto) {
        RChannelLogicWarehouseEo rChannelLogicWarehouseEo = new RChannelLogicWarehouseEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)rChannelLogicWarehouseEo);
        this.rChannelLogicWarehouseDas.updateSelective((BaseEo)rChannelLogicWarehouseEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRChannelLogicWarehouse(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.rChannelLogicWarehouseDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public RChannelLogicWarehouseRespDto queryById(Long id) {
        RChannelLogicWarehouseEo rChannelLogicWarehouseEo = (RChannelLogicWarehouseEo)this.rChannelLogicWarehouseDas.selectByPrimaryKey(id);
        RChannelLogicWarehouseRespDto rChannelLogicWarehouseRespDto = new RChannelLogicWarehouseRespDto();
        DtoHelper.eo2Dto((BaseEo)rChannelLogicWarehouseEo, (BaseVo)rChannelLogicWarehouseRespDto);
        return rChannelLogicWarehouseRespDto;
    }

    @Override
    public PageInfo<RChannelLogicWarehouseRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        RChannelLogicWarehouseReqDto rChannelLogicWarehouseReqDto = (RChannelLogicWarehouseReqDto)JSON.parseObject((String)filter, RChannelLogicWarehouseReqDto.class);
        RChannelLogicWarehouseEo rChannelLogicWarehouseEo = new RChannelLogicWarehouseEo();
        DtoHelper.dto2Eo((BaseVo)rChannelLogicWarehouseReqDto, (BaseEo)rChannelLogicWarehouseEo);
        PageInfo eoPageInfo = this.rChannelLogicWarehouseDas.selectPage((BaseEo)rChannelLogicWarehouseEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, RChannelLogicWarehouseRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<YyjWarehouseRespDto> queryYyjChannelAndLogicWarehouseByThirdOrgIds(List<String> thirdOrgIds) {
        ArrayList list = Lists.newArrayList();
        LambdaQueryWrapper channelQueryWapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)channelQueryWapper.in(EasChannelWarehouseEo::getThirdOrgId, thirdOrgIds)).eq(BaseEo::getDr, (Object)0);
        List channelWarehouseEos = this.easChannelWarehouseDas.list((Wrapper)channelQueryWapper);
        if (CollectionUtils.isNotEmpty((Collection)channelWarehouseEos)) {
            LambdaQueryWrapper logicQueryWapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)logicQueryWapper.in(RChannelLogicWarehouseEo::getThirdOrgId, thirdOrgIds)).eq(BaseEo::getDr, (Object)0)).eq(RChannelLogicWarehouseEo::getWarehouseType, (Object)2);
            List logicWarehouseEos = this.rChannelLogicWarehouseDas.list((Wrapper)logicQueryWapper);
            Map logicMap = logicWarehouseEos.stream().collect(Collectors.toMap(RChannelLogicWarehouseEo::getThirdOrgId, Function.identity()));
            for (EasChannelWarehouseEo channelWarehouseEo : channelWarehouseEos) {
                YyjWarehouseRespDto yyjWarehouseRespDto = new YyjWarehouseRespDto();
                yyjWarehouseRespDto.setThirdOrgId(channelWarehouseEo.getThirdOrgId());
                yyjWarehouseRespDto.setThirdOrgName(channelWarehouseEo.getThirdOrgName());
                yyjWarehouseRespDto.setChannelWarehouseCode(channelWarehouseEo.getChannelWarehouseCode());
                yyjWarehouseRespDto.setChannelWarehouseName(channelWarehouseEo.getChannelWarehouseName());
                RChannelLogicWarehouseEo rChannelLogicWarehouseEo = (RChannelLogicWarehouseEo)logicMap.get(channelWarehouseEo.getThirdOrgId());
                if (rChannelLogicWarehouseEo != null) {
                    yyjWarehouseRespDto.setLogicWarehouseCode(rChannelLogicWarehouseEo.getLogicWarehouseCode());
                    yyjWarehouseRespDto.setLogicWarehouseName(rChannelLogicWarehouseEo.getLogicWarehouseName());
                }
                list.add(yyjWarehouseRespDto);
            }
        }
        return list;
    }
}

