package com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

@ApiModel(value = "ActivityAnalyeByPagePageReqDto", description = "流量分析-页面访问分析分页请求dto")
public class ActivityAnalyeByPagePageReqDto extends BasePageReqDto{
    @ApiModelProperty(name = "timeType", value = "统计时间类型（customize：自定义，day：日，week：周，month：月）")
    @NotNull(message = "统计时间类型不能为空")
    private String timeType;

    @ApiModelProperty(name = "startTime", value = "开始时间")
    @NotNull(message = "开始时间不能为空")
    private String startTime;

    @ApiModelProperty(name = "endTime", value = "结束时间")
    @NotNull(message = "结束时间不能为空")
    private String endTime;

    @ApiModelProperty(name = "sortField", value = "排序字段(pv:浏览量,uv:访客量,totalPvTd:累计浏览量,totalPvPercentage:累计浏览量占比,totalUvTd:累计访客量,totalUvPercentage:累计访客量占比)")
    private String sortField;

    @ApiModelProperty(name = "sortMethod", value = "排序方式(1:升序,2:降序)")
    private Integer sortMethod;

    public String getTimeType() {
        return timeType;
    }

    public void setTimeType(String timeType) {
        this.timeType = timeType;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getSortField() {
        return sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public Integer getSortMethod() {
        return sortMethod;
    }

    public void setSortMethod(Integer sortMethod) {
        this.sortMethod = sortMethod;
    }
}
