package com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Max;

@ApiModel(value = "BaseReqPageDto", description = "基础分页请求")
public class BasePageReqDto extends BaseReqDto {

    /**
     * 分页大小
     */
    @Max(value = 99999,message = "页大小不能超过99999")
    @ApiModelProperty(name = "pageSize", value = "分页大小")
    private int pageSize = 20;
    /**
     * 当前页码
     */
    @ApiModelProperty(name = "pageNum", value = "当前页码")
    private int pageNum = 1;

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageNum() {
        return pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }
}
