package com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

@ApiModel(value = "ItemSalesDetailReqDto", description = "商品分析销售明细请求dto")
public class ItemSalesDetailReqDto extends BasePageReqDto{
    @ApiModelProperty(name = "sellerId", value = "商家ID")
    private Long sellerId;

    @ApiModelProperty(name = "shopType", value = "店铺类型")
    private Integer shopType;

    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;

    @ApiModelProperty(name = "itemName", value = "商品名称（模糊匹配）")
    private String itemName;

    @ApiModelProperty(name = "timeType", value = "统计时间类型（customize：自定义，day：日，week：周，month：月）")
    @NotNull(message = "统计时间类型不能为空")
    private String timeType;

    @ApiModelProperty(name = "startTime", value = "开始时间")
    @NotNull(message = "开始时间不能为空")
    private String startTime;

    @ApiModelProperty(name = "endTime", value = "结束时间")
    @NotNull(message = "结束时间不能为空")
    private String endTime;

    @ApiModelProperty(name = "sortField", value = "排序字段(pv:访问量,add_cart_cust_cnt:加购人数,paid_item_num：支付商品件数(销量),paid_amt:支付金额,succ_refund_item_num:成功退货/退款商品件数(退款件数),succ_refund_amt:成功退款金额,visit_order_conv_rate:浏览下单转化率(下单转化率),order_pay_conv_rate:下单支付转化率,visit_pay_conv_rate:支付转化率,refund_rate:退款率)")
    private String sortField;

    @ApiModelProperty(name = "sortMethod", value = "排序方式(1:升序,2:降序)")
    private Integer sortMethod;

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Integer getShopType() {
        return shopType;
    }

    public void setShopType(Integer shopType) {
        this.shopType = shopType;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getTimeType() {
        return timeType;
    }

    public void setTimeType(String timeType) {
        this.timeType = timeType;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getSortField() {
        return sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public Integer getSortMethod() {
        return sortMethod;
    }

    public void setSortMethod(Integer sortMethod) {
        this.sortMethod = sortMethod;
    }
}
