package com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

@ApiModel(value = "ItemSalesDetailRespDto", description = "商品分析销售明细返回dto")
public class ItemSalesDetailRespDto {
    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "pv", value = "访问量")
    private Long pv;

    @ApiModelProperty(name = "addCartCustCnt", value = "加购人数")
    private Long addCartCustCnt;

    @ApiModelProperty(name = "paidItemNum", value = "支付商品件数(销量)")
    private Long paidItemNum;

    @ApiModelProperty(name = "paidAmt", value = "支付金额")
    private BigDecimal paidAmt;

    @ApiModelProperty(name = "succRefundItemNum", value = "成功退货/退款商品件数(退款件数)")
    private Long succRefundItemNum;

    @ApiModelProperty(name = "succRefundAmt", value = "成功退款金额")
    private BigDecimal succRefundAmt;

    @ApiModelProperty(name = "visitOrderConvRate", value = "浏览下单转化率(下单转化率)")
    private BigDecimal visitOrderConvRate;

    @ApiModelProperty(name = "orderPayConvRate", value = "下单支付转化率")
    private BigDecimal orderPayConvRate;

    @ApiModelProperty(name = "visitPayConvRate", value = "支付转化率")
    private BigDecimal visitPayConvRate;

    @ApiModelProperty(name = "refundRate", value = "退款率")
    private BigDecimal refundRate;

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Long getPv() {
        return pv;
    }

    public void setPv(Long pv) {
        this.pv = pv;
    }

    public Long getAddCartCustCnt() {
        return addCartCustCnt;
    }

    public void setAddCartCustCnt(Long addCartCustCnt) {
        this.addCartCustCnt = addCartCustCnt;
    }

    public Long getPaidItemNum() {
        return paidItemNum;
    }

    public void setPaidItemNum(Long paidItemNum) {
        this.paidItemNum = paidItemNum;
    }

    public BigDecimal getPaidAmt() {
        return paidAmt;
    }

    public void setPaidAmt(BigDecimal paidAmt) {
        this.paidAmt = paidAmt;
    }

    public Long getSuccRefundItemNum() {
        return succRefundItemNum;
    }

    public void setSuccRefundItemNum(Long succRefundItemNum) {
        this.succRefundItemNum = succRefundItemNum;
    }

    public BigDecimal getVisitOrderConvRate() {
        return visitOrderConvRate;
    }

    public BigDecimal getSuccRefundAmt() {
        return succRefundAmt;
    }

    public void setSuccRefundAmt(BigDecimal succRefundAmt) {
        this.succRefundAmt = succRefundAmt;
    }

    public void setVisitOrderConvRate(BigDecimal visitOrderConvRate) {
        this.visitOrderConvRate = visitOrderConvRate;
    }

    public BigDecimal getOrderPayConvRate() {
        return orderPayConvRate;
    }

    public void setOrderPayConvRate(BigDecimal orderPayConvRate) {
        this.orderPayConvRate = orderPayConvRate;
    }

    public BigDecimal getVisitPayConvRate() {
        return visitPayConvRate;
    }

    public void setVisitPayConvRate(BigDecimal visitPayConvRate) {
        this.visitPayConvRate = visitPayConvRate;
    }

    public BigDecimal getRefundRate() {
        return refundRate;
    }

    public void setRefundRate(BigDecimal refundRate) {
        this.refundRate = refundRate;
    }
}
