package com.dtyunxi.yundt.dataengine.center.report.api.icommerce.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 流量分析-访问来源分析排序字段枚举类
 */
public enum ActivityBySourceSortFieldEnum {
    PV("pv","浏览量"),
    NEWUV("newUv","新增访客量"),
    UV("uv","访客量"),
    TOTALPVTD("totalPvTd","累计浏览量"),
    TOTALPVPERCENTAGE("totalPvPercentage","累计浏览量占比"),
    TOTALUVTD("totalUvTd","累计访客量"),
    TOTALUVPERCENTAGE("totalUvPercentage","累计访客量占比")
    ;
    private final String code;

    private final String name;


    public static ActivityBySourceSortFieldEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        for(ActivityBySourceSortFieldEnum activityBySourceSortFieldEnum : ActivityBySourceSortFieldEnum.values()){
            if(activityBySourceSortFieldEnum.getCode().equals(code)){
                return activityBySourceSortFieldEnum;
            }
        }
        return null;
    }

    ActivityBySourceSortFieldEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public String getCode() {
        return code;
    }
}
