package com.dtyunxi.yundt.dataengine.center.report.api.icommerce.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 统计时间类型枚举类
 */
public enum QueryTimeTypeEnum {

    /**
     * 天
     */
    day1("day","天"),
    /**
     * 周
     */
    week("week","周"),
    /**
     * 月
     */
    month("month","月"),
    /**
     * 自定义
     */
    customize("customize","自定义"),
    ;
    private final String code;

    private final String name;

    public static QueryTimeTypeEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        for(QueryTimeTypeEnum timeTypeEnum : QueryTimeTypeEnum.values()){
            if(timeTypeEnum.getCode().equals(code)){
                return timeTypeEnum;
            }
        }
        return null;
    }

    QueryTimeTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public String getCode() {
        return code;
    }
}
