package com.dtyunxi.yundt.dataengine.center.report.api.icommerce.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 统计时间类型枚举类
 */
public enum SalesOrderByEnum {

    /**
     * 天
     */
    pv("pv","访问量"),
    /**
     * 周
     */
    addCartCustCnt("addCartCustCnt","加购人数"),
    /**
     * 月
     */
    paidItemNum("paidItemNum","支付商品件数(销量)"),
    /**
     * 自定义
     */
    paidAmt("paidAmt","支付金额"),
    /**
     * 自定义
     */
    succRefundItemNum("succRefundItemNum","成功退货/退款商品件数(退款件数)"),
    /**
     * 自定义
     */
    visitOrderConvRate("visitOrderConvRate","浏览下单转化率(下单转化率)"),
    /**
     * 自定义
     */
    orderPayConvRate("orderPayConvRate","下单支付转化率"),
    /**
     * 自定义
     */
    visitPayConvRate("visitPayConvRate","支付转化率"),
    /**
     * 自定义
     */
    refundRate("refundRate","退款率"),
    ;
    private final String code;

    private final String name;


    public static SalesOrderByEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        for(SalesOrderByEnum timeTypeEnum : SalesOrderByEnum.values()){
            if(timeTypeEnum.getCode().equals(code)){
                return timeTypeEnum;
            }
        }
        return null;
    }

    SalesOrderByEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public String getCode() {
        return code;
    }
}
