package com.dtyunxi.yundt.dataengine.center.report.api.icommerce.evaluate;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.request.TradeOverviewBaseReqDto;
import com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.response.TradeOverviewDetailRespDto;
import com.dtyunxi.yundt.dataengine.center.report.api.icommerce.dto.response.TradeOverviewRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

import javax.validation.Valid;
import java.util.List;

@FeignClient(name = "${dataengine.center.report:dataengine-center-report}",
        path = "/dataengine-center-report/v1/icommerce/trade/analyze",
        url = "${dataengine.center.report.name.api:}"
)
@Api(tags={"交易分析：交易分析"})
public interface ITradeAnalyzeApi {

    @GetMapping("/overview")
    @ApiOperation(value = "交易概览")
    RestResponse<TradeOverviewRespDto> tradeOverview(@Valid TradeOverviewBaseReqDto reqDto);

    @GetMapping("/overview/detail")
    @ApiOperation(value = "交易概览详情（天）")
    RestResponse<List<TradeOverviewDetailRespDto>> tradeOverviewDetail(@Valid TradeOverviewBaseReqDto reqDto);

}
