/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.biz.activity.base.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemStorageApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BatchItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.ExchangeActivityTargetDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.ItemSkuActivityPriceDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.ActivityMutexQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.ActivityPriceBranchQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.ActivityStockReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.BatchActivityStockReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.ConflictSingleItemReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.ItemActivityStockReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.RemainingStockBatchReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.SupportSingleItemDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.TargetCustomerReqDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.ActivityMutexQueryRespDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.BatchActivityStockRespDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.ExchangeActivityTargetRespDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.ItemActivityStockRespDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.NotSupportSingleItemDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.RemainingStockBatchRespDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.biz.activity.base.constants.ActivityStock;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.biz.activity.base.service.IItemActivityStockService;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.biz.activity.base.service.impl.ItemActivityStockeEsServiceImpl;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.ItemSkuDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivitySimpleInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityPriceDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityPriceQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityDimensionEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ActivityItemTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityRelationService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IItemActivityPriceService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.IItemActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.IItemActivityTagService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityItemRuleService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityItemService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityPreviewService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.conf.param.ActivityStockTypeParam;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityItemDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ConditionDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityItemEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ConditionEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.StdActivityEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.StdActivityItemEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemActivityStockServiceImpl
implements IItemActivityStockService {
    private static final Logger logger = LoggerFactory.getLogger(ItemActivityStockServiceImpl.class);
    private static final DefaultConversionService CONVERSION_SERVICE = new DefaultConversionService();
    @Resource
    private IActivityItemRuleService activityItemRuleService;
    @CubeResource
    private ActivityStockTypeParam activityStockTypeParam;
    @Resource
    private IItemStorageApi itemStorageApi;
    @Resource
    private IActivityItemService activityItemService;
    @Resource
    private IActivityPreviewService activityPreviewService;
    @Resource
    private IItemActivityPriceService itemActivityPriceService;
    @Resource
    private IActivityExtService activityExtService;
    @Resource
    private IActivityRelationService activityRelationService;
    @Resource
    private ActivityDas activityDas;
    @Autowired
    private ActivityItemDas activityItemDas;
    @Resource
    private IItemActivityService itemActivityService;
    @Autowired
    private ConditionDas conditionDas;
    @Resource
    private IItemActivityTagService itemActivityTagService;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource(name="itemActivityStockeEsServiceImpl")
    private ItemActivityStockeEsServiceImpl itemActivityStockeEsServiceImpl;

    @Override
    public BatchActivityStockRespDto batchOperatingActivityStock(BatchActivityStockReqDto batchActivityStockReqDto) {
        if (CollectionUtils.isEmpty((Collection)batchActivityStockReqDto.getItemActivityStockList())) {
            throw new BizException("\u5546\u54c1\u64cd\u4f5c\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (BatchItemStorageReqDto.SUB.equals(batchActivityStockReqDto.getOpt())) {
            for (ItemActivityStockReqDto itemActivityStockReqDto : batchActivityStockReqDto.getItemActivityStockList()) {
                if (itemActivityStockReqDto.getBalance() != null && itemActivityStockReqDto.getBalance() < 0L) continue;
                throw new BizException("\u4f20\u53c2\u6709\u8bef\uff0c\u6263\u51cf\u64cd\u4f5c\u4e0d\u80fd\u5927\u4e8e0\u6216\u8005\u4e3a\u7a7a");
            }
        } else if (BatchItemStorageReqDto.ADD.equals(batchActivityStockReqDto.getOpt())) {
            for (ItemActivityStockReqDto itemActivityStockReqDto : batchActivityStockReqDto.getItemActivityStockList()) {
                if (itemActivityStockReqDto.getBalance() != null && itemActivityStockReqDto.getBalance() > 0L) continue;
                throw new BizException("\u4f20\u53c2\u6709\u8bef\uff0c\u589e\u52a0\u64cd\u4f5c\u4e0d\u80fd\u5c0f\u4e8e0");
            }
        } else {
            throw new BizException("\u53ea\u652f\u6301\u65b0\u589e\u548c\u6263\u51cf\u4e24\u79cd\u64cd\u4f5c");
        }
        List activityItemEos = this.activityItemService.queryActivityByActivityIds(batchActivityStockReqDto.getActivityIds());
        Map<Long, List<ActivityItemEo>> activityItemMap = activityItemEos.stream().collect(Collectors.groupingBy(StdActivityItemEo::getActivityId));
        BatchActivityStockRespDto batchActivityStockRespDto = new BatchActivityStockRespDto();
        for (ItemActivityStockReqDto itemActivityStockReqDto : batchActivityStockReqDto.getItemActivityStockList()) {
            try {
                this.operatingActivityStock(itemActivityStockReqDto, batchActivityStockReqDto.getOpt(), (Integer)this.activityStockTypeParam.getValue(), activityItemMap);
                ItemActivityStockRespDto itemActivityStockRespDto = new ItemActivityStockRespDto();
                BeanUtils.copyProperties((Object)itemActivityStockReqDto, (Object)itemActivityStockRespDto);
                batchActivityStockRespDto.getSuccessList().add(itemActivityStockRespDto);
            }
            catch (Exception e) {
                if (BatchItemStorageReqDto.SUB.equals(batchActivityStockReqDto.getOpt())) {
                    logger.info("\u6d3b\u52a8ids={},skuId={},\u64cd\u4f5c\u5e93\u5b58\u5931\u8d25{}", new Object[]{JSON.toJSONString((Object)itemActivityStockReqDto.getActivityIds()), itemActivityStockReqDto.getSkuId(), e});
                    if (CollectionUtils.isNotEmpty((Collection)batchActivityStockRespDto.getSuccessList())) {
                        for (ItemActivityStockRespDto itemActivityStockRespDto : batchActivityStockRespDto.getSuccessList()) {
                            try {
                                ItemActivityStockReqDto rollBack = new ItemActivityStockReqDto();
                                BeanUtils.copyProperties((Object)itemActivityStockRespDto, (Object)rollBack);
                                rollBack.setBalance(Long.valueOf(-rollBack.getBalance().longValue()));
                                this.operatingActivityStock(rollBack, BatchItemStorageReqDto.ADD, (Integer)this.activityStockTypeParam.getValue(), activityItemMap);
                            }
                            catch (Exception rollBackEx) {
                                logger.error("\u3010\u6d3b\u52a8\u5e93\u5b58\u56de\u6eda\u5931\u8d25:shopId={},skuId={},activityIds={},stock={}\u3011", new Object[]{itemActivityStockReqDto.getShopId(), itemActivityStockReqDto.getSkuId(), JSON.toJSONString((Object)itemActivityStockReqDto.getActivityIds()), itemActivityStockReqDto.getBalance()});
                            }
                        }
                    }
                    throw new ProBizException(ProExceptionCode.STOCK_EMPTY);
                }
                batchActivityStockRespDto.setIfAllSuccess(Boolean.valueOf(false));
                logger.error("\u6d3b\u52a8ids={},skuId={},\u64cd\u4f5c\u589e\u52a0\u5e93\u5b58\u5931\u8d25{}\uff0c\u7ee7\u7eed\u589e\u52a0\u5e93\u5b58", new Object[]{JSON.toJSONString((Object)itemActivityStockReqDto.getActivityIds()), itemActivityStockReqDto.getSkuId(), e});
            }
        }
        if (batchActivityStockRespDto.getIfAllSuccess().booleanValue()) {
            batchActivityStockRespDto.setSuccessList(null);
        }
        return batchActivityStockRespDto;
    }

    @Override
    public Integer queryActivityStockType(Long instanceId) {
        if (Objects.nonNull(instanceId)) {
            this.activityExtService.getAndSetInstanceInfo(instanceId);
        }
        return (Integer)this.activityStockTypeParam.getValue();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void operatingActivityStock(ItemActivityStockReqDto itemActivityStockReqDto, Integer opt, Integer stockType, Map<Long, List<ActivityItemEo>> activityItemMap) {
        logger.info("\u6d3b\u52a8itemActivityStockReqDto={}\uff0c\u8bfb\u53d6\u914d\u7f6e\u9879={}", (Object)JSON.toJSONString((Object)itemActivityStockReqDto), (Object)stockType);
        List activityIds = itemActivityStockReqDto.getActivityIds();
        if (CollectionUtils.isNotEmpty((Collection)activityIds)) {
            List<ActivityItemEo> activityItemEos = activityItemMap.get(activityIds.get(0));
            int joinNum = this.activityItemRuleService.getJoinNum(((Long)activityIds.get(0)).longValue(), itemActivityStockReqDto.getSkuId().longValue(), itemActivityStockReqDto.getShopId(), ActivityItemTypeEnum.ITEM);
            boolean unlimitedFlag = false;
            if (CollectionUtils.isEmpty(activityItemEos) || joinNum == -1) {
                unlimitedFlag = true;
            }
            this.operatingJoinNumAndActivityStock(itemActivityStockReqDto, activityIds, opt, stockType, unlimitedFlag, activityItemMap);
        }
    }

    private void operatingJoinNumAndActivityStock(ItemActivityStockReqDto itemActivityStockReqDto, List<Long> activityIds, Integer opt, Integer stockType, boolean unlimitedFlag, Map<Long, List<ActivityItemEo>> activityItemMap) {
        ItemActivityStockReqDto success = new ItemActivityStockReqDto();
        success.setShopId(itemActivityStockReqDto.getShopId());
        success.setSkuId(itemActivityStockReqDto.getSkuId());
        success.setBalance(itemActivityStockReqDto.getBalance());
        success.setActivityIds(new ArrayList());
        for (Long activityId : activityIds) {
            int joinNum;
            List<ActivityItemEo> activityItemEos = activityItemMap.get(activityId);
            if (CollectionUtils.isEmpty(activityItemEos) || (joinNum = this.activityItemRuleService.getJoinNum(activityId.longValue(), itemActivityStockReqDto.getSkuId().longValue(), itemActivityStockReqDto.getShopId(), ActivityItemTypeEnum.ITEM)) == -1) continue;
            boolean isSub = this.activityItemRuleService.increaseJoinNum(activityId.longValue(), itemActivityStockReqDto.getSkuId().longValue(), itemActivityStockReqDto.getShopId(), itemActivityStockReqDto.getBalance().intValue(), ActivityItemTypeEnum.ITEM, "\u6d3b\u52a8\u53c2\u4e0e\u6b21\u6570\u8c03\u6574");
            if (isSub) {
                success.getActivityIds().add(activityId);
                continue;
            }
            if (BatchItemStorageReqDto.SUB.equals(opt)) {
                logger.info("\u6d3b\u52a8id={},skuId={},\u64cd\u4f5c\u53c2\u4e0e\u6b21\u6570\u5931\u8d25", (Object)activityId, (Object)itemActivityStockReqDto.getSkuId());
                if (CollectionUtils.isNotEmpty((Collection)success.getActivityIds())) {
                    for (Long rollActivityId : success.getActivityIds()) {
                        boolean isRoll = this.activityItemRuleService.increaseJoinNum(rollActivityId.longValue(), itemActivityStockReqDto.getSkuId().longValue(), itemActivityStockReqDto.getShopId(), -itemActivityStockReqDto.getBalance().intValue(), ActivityItemTypeEnum.ITEM, "\u56de\u6eda\u6d3b\u52a8\u53c2\u4e0e\u6b21\u6570");
                        if (isRoll) continue;
                        logger.error("\u3010\u6d3b\u52a8\u53c2\u4e0e\u6b21\u6570\u56de\u6eda\u5931\u8d25:shopId={},skuId={},activityId={},stock={}\u3011", new Object[]{itemActivityStockReqDto.getShopId(), itemActivityStockReqDto.getSkuId(), rollActivityId, itemActivityStockReqDto.getBalance()});
                    }
                }
            } else {
                logger.error("\u6d3b\u52a8id={},skuId={},\u64cd\u4f5c\u589e\u52a0\u53c2\u4e0e\u6b21\u6570\u5931\u8d25\uff0c\u7ee7\u7eed\u589e\u52a0\u53c2\u4e0e\u6b21\u6570", (Object)activityId, (Object)itemActivityStockReqDto.getSkuId());
            }
            throw new ProBizException(ProExceptionCode.STOCK_EMPTY);
        }
        boolean isSub = true;
        if (unlimitedFlag) {
            if (!ActivityStockTypeParam.SHARE.equals(stockType)) {
                ItemStorageReqDto itemStorageReqDto = new ItemStorageReqDto();
                itemStorageReqDto.setSkuId(itemActivityStockReqDto.getSkuId());
                itemStorageReqDto.setShopId(itemActivityStockReqDto.getShopId());
                itemStorageReqDto.setBalance(itemActivityStockReqDto.getBalance());
                try {
                    RestResponse restResponse = this.itemStorageApi.operatingItemStorage(itemStorageReqDto);
                    if (!"0".equals(restResponse.getResultCode())) {
                        throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
                    }
                    logger.info("\u3010\u5546\u54c1\u865a\u62df\u5e93\u5b58\u64cd\u4f5c\u6210\u529f\uff1ashopId={}, skuId={}, quantity={}\u3011", new Object[]{itemActivityStockReqDto.getShopId(), itemActivityStockReqDto.getSkuId(), itemActivityStockReqDto.getBalance()});
                }
                catch (Exception e) {
                    logger.error("\u5546\u54c1\u4e2d\u5fc3\u629b\u9519", (Throwable)e);
                    isSub = false;
                }
            }
        } else {
            isSub = this.activityItemRuleService.increase(activityIds.get(0).longValue(), itemActivityStockReqDto.getSkuId().longValue(), itemActivityStockReqDto.getShopId(), itemActivityStockReqDto.getBalance().intValue(), ActivityItemTypeEnum.ITEM, "\u6d3b\u52a8\u5e93\u5b58\u8c03\u6574");
        }
        if (!isSub) {
            if (BatchItemStorageReqDto.SUB.equals(opt)) {
                logger.info("\u6d3b\u52a8id={},skuId={},\u64cd\u4f5c\u6d3b\u52a8\u5e93\u5b58\u5931\u8d25", (Object)activityIds.get(0), (Object)itemActivityStockReqDto.getSkuId());
                for (Long rollActivityId : success.getActivityIds()) {
                    boolean isRoll = this.activityItemRuleService.increaseJoinNum(rollActivityId.longValue(), itemActivityStockReqDto.getSkuId().longValue(), itemActivityStockReqDto.getShopId(), -itemActivityStockReqDto.getBalance().intValue(), ActivityItemTypeEnum.ITEM, "\u56de\u6eda\u6d3b\u52a8\u5269\u4f59\u53c2\u4e0e\u6b21\u6570");
                    if (isRoll) continue;
                    logger.error("\u3010\u6d3b\u52a8\u5269\u4f59\u53c2\u4e0e\u6b21\u6570\u56de\u6eda\u5931\u8d25:shopId={},skuId={},activityId={},stock={}\u3011", new Object[]{itemActivityStockReqDto.getShopId(), itemActivityStockReqDto.getSkuId(), rollActivityId, itemActivityStockReqDto.getBalance()});
                }
            } else {
                logger.error("\u6d3b\u52a8id={},skuId={},\u64cd\u4f5c\u589e\u52a0\u5269\u4f59\u6d3b\u52a8\u5e93\u5b58\u5931\u8d25\uff0c\u7ee7\u7eed\u589e\u52a0\u5269\u4f59\u6d3b\u52a8\u5e93\u5b58", (Object)activityIds.get(0), (Object)itemActivityStockReqDto.getSkuId());
            }
            throw new ProBizException(ProExceptionCode.STOCK_EMPTY);
        }
    }

    @Override
    public Map<String, Long> getActivityRemainingStock(ActivityStockReqDto activityStockReqDto) {
        return this.getActivityRemainingStock(activityStockReqDto, new HashMap<String, List<Long>>(), new ArrayList<Long>());
    }

    @Override
    public Map<String, Long> getActivityRemainingStock(ActivityStockReqDto activityStockReqDto, Map<String, List<Long>> activityListMap, List<Long> lessBeginActivityIds) {
        Set activityIds = activityStockReqDto.getActivityIds().stream().collect(Collectors.toSet());
        ArrayList needActivityIds = Lists.newArrayList();
        if (!ActivityStockTypeParam.PREEMPT.equals(this.activityStockTypeParam.getValue())) {
            for (Long activityId : activityIds) {
                if (lessBeginActivityIds.contains(activityId)) {
                    needActivityIds.add(activityId);
                    continue;
                }
                List activityItemRespDtos = this.activityItemService.queryActivityItems(activityId, activityStockReqDto.getItemId());
                if (CollectionUtils.isEmpty((Collection)activityItemRespDtos)) {
                    needActivityIds.add(activityId);
                    continue;
                }
                Map<String, ActivityItemRespDto> itemNumMap = activityItemRespDtos.stream().collect(Collectors.toMap(o -> o.getShopId() + "_" + o.getSkuId(), o -> o, (v1, v2) -> v1));
                boolean activityFlag = false;
                for (Map.Entry<String, ActivityItemRespDto> activityItem : itemNumMap.entrySet()) {
                    Long activityStock = activityItem.getValue().getActivityStock();
                    if (!ActivityStock.NO_LIMIT_STOCK.equals(activityStock) && activityStock <= 0L) continue;
                    activityFlag = true;
                    break;
                }
                if (!activityFlag) continue;
                needActivityIds.add(activityId);
            }
            activityListMap.put(activityStockReqDto.getShopId() + "_" + activityStockReqDto.getItemId(), needActivityIds);
            return new HashMap<String, Long>();
        }
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (Long activityId : activityIds) {
            List activityItemRespDtos = this.activityItemService.queryActivityItems(activityId, activityStockReqDto.getItemId());
            Map<String, ActivityItemRespDto> itemNumMap = activityItemRespDtos.stream().collect(Collectors.toMap(o -> o.getShopId() + "_" + o.getSkuId(), o -> o, (v1, v2) -> v1));
            boolean activityFlag = false;
            for (Map.Entry<String, ActivityItemRespDto> activityItem : itemNumMap.entrySet()) {
                Long remainingStock = activityItem.getValue().getRemainingStock();
                if (result.containsKey(activityItem.getKey())) {
                    Long stock = (Long)result.get(activityItem.getKey());
                    stock = stock + this.changeRemainingStock(remainingStock);
                    result.put(activityItem.getKey(), stock);
                } else {
                    result.put(activityItem.getKey(), this.changeRemainingStock(remainingStock));
                }
                if (!ActivityStock.NO_LIMIT_STOCK.equals(remainingStock) && remainingStock <= 0L) continue;
                activityFlag = true;
            }
            if (!activityFlag) continue;
            needActivityIds.add(activityId);
        }
        activityListMap.put(activityStockReqDto.getShopId() + "_" + activityStockReqDto.getItemId(), needActivityIds);
        logger.info("\u6d3b\u52a8\u5e93\u5b58\u7ed3\u679c=[{}]", result);
        return result;
    }

    @Override
    public RemainingStockBatchRespDto getActivityRemainingStockBatch(RemainingStockBatchReqDto reqDto) {
        RemainingStockBatchRespDto respDto = new RemainingStockBatchRespDto();
        List activityStockList = reqDto.getActivityStockList();
        if (CollectionUtils.isNotEmpty((Collection)activityStockList)) {
            Date nowTime = new Date();
            HashSet allActivityIds = new HashSet();
            for (ActivityStockReqDto stockReqDto : activityStockList) {
                allActivityIds.addAll(stockReqDto.getActivityIds());
            }
            List<Object> lessBeginActivityIds = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(allActivityIds)) {
                List activityEos = this.activityDas.getMapper().selectList((Wrapper)new QueryWrapper().in((Object)"id", allActivityIds));
                lessBeginActivityIds = activityEos.stream().filter(act -> nowTime.before(act.getBeginTime())).map(BaseEo::getId).collect(Collectors.toList());
            }
            HashMap<String, List<Long>> activityListMap = new HashMap<String, List<Long>>();
            for (int i = 0; i < activityStockList.size(); ++i) {
                Map<String, Long> remainingStockMap = this.getActivityRemainingStock((ActivityStockReqDto)activityStockList.get(i), activityListMap, lessBeginActivityIds);
                if (i != 0) continue;
                respDto.setRemainingStockMap(remainingStockMap);
            }
            respDto.setActivityListMap(activityListMap);
        }
        return respDto;
    }

    private Long changeRemainingStock(Long remainingStock) {
        if (ActivityStock.NO_LIMIT_STOCK == remainingStock) {
            remainingStock = ActivityStock.INIT_STOCK;
            return remainingStock;
        }
        return remainingStock;
    }

    @Override
    public List<Long> validateTargetCustomersAndMallType(TargetCustomerReqDto targetCustomerReqDto) {
        if (CollectionUtils.isNotEmpty((Collection)targetCustomerReqDto.getCustomerInfoList())) {
            ArrayList result = Lists.newArrayList();
            for (Object activityId : targetCustomerReqDto.getActivityIds()) {
                Boolean targetType = this.activityPreviewService.validateTargetMall((Long)activityId, targetCustomerReqDto.getSrcType());
                if (!targetType.booleanValue()) continue;
                result.add(activityId);
            }
            if (CollectionUtils.isEmpty((Collection)result)) {
                return result;
            }
            ArrayList newResult = Lists.newArrayList();
            for (CustomerRespDto customer : targetCustomerReqDto.getCustomerInfoList()) {
                for (Long activityId : result) {
                    Boolean targetCustomer;
                    if (newResult.contains(activityId) || !(targetCustomer = this.activityPreviewService.validateTargetCustomer(activityId, customer.getId(), customer)).booleanValue()) continue;
                    newResult.add(activityId);
                }
            }
            return newResult;
        }
        if (Objects.nonNull(targetCustomerReqDto.getCustomerInfo())) {
            ArrayList result = Lists.newArrayList();
            for (Long activityId : targetCustomerReqDto.getActivityIds()) {
                Boolean targetType = this.activityPreviewService.validateTargetMall(activityId, targetCustomerReqDto.getSrcType());
                if (!targetType.booleanValue()) continue;
                result.add(activityId);
            }
            if (CollectionUtils.isEmpty((Collection)result)) {
                return result;
            }
            CustomerRespDto customerRespDto = (CustomerRespDto)BeanUtil.copyProperties((Object)targetCustomerReqDto.getCustomerInfo(), CustomerRespDto.class, (String[])new String[0]);
            ArrayList newResult = Lists.newArrayList();
            for (Long activityId : result) {
                Boolean targetCustomer = this.activityPreviewService.validateTargetCustomer(activityId, targetCustomerReqDto.getCustomerInfo().getId(), customerRespDto);
                if (!targetCustomer.booleanValue()) continue;
                newResult.add(activityId);
            }
            return newResult;
        }
        return Lists.newArrayList();
    }

    @Override
    public List<ItemActivityPriceDto> queryEnableList(ItemActivityPriceQueryReqDto queryReqDto) {
        List itemActivityPriceList = this.itemActivityPriceService.queryList(queryReqDto);
        if (CollectionUtils.isNotEmpty((Collection)itemActivityPriceList)) {
            itemActivityPriceList.removeIf(itemActivityPriceDto -> {
                ActivitySimpleInfoDto activitySimpleInfoDto = (ActivitySimpleInfoDto)itemActivityPriceDto.getActivityList().get(0);
                int remainingStock = this.activityItemRuleService.get(activitySimpleInfoDto.getActivityId().longValue(), itemActivityPriceDto.getSkuId().longValue(), itemActivityPriceDto.getShopId(), ActivityItemTypeEnum.ITEM);
                if (remainingStock == -1) {
                    return false;
                }
                return remainingStock <= 0;
            });
        }
        return itemActivityPriceList;
    }

    @Override
    public List<ItemSkuActivityPriceDto> queryBranchItemSkuActivityPrice(ActivityPriceBranchQueryReqDto queryReqDto) {
        logger.info("[activityPriceBranchQueryReqDto]>>>{}", (Object)JSON.toJSONString((Object)queryReqDto));
        List<Object> itemSkuActivityPriceList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)queryReqDto.getItemSkuActivityPriceList())) {
            return itemSkuActivityPriceList;
        }
        HashSet<Long> customerIds = new HashSet<Long>();
        HashSet<Long> itemIds = new HashSet<Long>();
        HashSet<Long> shopIds = new HashSet<Long>();
        for (ItemSkuActivityPriceDto itemSkuActivityPriceDto : queryReqDto.getItemSkuActivityPriceList()) {
            if (Objects.isNull(itemSkuActivityPriceDto.getCustomerId())) continue;
            customerIds.add(itemSkuActivityPriceDto.getCustomerId());
            itemIds.add(itemSkuActivityPriceDto.getItemId());
            shopIds.add(itemSkuActivityPriceDto.getShopId());
        }
        ItemActivityTagQueryReqDto tagQueryReqDto = new ItemActivityTagQueryReqDto();
        tagQueryReqDto.setItemIdList((List)Lists.newArrayList(itemIds));
        tagQueryReqDto.setShopIdList((List)Lists.newArrayList(shopIds));
        tagQueryReqDto.setDimension(ActivityDimensionEnum.ITEM.getKey());
        tagQueryReqDto.setPreheatStartTime(new Date());
        List tags = this.itemActivityTagService.queryList(tagQueryReqDto);
        if (CollectionUtils.isEmpty((Collection)tags)) {
            return itemSkuActivityPriceList;
        }
        logger.info("[queryBranchItemSkuActivityPrice.tags]>>>{}", (Object)JSON.toJSONString((Object)tags));
        Date nowTime = new Date();
        HashSet<Long> allActivityIds = new HashSet<Long>();
        for (ItemActivityTagDto tagDto : tags) {
            allActivityIds.add(tagDto.getActivityId());
        }
        List<Object> lessBeginActivityIds = Lists.newArrayList();
        Map<Object, Object> orgIdMap = new HashMap();
        if (CollectionUtils.isNotEmpty(allActivityIds)) {
            List activityEos = this.activityDas.getMapper().selectList((Wrapper)new QueryWrapper().in((Object)"id", allActivityIds));
            lessBeginActivityIds = activityEos.stream().filter(act -> nowTime.before(act.getBeginTime())).map(BaseEo::getId).collect(Collectors.toList());
            orgIdMap = activityEos.stream().collect(Collectors.toMap(BaseEo::getId, StdActivityEo::getOrganizationId));
        }
        HashMap<Long, ArrayList> tagsMap = new HashMap<Long, ArrayList>();
        HashMap<String, Boolean> customerFlagMap = new HashMap<String, Boolean>();
        if (customerIds.isEmpty()) {
            return Collections.emptyList();
        }
        for (Long customerId : customerIds) {
            HashSet<Long> set = new HashSet<Long>();
            ArrayList newTags = Lists.newArrayList();
            CustomerRespDto customerInfo = (CustomerRespDto)this.customerQueryApi.queryById(customerId).getData();
            Iterator iterator = tags.iterator();
            while (iterator.hasNext()) {
                ItemActivityTagDto tag2 = (ItemActivityTagDto)iterator.next();
                if (set.add(tag2.getActivityId())) {
                    Boolean customerFlag;
                    customerFlagMap.put(customerId + "_" + tag2.getActivityId(), false);
                    Boolean mallFlag = this.activityPreviewService.validateTargetMall(tag2.getActivityId(), queryReqDto.getSrcType());
                    if (!mallFlag.booleanValue() || !(customerFlag = this.activityPreviewService.validateTargetCustomer(tag2.getActivityId(), customerId, customerInfo)).booleanValue()) continue;
                    Long sellerOrgId = (Long)orgIdMap.get(tag2.getActivityId());
                    if (!customerInfo.getMerchantId().equals(sellerOrgId)) continue;
                    customerFlagMap.put(customerId + "_" + tag2.getActivityId(), true);
                    newTags.add(tag2);
                    iterator.remove();
                    continue;
                }
                if (!((Boolean)customerFlagMap.get(customerId + "_" + tag2.getActivityId())).booleanValue()) continue;
                newTags.add(tag2);
                iterator.remove();
            }
            tagsMap.put(customerId, newTags);
        }
        logger.info("[queryBranchItemSkuActivityPrice.tagsMap]>>>{}", (Object)JSON.toJSONString(tagsMap));
        int num = 1;
        Long timeActivityTemplateId = ActivityType.TIME_DISCOUNT_TOB_ACTIVITY.getId();
        HashMap remainingStockMap = new HashMap();
        for (ItemSkuActivityPriceDto itemSkuActivityPriceDto : queryReqDto.getItemSkuActivityPriceList()) {
            String shopItemStr = itemSkuActivityPriceDto.getShopId() + "_" + itemSkuActivityPriceDto.getItemId();
            List itemActivityTagDtos = (List)tagsMap.get(itemSkuActivityPriceDto.getCustomerId());
            List needItemActivityTags = itemActivityTagDtos.stream().filter(dto -> shopItemStr.equals(dto.getShopId() + "_" + dto.getItemId())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(needItemActivityTags)) {
                List<Object> finalLessBeginActivityIds = lessBeginActivityIds;
                needItemActivityTags.removeIf(tag -> {
                    if (!queryReqDto.getFilterNotBegin().booleanValue() && finalLessBeginActivityIds.contains(tag.getActivityId())) {
                        return false;
                    }
                    int remainingStock = this.activityItemRuleService.getJoinNum(tag.getActivityId().longValue(), itemSkuActivityPriceDto.getSkuId().longValue(), itemSkuActivityPriceDto.getShopId(), ActivityItemTypeEnum.ITEM);
                    if (remainingStock == -1) {
                        return false;
                    }
                    if (remainingStock <= 0) {
                        return true;
                    }
                    String activityId_shopId_skuId = tag.getActivityId() + "_" + itemSkuActivityPriceDto.getShopId() + "_" + itemSkuActivityPriceDto.getSkuId();
                    remainingStockMap.put(activityId_shopId_skuId, Long.valueOf(remainingStock));
                    return false;
                });
                logger.info("[queryBranchItemSkuActivityPrice.needItemActivityTags]{}>>>{}", (Object)num, (Object)JSON.toJSONString(needItemActivityTags));
                ArrayList skuDtoList = Lists.newArrayList();
                for (ItemActivityTagDto needItemActivityTag : needItemActivityTags) {
                    ItemSkuDto itemSkuDto = this.itemActivityService.queryItemSkuActivityPrice(itemSkuActivityPriceDto.getItemId(), itemSkuActivityPriceDto.getSkuId(), needItemActivityTag.getActivityId(), itemSkuActivityPriceDto.getShopId());
                    if (!Objects.nonNull(itemSkuDto)) continue;
                    if (queryReqDto.getFilterSecKill().booleanValue()) {
                        if (!timeActivityTemplateId.equals(itemSkuDto.getActivityTemplateId())) continue;
                        itemSkuDto.setActivityTag(needItemActivityTag.getActivityTag());
                        skuDtoList.add(itemSkuDto);
                        continue;
                    }
                    itemSkuDto.setActivityTag(needItemActivityTag.getActivityTag());
                    skuDtoList.add(itemSkuDto);
                }
                logger.info("[queryBranchItemSkuActivityPrice.skuDtoList]{}>>>{}", (Object)num, (Object)JSON.toJSONString((Object)skuDtoList));
                if (CollectionUtils.isNotEmpty((Collection)skuDtoList)) {
                    for (ItemSkuDto itemSkuDto : skuDtoList) {
                        BigDecimal minActivityPrice;
                        if (2 == itemSkuDto.getPromotionMethod()) {
                            BigDecimal sellPrice = itemSkuActivityPriceDto.getSellPrice() == null ? new BigDecimal("0.00") : itemSkuActivityPriceDto.getSellPrice();
                            minActivityPrice = itemSkuDto.getDiscount().multiply(sellPrice).divide(BigDecimal.TEN, 2, 4);
                        } else {
                            minActivityPrice = itemSkuDto.getActivityPrice();
                        }
                        ItemSkuActivityPriceDto activityPriceDto = new ItemSkuActivityPriceDto();
                        CubeBeanUtils.copyProperties((Object)activityPriceDto, (Object)itemSkuActivityPriceDto, (String[])new String[0]);
                        activityPriceDto.setActivityId(itemSkuDto.getActivityId());
                        activityPriceDto.setActivityTag(itemSkuDto.getActivityTag());
                        activityPriceDto.setActivityPrice(minActivityPrice);
                        activityPriceDto.setActivityTemplateId(itemSkuDto.getActivityTemplateId());
                        activityPriceDto.setPromotionMethod(itemSkuDto.getPromotionMethod());
                        activityPriceDto.setDiscount(itemSkuDto.getDiscount());
                        activityPriceDto.setRemainingStock((Long)remainingStockMap.get(itemSkuDto.getActivityId() + "_" + activityPriceDto.getShopId() + "_" + activityPriceDto.getSkuId()));
                        itemSkuActivityPriceList.add(activityPriceDto);
                    }
                }
            }
            ++num;
        }
        if (CollectionUtils.isNotEmpty((Collection)itemSkuActivityPriceList)) {
            itemSkuActivityPriceList = itemSkuActivityPriceList.stream().sorted(Comparator.comparing(ItemSkuActivityPriceDto::getActivityPrice)).collect(Collectors.toList());
        }
        return itemSkuActivityPriceList;
    }

    @Override
    public List<ActivityMutexQueryRespDto> queryActivityMutexList(ActivityMutexQueryReqDto queryReqDto) {
        if (CollectionUtils.isEmpty((Collection)queryReqDto.getActivityIds()) || CollectionUtils.isEmpty((Collection)queryReqDto.getItemSkuList())) {
            return new ArrayList<ActivityMutexQueryRespDto>();
        }
        List activityIds = queryReqDto.getActivityIds();
        List itemSkuList = queryReqDto.getItemSkuList();
        Map<Long, List<String>> activitySkusMap = this.setActivitySkusMapping(activityIds, itemSkuList);
        ArrayList<ActivityMutexQueryRespDto> list = new ArrayList<ActivityMutexQueryRespDto>(activityIds.size());
        for (Long activityId : activityIds) {
            ActivityMutexQueryRespDto activityMutexQueryRespDto = new ActivityMutexQueryRespDto();
            ArrayList<Long> mutexActivityIds = new ArrayList<Long>();
            activityMutexQueryRespDto.setActivityId(activityId);
            List<String> shopSkuList = activitySkusMap.get(activityId);
            for (Long id : activityIds) {
                boolean isOverlap;
                List<String> nextShopSkuList;
                if (activityId.equals(id) || Collections.disjoint(shopSkuList, nextShopSkuList = activitySkusMap.get(id)) || (isOverlap = this.activityRelationService.newOverlap(activityId, id))) continue;
                mutexActivityIds.add(id);
            }
            activityMutexQueryRespDto.setMutexActivityIds(mutexActivityIds);
            list.add(activityMutexQueryRespDto);
        }
        return list;
    }

    private Map<Long, List<String>> setActivitySkusMapping(List<Long> activityIds, List<ItemSkuDto> itemSkuList) {
        List combinedIds = itemSkuList.stream().filter(item -> item.getIsCombinedPackage() == 1).map(ItemSkuDto::getActivityId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        HashMap mapping = Maps.newHashMap();
        for (Long activityId : activityIds) {
            ArrayList<String> shopSkuList = new ArrayList<String>(itemSkuList.size());
            for (ItemSkuDto itemSkuDto : itemSkuList) {
                boolean usable;
                if (itemSkuDto.getIsCombinedPackage() == 1 && !activityId.equals(itemSkuDto.getActivityId()) || itemSkuDto.getIsCombinedPackage() == 0 && combinedIds.contains(activityId) || !(usable = this.itemActivityService.apply(itemSkuDto.getItemId(), itemSkuDto.getSkuId(), activityId, itemSkuDto.getShopId()))) continue;
                shopSkuList.add(itemSkuDto.getShopId() + "_" + itemSkuDto.getSkuId() + "_" + itemSkuDto.getIfExchange() + "_" + itemSkuDto.getActivityId());
            }
            mapping.put(activityId, shopSkuList);
        }
        return mapping;
    }

    @Override
    public List<ExchangeActivityTargetRespDto> validateExchangeActivityTarget(ExchangeActivityTargetDto exchangeActivityTargetDto) {
        logger.info("validateExchangeActivityTarget\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)exchangeActivityTargetDto));
        Map shopItemIds = exchangeActivityTargetDto.getShopSkuIds();
        Map<Long, CustomerRespDto> customerRespDtoMap = exchangeActivityTargetDto.getCustomerRespDtos().stream().collect(Collectors.toMap(CustomerRespDto::getMerchantId, e -> e, (e1, e2) -> e2));
        if (shopItemIds == null || CollectionUtils.isEmpty(shopItemIds.keySet())) {
            return Lists.newArrayList();
        }
        HashSet skuIds = Sets.newHashSet();
        HashSet itemIds = Sets.newHashSet();
        for (List itemSkuDtos : shopItemIds.values()) {
            for (ItemSkuDto itemSkuDto : itemSkuDtos) {
                skuIds.add(itemSkuDto.getSkuId());
                itemIds.add(itemSkuDto.getItemId());
            }
        }
        ActivityEo eo = new ActivityEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"shop_id", exchangeActivityTargetDto.getShopSkuIds().keySet()));
        eo.setSqlFilters((List)sqlFilters);
        eo.setActivityTemplateId(exchangeActivityTargetDto.getActivityTemplateId());
        eo.setActivityStatus(ActivityStatusEnum.ACTIVATE.getKey());
        List activityEos = this.activityDas.select((BaseEo)eo);
        List activityIds = activityEos.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(activityIds)) {
            return Lists.newArrayList();
        }
        ActivityItemEo activityItemEo = new ActivityItemEo();
        sqlFilters.add(SqlFilter.in((String)"shop_id", exchangeActivityTargetDto.getShopSkuIds().keySet()));
        sqlFilters.add(SqlFilter.in((String)"activity_id", activityIds));
        sqlFilters.add(SqlFilter.in((String)"sku_id", (Object)skuIds));
        activityItemEo.setSqlFilters((List)sqlFilters);
        List activityItemEos = this.activityItemDas.select((BaseEo)activityItemEo);
        Map<String, ActivityItemEo> activityItemEoMap = activityItemEos.stream().collect(Collectors.toMap(e -> e.getShopId() + "#" + e.getSkuId() + "#" + e.getActivityId(), e -> e, (e1, e2) -> e1));
        logger.info("\u6d3b\u52a8\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(activityItemEoMap));
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)activityEos)) {
            Map<Long, List<ActivityEo>> shopActivityMap = activityEos.stream().collect(Collectors.groupingBy(StdActivityEo::getShopId));
            for (Map.Entry entry : shopItemIds.entrySet()) {
                if (!shopActivityMap.containsKey(entry.getKey())) continue;
                Long shopOrgId = ((ItemSkuDto)((List)entry.getValue()).get(0)).getShopOrgId();
                if (!customerRespDtoMap.containsKey(shopOrgId)) {
                    logger.info("\u5e97\u94fa\u5bf9\u5e94\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728,\u5e97\u94faID\uff1a{},\u5e97\u94fa\u7ec4\u7ec7\uff1a{}", entry.getKey(), (Object)shopOrgId);
                    continue;
                }
                CustomerRespDto customerInfo = customerRespDtoMap.get(shopOrgId);
                List<ActivityEo> eos = shopActivityMap.get(entry.getKey());
                ArrayList list = Lists.newArrayList();
                for (ActivityEo activityEo : eos) {
                    boolean isMatch = this.validateMatch(activityEo, customerInfo, exchangeActivityTargetDto.getMallType(), (Long)entry.getKey(), (List)entry.getValue());
                    logger.info("\u662f\u5426\u5339\u914d\u9002\u7528\u5546\u57ce\uff1a{}", (Object)isMatch);
                    if (!isMatch) continue;
                    boolean isClear = false;
                    if (Integer.valueOf(0).equals(activityEo.getSelectType())) {
                        list.clear();
                        isClear = true;
                    }
                    List<Long> matchItemIds = this.queryTagByItemId(activityEo, (Long)entry.getKey(), (List)entry.getValue());
                    for (ItemSkuDto itemSkuDto : (List)entry.getValue()) {
                        String key = itemSkuDto.getShopId() + "#" + itemSkuDto.getSkuId() + "#" + activityEo.getId();
                        if (!isClear && !activityItemEoMap.containsKey(key) && !matchItemIds.contains(itemSkuDto.getItemId())) continue;
                        ExchangeActivityTargetRespDto respDto = new ExchangeActivityTargetRespDto();
                        respDto.setActivityId(activityEo.getId());
                        respDto.setActivityName(activityEo.getActivityName());
                        respDto.setShopId((Long)entry.getKey());
                        respDto.setSkuId(itemSkuDto.getSkuId());
                        respDto.setActivityTag(activityEo.getTag());
                        list.add(respDto);
                    }
                    if (!isClear) continue;
                    break;
                }
                result.addAll(list);
            }
        }
        return result;
    }

    @Override
    public List<ExchangeActivityTargetRespDto> validateExchangeActivityList(ExchangeActivityTargetDto exchangeActivityTargetDto) {
        logger.info("validateExchangeActivityList\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)exchangeActivityTargetDto));
        Map shopItemIds = exchangeActivityTargetDto.getShopSkuIds();
        Map<Long, CustomerRespDto> customerRespDtoMap = exchangeActivityTargetDto.getCustomerRespDtos().stream().collect(Collectors.toMap(CustomerRespDto::getMerchantId, e -> e, (e1, e2) -> e2));
        if (shopItemIds == null || CollectionUtils.isEmpty(shopItemIds.keySet())) {
            return Lists.newArrayList();
        }
        HashSet skuIds = Sets.newHashSet();
        HashSet itemIds = Sets.newHashSet();
        for (List itemSkuDtos : shopItemIds.values()) {
            for (ItemSkuDto itemSkuDto : itemSkuDtos) {
                skuIds.add(itemSkuDto.getSkuId());
                itemIds.add(itemSkuDto.getItemId());
            }
        }
        ActivityEo eo = new ActivityEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"shop_id", exchangeActivityTargetDto.getShopSkuIds().keySet()));
        eo.setSqlFilters((List)sqlFilters);
        eo.setActivityTemplateId(exchangeActivityTargetDto.getActivityTemplateId());
        eo.setActivityStatus(ActivityStatusEnum.ACTIVATE.getKey());
        List activityEos = this.activityDas.select((BaseEo)eo);
        List activityIds = activityEos.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(activityIds)) {
            return Lists.newArrayList();
        }
        ActivityItemEo activityItemEo = new ActivityItemEo();
        sqlFilters.add(SqlFilter.in((String)"shop_id", exchangeActivityTargetDto.getShopSkuIds().keySet()));
        sqlFilters.add(SqlFilter.in((String)"activity_id", activityIds));
        sqlFilters.add(SqlFilter.in((String)"sku_id", (Object)skuIds));
        activityItemEo.setSqlFilters((List)sqlFilters);
        List activityItemEos = this.activityItemDas.select((BaseEo)activityItemEo);
        Map<String, ActivityItemEo> activityItemEoMap = activityItemEos.stream().collect(Collectors.toMap(e -> e.getShopId() + "#" + e.getSkuId() + "#" + e.getActivityId(), e -> e, (e1, e2) -> e1));
        logger.info("\u6d3b\u52a8\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(activityItemEoMap));
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)activityEos)) {
            Map<Long, List<ActivityEo>> shopActivityMap = activityEos.stream().collect(Collectors.groupingBy(StdActivityEo::getShopId));
            for (Map.Entry entry : shopItemIds.entrySet()) {
                if (!shopActivityMap.containsKey(entry.getKey())) continue;
                Long shopOrgId = ((ItemSkuDto)((List)entry.getValue()).get(0)).getShopOrgId();
                if (!customerRespDtoMap.containsKey(shopOrgId)) {
                    logger.info("\u5e97\u94fa\u5bf9\u5e94\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728,\u5e97\u94faID\uff1a{},\u5e97\u94fa\u7ec4\u7ec7\uff1a{}", entry.getKey(), (Object)shopOrgId);
                    continue;
                }
                CustomerRespDto customerInfo = customerRespDtoMap.get(shopOrgId);
                List<ActivityEo> eos = shopActivityMap.get(entry.getKey());
                for (ActivityEo activityEo : eos) {
                    boolean isMatch = this.validateMatch(activityEo, customerInfo, exchangeActivityTargetDto.getMallType(), (Long)entry.getKey(), (List)entry.getValue());
                    logger.info("\u662f\u5426\u5339\u914d\u9002\u7528\u5546\u57ce\uff1a{}", (Object)isMatch);
                    if (!isMatch) continue;
                    List<Long> matchItemIds = this.queryTagByItemId(activityEo, (Long)entry.getKey(), (List)entry.getValue());
                    for (ItemSkuDto itemSkuDto : (List)entry.getValue()) {
                        String key = itemSkuDto.getShopId() + "#" + itemSkuDto.getSkuId() + "#" + activityEo.getId();
                        boolean validateMatchItem = this.validateMatchItem(activityEo, key, activityItemEoMap, itemSkuDto.getItemId(), matchItemIds);
                        logger.info("\u5546\u54c1\u662f\u5426\u5339\u914d\uff1a\u5546\u54c1id\uff1a{},\u5339\u914d\u7ed3\u679c\uff1a{},\u4f7f\u7528\u5546\u54c1\uff1a{}", new Object[]{itemSkuDto.getItemId(), validateMatchItem, JSON.toJSONString(matchItemIds)});
                        if (!validateMatchItem) continue;
                        ExchangeActivityTargetRespDto respDto = new ExchangeActivityTargetRespDto();
                        respDto.setActivityId(activityEo.getId());
                        respDto.setActivityName(activityEo.getActivityName());
                        respDto.setShopId((Long)entry.getKey());
                        respDto.setSkuId(itemSkuDto.getSkuId());
                        respDto.setActivityTag(activityEo.getTag());
                        result.add(respDto);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public List<NotSupportSingleItemDto> queryNotSupportSingleItem(SupportSingleItemDto supportSingleItemDto) {
        logger.info("[\u67e5\u8be2\u4e0d\u652f\u6301\u5355\u72ec\u8d2d\u4e70\u5546\u54c1]\uff0c\u5165\u53c2\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)supportSingleItemDto));
        return this.itemActivityStockeEsServiceImpl.queryNotSupportSingleItem(supportSingleItemDto);
    }

    @Override
    public List<NotSupportSingleItemDto> queryConflictSingleItems(ConflictSingleItemReqDto conflictSingleItemReqDto) {
        logger.info("[\u67e5\u8be2\u53ef\u80fd\u5b58\u5728\u51b2\u7a81\u7684\u5546\u54c1]\uff0c\u5165\u53c2\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)conflictSingleItemReqDto));
        return this.itemActivityStockeEsServiceImpl.queryConflictSingleItems(conflictSingleItemReqDto);
    }

    @Override
    public PageInfo<NotSupportSingleItemDto> queryCustomerSingleItemPage(SupportSingleItemDto supportSingleItemDto) {
        return this.itemActivityStockeEsServiceImpl.queryCustomerSingleItemPage(supportSingleItemDto);
    }

    private boolean validateMatchItem(ActivityEo activityEo, String key, Map<String, ActivityItemEo> activityItemEoMap, Long itemId, List<Long> matchItemIds) {
        return Integer.valueOf(0).equals(activityEo.getSelectType()) || activityItemEoMap.containsKey(key) || matchItemIds.contains(itemId);
    }

    public static void main(String[] args) {
        JSONObject jsonObject1 = JSON.parseObject((String)"{\"TargetCustomerCondition.value\":{\"customerTypeIds\":[1288863869820880907]},\"TargetCustomerCondition.type\":1}");
        JSONObject jsonObject = jsonObject1.getJSONObject("TargetCustomerCondition.value");
        JSONArray customerAreaCodes = jsonObject.getJSONArray("customerAreaCodes");
        JSONArray customerTypeIds = jsonObject.getJSONArray("customerTypeIds");
        System.out.println(customerAreaCodes);
        System.out.println(customerTypeIds);
    }

    private boolean validateMatch(ActivityEo activityEo, CustomerRespDto customerRespDto, Integer mallType, Long shopId, List<ItemSkuDto> itemSkuDtos) {
        Boolean targetMall = this.activityPreviewService.validateTargetMall(activityEo.getId(), Integer.valueOf(1));
        logger.info("\u6d3b\u52a8\u4fe1\u606f\uff1a{},\u6765\u6e90\uff1a{},\u662f\u5426\u5339\u914d\u9002\u7528\u5546\u57ce\uff1a{}", new Object[]{JSON.toJSONString((Object)activityEo), mallType, targetMall});
        if (targetMall.booleanValue()) {
            return this.activityPreviewService.validateTargetCustomer(activityEo.getId(), customerRespDto.getId(), customerRespDto);
        }
        return false;
    }

    private List<Long> queryTagByItemId(ActivityEo activityEo, Long shopId, List<ItemSkuDto> itemSkuDtos) {
        List<Object> list = Lists.newArrayList();
        if (Integer.valueOf(2).equals(activityEo.getSelectType())) {
            ItemActivityTagQueryReqDto searchVo = new ItemActivityTagQueryReqDto();
            searchVo.setShopId(shopId);
            searchVo.setActivityId(activityEo.getId());
            searchVo.setItemIdList(itemSkuDtos.stream().map(ItemSkuDto::getItemId).collect(Collectors.toList()));
            logger.info("\u67e5\u8be2\u6d3b\u52a8\u6807\u7b7e\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)searchVo));
            List itemActivityTagDtos = this.itemActivityTagService.queryList(searchVo);
            logger.info("\u67e5\u8be2\u6d3b\u52a8\u6807\u7b7e\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)itemActivityTagDtos));
            list = itemActivityTagDtos.stream().map(ItemActivityTagDto::getItemId).collect(Collectors.toList());
        }
        return list;
    }

    private JSONObject queryRuleByActiveIdAndConditionTemId(Long activityId, Long templateId) {
        ConditionEo conditionEo = new ConditionEo();
        conditionEo.setActivityId(activityId);
        conditionEo.setConditionTemplateId(templateId);
        conditionEo = (ConditionEo)this.conditionDas.selectOne((BaseEo)conditionEo);
        JSONObject jsonObject = null;
        if (conditionEo != null) {
            String conditionParams = conditionEo.getConditionParams();
            jsonObject = JSON.parseObject((String)conditionParams);
        }
        logger.info("\u67e5\u8be2\u89c4\u5219\uff1a{}", (Object)JSON.toJSONString(jsonObject));
        return jsonObject;
    }
}

