/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.biz.activity.engine.condition;

import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityItemService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.conf.param.ActivityStockTypeParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityStockCondition
extends ConditionTemplate {
    private static Logger logger = LoggerFactory.getLogger(ActivityStockCondition.class);
    @Resource
    private IActivityItemService activityItemService;
    @CubeResource
    private ActivityStockTypeParam activityStockTypeParam;

    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T params, Map<String, ?> activityParams) {
        if (!params.getActivityStockFlag().booleanValue()) {
            return true;
        }
        Integer stockType = (Integer)this.activityStockTypeParam.getValue();
        logger.info("\u6d3b\u52a8id={}\uff0c\u5254\u9664\u6d3b\u52a8\u5e93\u5b58\u4e0d\u8db3\u7684\u6d3b\u52a8\u5904\u7406\uff0c\u8bfb\u53d6\u914d\u7f6e\u9879={}", (Object)params.getActivityId(), (Object)stockType);
        List items = params.getItems();
        List activityItemRespDtos = this.activityItemService.queryActivityItems(Long.valueOf(params.getActivityId()), null);
        if (CollectionUtils.isEmpty((Collection)activityItemRespDtos)) {
            if (ActivityStockTypeParam.SHARE.equals(stockType)) {
                return true;
            }
            boolean flag = this.activityItemService.validateBranchItemStock(items);
            if (!flag) {
                params.setHandleActivityFlag(Boolean.valueOf(false));
            }
            return flag;
        }
        Map<String, ItemVo> itemNumMap = items.stream().collect(Collectors.toMap(o -> o.getShopId() + "_" + o.getSkuId(), o -> o, (o1, o2) -> o1));
        ArrayList<ItemVo> needItems = new ArrayList<ItemVo>();
        for (ActivityItemRespDto itemRespDto : activityItemRespDtos) {
            ItemVo itemVo = itemNumMap.get(itemRespDto.getShopId() + "_" + itemRespDto.getSkuId());
            if (Objects.isNull(itemVo)) continue;
            if (ActivityStockTypeParam.PREEMPT.equals(stockType) && itemRespDto.getActivityStock() == -1L) {
                needItems.add(itemVo);
            }
            if (itemRespDto.getActivityStock() != null && itemRespDto.getActivityStock() == -1L) continue;
            if (itemRespDto.getActivityStock() == null || itemRespDto.getActivityStock() <= 0L) {
                params.setHandleActivityFlag(Boolean.valueOf(false));
                return false;
            }
            if ((long)itemVo.getNum() <= itemRespDto.getActivityStock()) continue;
            params.setHandleActivityFlag(Boolean.valueOf(false));
            itemVo.getLackRemainingStockMap().put(params.getActivityId(), itemRespDto.getActivityStock());
            return false;
        }
        if (ActivityStockTypeParam.PREEMPT.equals(stockType) && CollectionUtils.isNotEmpty(needItems)) {
            boolean flag = this.activityItemService.validateBranchItemStock(needItems);
            if (!flag) {
                params.setHandleActivityFlag(Boolean.valueOf(false));
            }
            return flag;
        }
        return true;
    }
}

