/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.biz.activity.engine.condition;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.TargetCustomerInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.TargetCustomerType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ILoadConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.seckill.util.SeckillKeyUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetCustomerCondition
extends ConditionTemplate
implements ILoadConditionTemplate {
    private static final String TARGET_CUSTOMER_TYPE = "TargetCustomerCondition.type";
    private static final String TARGET_CUSTOMER_TYPE_VALUE = "TargetCustomerCondition.value";
    private static final Logger logger = LoggerFactory.getLogger(TargetCustomerCondition.class);
    @Resource
    private ICacheService commonCacheService;

    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T context, Map<String, ?> configParams) {
        if (!context.getPopulationFlag().booleanValue()) {
            return true;
        }
        Param param = define.getParam(TARGET_CUSTOMER_TYPE);
        if (null == param) {
            throw new ProBizException("\u76ee\u6807\u5ba2\u6237\u7c7b\u578b\u672a\u914d\u7f6e");
        }
        Object data = configParams.get(TARGET_CUSTOMER_TYPE);
        TargetCustomerType populationType = null;
        if (null != data) {
            logger.warn("\u89e3\u6790\u51fa\u6765\u7684\u662f=={}", (Object)JSONObject.toJSONString(data));
            Integer type = (Integer)ConditionTemplate.converter(configParams.get(TARGET_CUSTOMER_TYPE), (Param)param, (String)define.getLoadClass());
            populationType = TargetCustomerType.getByType((Integer)type);
        }
        if (null == populationType) {
            populationType = TargetCustomerType.ALL;
        }
        TargetCustomerInfoDto value = this.getPopulationValue(define, configParams);
        switch (populationType) {
            case ALL: {
                return true;
            }
            case CATEGORY: {
                return this.category(context.getUserId(), value, context.getCouponTemplateId());
            }
            case CROWD: {
                return this.crowd(context.getUserId(), value);
            }
        }
        throw new ProBizException("\u76ee\u6807\u5ba2\u6237\u7c7b\u578b\u9519\u8bef");
    }

    private boolean category(Long userId, TargetCustomerInfoDto value, Long couponTemplateId) {
        if (Objects.isNull(value)) {
            return true;
        }
        StringBuilder msg = new StringBuilder();
        msg.append("\u5ba2\u6237[").append(userId).append("]\u4e0d\u5728\u76ee\u6807\u5ba2\u6237\u8303\u56f4\u4e2d\uff0c\u6ca1\u6709\u8d44\u683c");
        if (null != couponTemplateId && couponTemplateId > 0L) {
            msg.append("\u9886\u53d6\u54e6~");
        } else {
            msg.append("\u53c2\u4e0e\u6d3b\u52a8\u54e6~");
        }
        CustomerRespDto customerInfo = (CustomerRespDto)((ICustomerQueryApi)SpringBeanUtil.getBean(ICustomerQueryApi.class)).queryById(userId).getData();
        if (Objects.nonNull(customerInfo)) {
            Long customerTypeId = customerInfo.getCustomerTypeId();
            List regionCodeList = customerInfo.getRegionCodeList();
            List customerTypeIds = value.getCustomerTypeIds();
            List customerAreaCodes = value.getCustomerAreaCodes();
            List subAreaCodes = value.getSubAreaCodes();
            List blackCustomerIds = value.getBlackCustomerIds();
            if (CollectionUtils.isEmpty((Collection)subAreaCodes)) {
                subAreaCodes = customerAreaCodes;
            }
            if (!CollectionUtils.isEmpty((Collection)customerTypeIds) && !customerTypeIds.contains(customerTypeId)) {
                throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{msg.toString()}));
            }
            if (!CollectionUtils.isEmpty((Collection)subAreaCodes)) {
                regionCodeList.retainAll(subAreaCodes);
                if (CollectionUtils.isEmpty((Collection)regionCodeList)) {
                    throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{msg.toString()}));
                }
            }
            if (!CollectionUtils.isEmpty((Collection)blackCustomerIds) && blackCustomerIds.contains(userId)) {
                throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{msg.toString()}));
            }
        }
        return true;
    }

    private boolean crowd(Long userId, TargetCustomerInfoDto value) {
        if (Objects.isNull(value) || CollectionUtils.isEmpty((Collection)value.getCustomerIds())) {
            return true;
        }
        if (value.getCustomerIds().contains(userId)) {
            return true;
        }
        throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u5ba2\u6237[" + userId + "]\u4e0d\u5728\u76ee\u6807\u5ba2\u6237\u8303\u56f4[" + StringUtils.join((Iterable)value.getCustomerIds(), (String)",") + "]\u4e2d\uff0c\u6ca1\u6709\u8d44\u683c\u53c2\u52a0\u6d3b\u52a8"}));
    }

    private TargetCustomerInfoDto getPopulationValue(TemplateDefine define, Map<String, ?> configParams) {
        Param param = define.getParam(TARGET_CUSTOMER_TYPE_VALUE);
        if (param != null && configParams.get(TARGET_CUSTOMER_TYPE_VALUE) != null) {
            return (TargetCustomerInfoDto)ConditionTemplate.converter(configParams.get(TARGET_CUSTOMER_TYPE_VALUE), (Param)param, (String)define.getLoadClass());
        }
        return null;
    }

    public void load(TemplateDefine define, ConditionRespDto conditionRespDto, Map<String, ?> activityParams, int expire) {
        Long activityId = conditionRespDto.getActivityId();
        logger.info("\u3010activityId={}\u3011\u6d3b\u52a8\u52a0\u8f7d\u5ba2\u6237\u6761\u4ef6\u7684\u76ee\u6807\u5ba2\u6237\u5f00\u59cb=====", (Object)activityId);
        Param param = define.getParam(TARGET_CUSTOMER_TYPE);
        Integer type = (Integer)ConditionTemplate.converter(activityParams.get(TARGET_CUSTOMER_TYPE), (Param)param, (String)define.getLoadClass());
        TargetCustomerType populationType = TargetCustomerType.getByType((Integer)type);
        if (populationType == null) {
            logger.info("\u3010activityId={}\u3011\u6d3b\u52a8\u5ba2\u6237\u6761\u4ef6\u672a\u914d\u7f6e", (Object)activityId);
        }
        if (populationType != null) {
            TargetCustomerInfoDto targetCustomer = this.getPopulationValue(define, activityParams);
            if (Objects.isNull(targetCustomer)) {
                logger.info("\u3010activityId={}\u3011\u6d3b\u52a8\u6761\u4ef6\u5ba2\u6237\u4fe1\u606f\u672a\u914d\u7f6e", (Object)activityId);
            } else {
                targetCustomer.setType(type);
            }
            this.commonCacheService.setCache(SeckillKeyUtil.getCacheKey((String)"activity_target_customer", (Long)activityId), (Object)JSON.toJSONString((Object)targetCustomer), expire);
        }
        logger.info("\u3010activityId={}\u3011\u6d3b\u52a8\u52a0\u8f7d\u5ba2\u6237\u6761\u4ef6\u7684\u76ee\u6807\u5ba2\u6237\u7ed3\u675f=====", (Object)activityId);
    }
}

